/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.acoustics.ChanceAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.DelayedAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.EventSelectorAcoustics;
import eu.ha3.presencefootsteps.sound.acoustics.SimultaneousAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.VaryingAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.WeightedAcoustic;
import eu.ha3.presencefootsteps.util.Range;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Reader;
import java.util.Map;

public final class AcousticsJsonParser {
    private static final int ENGINEVERSION = 1;
    private static final Map<String, AcousticFactory> FACTORIES = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap((Object[])new String[]{"basic", "events", "simultaneous", "delayed", "probability", "chance"}, (Object[])new AcousticFactory[]{VaryingAcoustic::fromJson, EventSelectorAcoustics::fromJson, SimultaneousAcoustic::fromJson, DelayedAcoustic::fromJson, WeightedAcoustic::fromJson, ChanceAcoustic::fromJson}));
    private Range defaultVolume = Range.exactly(1.0f);
    private Range defaultPitch = Range.exactly(1.0f);
    private final AcousticLibrary lib;
    private String soundRoot = "";

    public AcousticsJsonParser(AcousticLibrary lib) {
        this.lib = lib;
    }

    public void parse(Reader reader) {
        try {
            this.doParse(reader);
        }
        catch (JsonParseException e) {
            PresenceFootsteps.logger.error("Error whilst loading acoustics", (Throwable)e);
        }
    }

    private void doParse(Reader reader) throws JsonParseException {
        this.soundRoot = "";
        this.defaultVolume = Range.exactly(1.0f);
        this.defaultPitch = Range.exactly(1.0f);
        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        if (!"library".equals(json.get("type").getAsString())) {
            throw new JsonParseException("Invalid type: \"library\"");
        }
        if (json.get("engineversion").getAsInt() != 1) {
            throw new JsonParseException("Unrecognised Engine version: 1 expected, got " + json.get("engineversion").getAsInt());
        }
        if (!json.has("contents")) {
            throw new JsonParseException("Empty contents");
        }
        if (json.has("soundroot")) {
            this.soundRoot = json.get("soundroot").getAsString();
        }
        if (json.has("defaults")) {
            JsonObject defaults = json.getAsJsonObject("defaults");
            this.defaultVolume = this.defaultVolume.read("vol", defaults, this);
            this.defaultPitch = this.defaultPitch.read("pitch", defaults, this);
        }
        json.getAsJsonObject("contents").entrySet().forEach(element -> this.lib.addAcoustic((String)element.getKey(), this.solveAcoustic((JsonElement)element.getValue(), "events")));
    }

    public Acoustic solveAcoustic(JsonElement unsolved) throws JsonParseException {
        return this.solveAcoustic(unsolved, "basic");
    }

    private Acoustic solveAcoustic(JsonElement unsolved, String defaultUnassigned) throws JsonParseException {
        Acoustic ret = null;
        if (unsolved.isJsonObject()) {
            ret = this.solveAcousticsCompound(unsolved.getAsJsonObject(), defaultUnassigned);
        } else if (unsolved.isJsonArray()) {
            ret = SimultaneousAcoustic.of(unsolved.getAsJsonArray(), this);
        } else if (unsolved.isJsonPrimitive() && unsolved.getAsJsonPrimitive().isString()) {
            ret = VaryingAcoustic.of(unsolved.getAsString(), this);
        }
        if (ret == null) {
            throw new JsonParseException("Unresolved Json element: \r\n" + unsolved.toString());
        }
        return ret;
    }

    private Acoustic solveAcousticsCompound(JsonObject unsolved, String defaultUnassigned) throws JsonParseException {
        String type;
        String string = type = unsolved.has("type") ? unsolved.get("type").getAsString() : defaultUnassigned;
        if (!FACTORIES.containsKey(type)) {
            throw new JsonParseException("Invalid type for acoustic `" + type + "`");
        }
        return FACTORIES.get(type).create(unsolved, this);
    }

    public Range getVolumeRange() {
        return this.defaultVolume;
    }

    public Range getPitchRange() {
        return this.defaultPitch;
    }

    public String getSoundName(String soundName) {
        if (soundName.charAt(0) != '@') {
            return this.soundRoot + soundName;
        }
        return soundName.replace("@", "");
    }

    public float getPercentage(JsonObject object, String param) {
        return object.get(param).getAsFloat() / 100.0f;
    }

    public static interface AcousticFactory {
        public Acoustic create(JsonObject var1, AcousticsJsonParser var2);
    }
}

