/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.ClientFontHelper;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.layout.LayoutHelper;
import net.createmod.catnip.layout.PaginationState;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderTagScreen;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PonderTagIndexScreen
extends AbstractPonderScreen {
    protected List<ModTagsEntry> currentModTagEntries = new LinkedList<ModTagsEntry>();
    protected List<Map.Entry<String, List<PonderTag>>> sortedModTags = List.of();
    protected PaginationState paginationState = new PaginationState();
    @Nullable
    protected PonderButton pageNext;
    @Nullable
    protected PonderButton pagePrev;
    @Nullable
    private PonderTag hoveredItem = null;

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Map<String, List<PonderTag>> tagsByModID = PonderIndex.getTagAccess().getListedTags().stream().collect(Collectors.groupingBy(tag -> tag.getId().m_135827_()));
        this.sortedModTags = new TreeMap<String, List<PonderTag>>(tagsByModID).entrySet().stream().toList();
        int modCount = this.sortedModTags.size();
        int maxModsOnScreen = (this.f_96544_ - 140 - 40) / 58;
        this.paginationState = new PaginationState(modCount > 1 && modCount > maxModsOnScreen, maxModsOnScreen, modCount);
        this.setupModTagEntries();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        int xOffset = (int)((double)this.f_96543_ * 0.5);
        this.pagePrev = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(xOffset - 120, this.f_96544_ - 32).showing(PonderGuiTextures.ICON_PONDER_LEFT)).withCallback(() -> {
            this.paginationState.previousPage();
            this.updateAfterPaginationChange();
        })).setActive(false);
        this.m_142416_(this.pagePrev);
        this.pagePrev.updateGradientFromState();
        this.pageNext = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(xOffset + 100, this.f_96544_ - 32).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).withCallback(() -> {
            this.paginationState.nextPage();
            this.updateAfterPaginationChange();
        })).setActive(true);
        this.m_142416_(this.pageNext);
    }

    protected void setupModTagEntries() {
        this.removeWidgets(this.m_6702_().stream().filter(widget -> {
            if (!(widget instanceof PonderButton)) {
                return false;
            }
            PonderButton ponderButton = (PonderButton)widget;
            return ponderButton.tag != null;
        }).toList());
        this.currentModTagEntries.clear();
        AtomicInteger yOffset = new AtomicInteger(140);
        int xOffset = (int)((double)this.f_96543_ * 0.5);
        this.paginationState.iterateForCurrentPage((iPage, iOverall) -> {
            Map.Entry<String, List<PonderTag>> entry = this.sortedModTags.get((int)iOverall);
            String modName = CatnipServices.PLATFORM.getModDisplayName(entry.getKey());
            List<PonderTag> tags = entry.getValue();
            LayoutHelper layout = LayoutHelper.centeredHorizontal(tags.size(), 1, 28, 28, 8);
            Rect2i layoutArea = layout.getArea();
            for (PonderTag tag : tags) {
                PonderButton button = (PonderButton)((AbstractSimiWidget)new PonderButton(xOffset + layout.getX() + 4, yOffset.get() + layout.getY() + 18).showingTag(tag)).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(new PonderTagScreen(tag));
                });
                this.m_142416_(button);
                layout.next();
            }
            this.currentModTagEntries.add(new ModTagsEntry(modName, tags.size(), layoutArea, yOffset.get()));
            yOffset.addAndGet(68);
        });
        for (int i = 0; i < this.paginationState.getElementsPerPage() && this.paginationState.getStartIndex() + i < this.sortedModTags.size(); ++i) {
        }
    }

    protected void updateAfterPaginationChange() {
        this.setupModTagEntries();
        ((PonderButton)this.pagePrev.setActive(this.paginationState.hasPreviousPage())).animateGradientFromState();
        ((PonderButton)this.pageNext.setActive(this.paginationState.hasNextPage())).animateGradientFromState();
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(PonderGuiTextures.ICON_PONDER_IDENTIFY);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = null;
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).m_5953_(mouseX, mouseY)) continue;
            this.hoveredItem = button.getTag();
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.f_96543_ / 2.0, 30.0, 0.0);
        poseStack.m_85836_();
        poseStack.m_252880_(-120.0f, 0.0f, 0.0f);
        String title = Ponder.lang().translate("ui.welcome", new Object[0]).string();
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(0.0f, 0.0f, 0.0f).withBounds(30, 30).render(graphics);
        PonderGuiTextures.LOGO.render(graphics, -1, -1);
        poseStack.m_252880_(34.0f, -3.0f, 0.0f);
        int streakHeight = 36;
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, 280);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        graphics.m_280056_(this.f_96547_, title, 3, 5, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, 50.0f, 0.0f);
        poseStack.m_85836_();
        int maxWidth = (int)((float)this.f_96543_ * 0.5f);
        String desc = Ponder.lang().translate("ui.index_description", new Object[0]).string();
        int descWidth = this.f_96547_.m_92895_(desc);
        if (descWidth + 2 < maxWidth) {
            maxWidth = descWidth + 2;
        }
        int descHeight = this.f_96547_.m_92920_(desc, maxWidth);
        poseStack.m_252880_((float)(-maxWidth) / 2.0f, 0.0f, 0.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(-3.0f, -3.0f, 0.0f).withBounds(maxWidth + 6, descHeight + 5).render(graphics);
        ClientFontHelper.drawSplitString(poseStack, this.f_96547_, desc, 0, 0, maxWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, -80.0f, 0.0f);
        for (ModTagsEntry entry : this.currentModTagEntries) {
            poseStack.m_85836_();
            this.renderTagsEntry(graphics, entry);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    protected void renderTagsEntry(GuiGraphics graphics, ModTagsEntry entry) {
        PoseStack poseStack = graphics.m_280168_();
        int layoutWidth = entry.layoutArea().m_110090_();
        int layoutHeight = entry.layoutArea().m_110091_();
        poseStack.m_252880_(0.0f, (float)entry.yPos(), 0.0f);
        String categories = Ponder.lang().translate("ui.categories", entry.modName()).string();
        int stringWidth = this.f_96547_.m_92895_(categories);
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-stringWidth) / 2.0f, -20.0f, 0.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(-3.0f, -1.0f, 0.0f).withBounds(stringWidth + 6, 10).render(graphics);
        graphics.m_280056_(this.f_96547_, categories, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.m_85849_();
        int extraLength = Mth.m_14045_((int)entry.tagCount, (int)2, (int)8);
        UIRenderHelper.streak(graphics, 0.0f, 0, layoutHeight / 2, layoutHeight + 6, layoutWidth / 2 + extraLength * 15);
        UIRenderHelper.streak(graphics, 180.0f, 0, layoutHeight / 2, layoutHeight + 6, layoutWidth / 2 + extraLength * 15);
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        if (this.hoveredItem != null) {
            List<Component> list = FontHelper.cutStringTextComponent(this.hoveredItem.getDescription(), FontHelper.Palette.ALL_GRAY);
            list.add(0, (Component)Component.m_237113_((String)this.hoveredItem.getTitle()));
            graphics.m_280666_(this.f_96547_, list, mouseX, mouseY);
        }
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public void m_7861_() {
        super.m_7861_();
        this.hoveredItem = null;
    }

    public record ModTagsEntry(String modName, int tagCount, Rect2i layoutArea, int yPos) {
    }
}

