/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

public class PonderProgressBar
extends AbstractSimiWidget {
    public static final Couple<Color> BAR_COLORS = Couple.create(new Color(-2136298787, true), new Color(1353362141, true)).map(Color::setImmutable);
    LerpedFloat progress;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
    }

    @Override
    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.ponder.getActiveScene().getKeyframeCount() > 0 && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_ + 4) && mouseY >= (double)this.m_252907_() - 3.0 && mouseY < (double)(this.m_252907_() + this.f_93619_ + 20);
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(false);
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == activeScene.getKeyframeCount()) {
            this.ponder.seekToTime(activeScene.getTotalTime());
        } else {
            this.ponder.seekToTime(activeScene.getKeyframeTime(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        int totalTime = activeScene.getTotalTime();
        int clickedAtTime = (int)((mouseX - (double)this.m_252754_()) / ((double)this.f_93618_ + 4.0) * (double)totalTime);
        int lastKeyframeTime = activeScene.getKeyframeTime(activeScene.getKeyframeCount() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return activeScene.getKeyframeCount();
        }
        int index = -1;
        int i = 0;
        while (i < activeScene.getKeyframeCount() && (keyframeTime = activeScene.getKeyframeTime(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = graphics.m_280168_();
        this.f_93622_ = this.m_93680_(mouseX, mouseY);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(this.m_252754_(), this.m_252907_(), 400.0f).withBounds(this.f_93618_, this.f_93619_).render(graphics);
        poseStack.m_85836_();
        poseStack.m_252880_((float)(this.m_252754_() - 2), (float)(this.m_252907_() - 2), 100.0f);
        poseStack.m_85836_();
        poseStack.m_85841_((float)(this.f_93618_ + 4) * this.progress.getValue(partialTicks), 1.0f, 1.0f);
        Color c1 = (Color)BAR_COLORS.getFirst();
        Color c2 = (Color)BAR_COLORS.getSecond();
        UIRenderHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 310, 0.0f, 1.0f, 1.0f, 3.0f, c1, c1);
        UIRenderHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 310, 0.0f, 3.0f, 1.0f, 4.0f, c2, c2);
        poseStack.m_85849_();
        this.renderKeyframes(graphics, mouseX, partialTicks);
        poseStack.m_85849_();
    }

    private void renderKeyframes(GuiGraphics graphics, int mouseX, float partialTicks) {
        PonderScene activeScene = this.ponder.getActiveScene();
        Couple<Color> hover = PonderUI.COLOR_HOVER.map(c -> c.setAlpha(224));
        Couple<Color> idle = PonderUI.COLOR_HOVER.map(c -> c.setAlpha(112));
        int hoverIndex = this.f_93622_ ? this.getHoveredKeyframeIndex(activeScene, mouseX) : -2;
        if (hoverIndex == -1) {
            this.drawKeyframe(graphics, activeScene, true, 0, 0, (Color)hover.getFirst(), (Color)hover.getSecond(), 8);
        } else if (hoverIndex == activeScene.getKeyframeCount()) {
            this.drawKeyframe(graphics, activeScene, true, activeScene.getTotalTime(), this.f_93618_ + 4, (Color)hover.getFirst(), (Color)hover.getSecond(), 8);
        }
        for (int i = 0; i < activeScene.getKeyframeCount(); ++i) {
            int keyframeTime = activeScene.getKeyframeTime(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.getTotalTime() * (float)(this.f_93618_ + 2));
            boolean selected = i == hoverIndex;
            Couple<Color> colors = selected ? hover : idle;
            int height = selected ? 8 : 4;
            this.drawKeyframe(graphics, activeScene, selected, keyframeTime, keyframePos, (Color)colors.getFirst(), (Color)colors.getSecond(), height);
        }
    }

    private void drawKeyframe(GuiGraphics graphics, PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, Color startColor, Color endColor, int height) {
        PoseStack poseStack = graphics.m_280168_();
        if (selected) {
            int offset;
            String text;
            Font font = Minecraft.m_91087_().f_91062_;
            UIRenderHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 320, keyframePos, 9.0f, (float)keyframePos + 2.0f, 9.0f + (float)height, endColor, startColor);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 320.0f);
            if (activeScene.getCurrentTime() < keyframeTime) {
                text = ">";
                offset = -2 - font.m_92895_(text);
            } else {
                text = "<";
                offset = 4;
            }
            graphics.m_280614_(font, (Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.BOLD), keyframePos + offset, 10, endColor.getRGB(), false);
            poseStack.m_85849_();
        }
        UIRenderHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 320, keyframePos, 0.0f, (float)keyframePos + 2.0f, 1.0f + (float)height, startColor, endColor);
    }

    public void m_7435_(SoundManager handler) {
    }
}

