/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.layout.LayoutHelper;
import net.createmod.catnip.layout.PaginationState;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.registration.PonderIndexExclusionHelper;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PonderIndexScreen
extends AbstractPonderScreen {
    protected final List<ItemEntry> items;
    protected List<PonderButton> paginatedWidgets = new ArrayList<PonderButton>();
    protected PaginationState paginationState = new PaginationState();
    protected Rect2i maxScreenArea = new Rect2i(0, 0, 0, 0);
    protected Rect2i usedArea = new Rect2i(0, 0, 0, 0);
    protected int maxItemRows;
    protected int maxItemsPerRow;
    protected int maxItemsPerPage;
    @Nullable
    protected PonderButton nextPage;
    @Nullable
    protected PonderButton prevPage;
    private ItemStack hoveredItem = ItemStack.f_41583_;
    private final List<Predicate<ItemLike>> exclusions;

    public PonderIndexScreen() {
        this.items = new ArrayList<ItemEntry>();
        this.exclusions = PonderIndex.streamPlugins().flatMap(PonderIndexExclusionHelper::pluginToExclusions).toList();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.items.clear();
        PonderIndex.getSceneAccess().getRegisteredEntries().stream().map(Map.Entry::getKey).distinct().map(key -> new ItemEntry(CatnipServices.REGISTRIES.getItemOrBlock((ResourceLocation)key), (ResourceLocation)key)).filter(entry -> entry.item != null).filter(this::isItemIncluded).forEach(this.items::add);
        this.items.sort(Comparator.comparing(ItemEntry::key));
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int targetWidth = Mth.m_14045_((int)(this.f_96543_ - 180), (int)250, (int)400);
        int targetHeight = Mth.m_14045_((int)(this.f_96544_ - 140), (int)150, (int)300);
        this.maxScreenArea = new Rect2i(centerX - targetWidth / 2, centerY - targetHeight / 2, targetWidth, targetHeight);
        this.maxItemRows = (this.maxScreenArea.m_110091_() + 8) / 36;
        this.maxItemsPerRow = (this.maxScreenArea.m_110090_() + 8) / 36;
        this.maxItemsPerPage = this.maxItemRows * this.maxItemsPerRow;
        this.paginationState = new PaginationState(this.items.size() > this.maxItemsPerPage, this.maxItemsPerPage, this.items.size());
        this.setupItemsForPage();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        this.prevPage = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(centerX - 100, this.maxScreenArea.m_110086_() + this.maxScreenArea.m_110091_() + 10).showing(PonderGuiTextures.ICON_PONDER_LEFT)).withCallback(() -> {
            this.paginationState.previousPage();
            this.updateAfterPaginationChange();
        })).setActive(false);
        this.m_142416_(this.prevPage);
        this.nextPage = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(centerX + 80, this.maxScreenArea.m_110086_() + this.maxScreenArea.m_110091_() + 10).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).withCallback(() -> {
            this.paginationState.nextPage();
            this.updateAfterPaginationChange();
        })).setActive(true);
        this.m_142416_(this.nextPage);
        this.prevPage.updateGradientFromState();
        this.nextPage.updateGradientFromState();
    }

    protected void setupItemsForPage() {
        this.removeWidgets(this.paginatedWidgets);
        int itemCount = this.paginationState.getCurrentPageElementCount();
        int actualItemRows = Mth.m_14045_((int)((int)Math.ceil((double)itemCount / (double)this.maxItemsPerRow)), (int)1, (int)this.maxItemRows);
        LayoutHelper layoutHelper = LayoutHelper.centeredHorizontal(itemCount, actualItemRows, 28, 28, 8);
        this.usedArea = layoutHelper.getArea();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.paginationState.iterateForCurrentPage((iPage, iOverall) -> {
            ItemEntry entry = this.items.get((int)iOverall);
            PonderButton b = (PonderButton)((AbstractSimiWidget)new PonderButton(centerX + layoutHelper.getX() + 4, centerY + layoutHelper.getY() + 4).showing(new ItemStack(entry.item))).withCallback((x, y) -> {
                if (!PonderIndex.getSceneAccess().doScenesExistForId(entry.key)) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack(entry.item)));
            });
            this.paginatedWidgets.add(b);
            this.m_142416_(b);
            layoutHelper.next();
        });
    }

    protected void updateAfterPaginationChange() {
        this.setupItemsForPage();
        ((PonderButton)this.prevPage.setActive(this.paginationState.hasPreviousPage())).animateGradientFromState();
        ((PonderButton)this.nextPage.setActive(this.paginationState.hasNextPage())).animateGradientFromState();
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(PonderGuiTextures.ICON_PONDER_IDENTIFY);
    }

    private boolean isItemIncluded(ItemEntry entry) {
        return this.exclusions.stream().noneMatch(predicate -> predicate.test(entry.item));
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.f_41583_;
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            if (!(child instanceof PonderButton) || !(button = (PonderButton)child).m_5953_(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem() != null ? button.getItem() : ItemStack.f_41583_;
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, this.usedArea.m_110085_() - 10, this.usedArea.m_110086_() - 20, 20, 220);
        graphics.m_280056_(this.f_96547_, "Items to inspect", this.usedArea.m_110085_() - 5, this.usedArea.m_110086_() - 25, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.m_85849_();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)(this.maxScreenArea.m_110086_() + this.maxScreenArea.m_110091_() + 14), 0.0f);
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        String pageString = "Page " + (this.paginationState.getPageIndex() + 1) + "/" + this.paginationState.getMaxPages();
        int stringWidth = this.f_96547_.m_92895_(pageString);
        UIRenderHelper.streak(graphics, 0.0f, 0, 4, 14, 85);
        UIRenderHelper.streak(graphics, 180.0f, 0, 4, 14, 85);
        graphics.m_280056_(this.f_96547_, pageString, (int)((float)(-stringWidth) / 2.0f), 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.m_85849_();
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.m_41619_()) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        graphics.m_280153_(this.f_96547_, this.hoveredItem, mouseX, mouseY);
        poseStack.m_85849_();
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public record ItemEntry(@Nullable ItemLike item, ResourceLocation key) {
    }
}

