/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.instruction;

import java.util.function.UnaryOperator;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.WorldModifyInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ReplaceBlocksInstruction
extends WorldModifyInstruction {
    private UnaryOperator<BlockState> stateToUse;
    private boolean replaceAir;
    private boolean spawnParticles;

    public ReplaceBlocksInstruction(Selection selection, UnaryOperator<BlockState> stateToUse, boolean replaceAir, boolean spawnParticles) {
        super(selection);
        this.stateToUse = stateToUse;
        this.replaceAir = replaceAir;
        this.spawnParticles = spawnParticles;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel level = scene.getWorld();
        selection.forEach(pos -> {
            if (!level.getBounds().m_71051_((Vec3i)pos)) {
                return;
            }
            BlockState prevState = level.m_8055_((BlockPos)pos);
            if (!this.replaceAir && prevState == Blocks.f_50016_.m_49966_()) {
                return;
            }
            if (this.spawnParticles) {
                level.addBlockDestroyEffects((BlockPos)pos, prevState);
            }
            level.m_46597_((BlockPos)pos, (BlockState)this.stateToUse.apply(prevState));
        });
    }

    @Override
    protected boolean needsRedraw() {
        return true;
    }
}

