/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PonderTag
implements ScreenElement {
    private final ResourceLocation id;
    @Nullable
    private final ResourceLocation textureIconLocation;
    private final ItemStack itemIcon;
    private final ItemStack mainItem;

    public PonderTag(ResourceLocation id, @Nullable ResourceLocation textureIconLocation, ItemStack itemIcon, ItemStack mainItem) {
        this.id = id;
        this.textureIconLocation = textureIconLocation;
        this.itemIcon = itemIcon;
        this.mainItem = mainItem;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderIndex.getLangAccess().getTagName(this.id);
    }

    public String getDescription() {
        return PonderIndex.getLangAccess().getTagDescription(this.id);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        if (this.textureIconLocation != null) {
            poseStack.m_85841_(0.25f, 0.25f, 1.0f);
            graphics.m_280398_(this.textureIconLocation, 0, 0, 0, 0.0f, 0.0f, 64, 64, 64, 64);
        } else if (!this.itemIcon.m_41619_()) {
            poseStack.m_252880_(-2.0f, -2.0f, 0.0f);
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
            GuiGameElement.of(this.itemIcon).render(graphics);
        }
        poseStack.m_85849_();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PonderTag)) {
            return false;
        }
        PonderTag otherTag = (PonderTag)other;
        return this.getId().equals((Object)otherTag.getId());
    }

    public static final class Highlight {
        public static final ResourceLocation ALL = Ponder.asResource("_all");
    }
}

