/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.createmod.catnip.render.MutableTemplateMesh;
import net.createmod.catnip.render.ShadeSeparatingSuperByteBuffer;
import net.createmod.catnip.render.SuperByteBuffer;

public class SuperByteBufferBuilder {
    protected final MutableTemplateMesh mesh = new MutableTemplateMesh();
    protected final IntList shadeSwapVertices = new IntArrayList();
    protected boolean currentShade;

    public void prepare() {
        this.mesh.clear();
        this.shadeSwapVertices.clear();
        this.currentShade = true;
    }

    public void add(BufferBuilder.RenderedBuffer data, boolean shaded) {
        if (shaded != this.currentShade) {
            this.shadeSwapVertices.add(this.mesh.vertexCount());
            this.currentShade = shaded;
        }
        this.mesh.copyFrom(this.mesh.vertexCount(), data);
    }

    public SuperByteBuffer build() {
        return new ShadeSeparatingSuperByteBuffer(this.mesh.toImmutable(), this.shadeSwapVertices.toIntArray());
    }
}

