/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import javax.annotation.Nullable;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.render.MutableTemplateMesh;
import net.createmod.catnip.render.ShadeSeparatingSuperByteBuffer;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class SuperBufferFactory {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private static SuperBufferFactory instance = new SuperBufferFactory();

    public static SuperBufferFactory getInstance() {
        return instance;
    }

    static void setInstance(SuperBufferFactory factory) {
        instance = factory;
    }

    public SuperByteBuffer create(BufferBuilder.RenderedBuffer data) {
        return new ShadeSeparatingSuperByteBuffer(new MutableTemplateMesh(data).toImmutable());
    }

    public SuperByteBuffer createForBlock(BlockState renderedState) {
        return this.createForBlock(Minecraft.m_91087_().m_91289_().m_110910_(renderedState), renderedState);
    }

    public SuperByteBuffer createForBlock(BakedModel model, BlockState referenceState) {
        return this.createForBlock(model, referenceState, new PoseStack());
    }

    public SuperByteBuffer createForBlock(BakedModel model, BlockState state, @Nullable PoseStack poseStack) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        SbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.prepare();
        BakedModelBufferer.bufferModel(model, BlockPos.f_121853_, (BlockAndTintGetter)EmptyVirtualBlockGetter.FULL_DARK, state, poseStack, sbbBuilder);
        return sbbBuilder.build();
    }

    private static class ThreadLocalObjects {
        public final SbbBuilder sbbBuilder = new SbbBuilder();

        private ThreadLocalObjects() {
        }
    }

    private static class SbbBuilder
    extends SuperByteBufferBuilder
    implements ShadeSeparatedResultConsumer {
        private SbbBuilder() {
        }

        @Override
        public void accept(RenderType renderType, boolean shaded, BufferBuilder.RenderedBuffer data) {
            this.add(data, shaded);
        }
    }
}

