/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.platform;

import net.createmod.catnip.platform.services.ModFluidHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ForgeFluidHelper
implements ModFluidHelper<FluidStack> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(FluidStack stack, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((Fluid)fluid);
        if (level == null || pos == null) {
            return extension.getTintColor(stack);
        }
        return extension.getTintColor(fluid.m_76145_(), level, pos);
    }

    @Override
    public int getLuminosity(FluidStack fluid) {
        return fluid.getFluid().getFluidType().getLightLevel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getStillTexture(FluidStack fluid) {
        ResourceLocation id = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid);
        return id == null ? null : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(id);
    }

    @Override
    public boolean isLighterThanAir(FluidStack fluid) {
        return fluid.getFluid().getFluidType().isLighterThanAir();
    }

    @Override
    public FluidStack toStack(FluidState state) {
        return new FluidStack(state.m_76152_(), 1000);
    }
}

