/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.platform;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.createmod.catnip.platform.services.ExternalRenderHelper;
import net.createmod.catnip.render.BlockVertex;
import net.createmod.catnip.render.EntityVertex;
import net.createmod.catnip.render.IrisEntityVertex;
import net.createmod.catnip.render.IrisTerrainVertex;
import net.createmod.catnip.render.ShadeSeparatingSuperByteBuffer;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.TemplateMesh;
import net.createmod.ponder.mixin.client.accessor.RenderSystemAccessor;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.vertices.NormalHelper;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ForgeExternalRenderHelper
implements ExternalRenderHelper {
    private static final int BUFFER_VERTEX_COUNT = 48;
    private static final MemoryStack STACK = MemoryStack.create();
    private static final int BUFFER_SIZE = 2688;
    private static final long SCRATCH_BUFFER;
    private static long BUFFER_PTR;
    private static int BUFFED_VERTEX;
    private static final Matrix4f modelMat;
    private static final Matrix3f normalMat;
    private static final Vector3f float3;
    private static final Vector3f lightDir0;
    private static final Vector3f lightDir1;
    private static final SuperByteBuffer.ShiftOutput shiftOutput;
    private static final Vector3f pos0;
    private static final Vector3f pos1;
    private static final Vector3f pos2;
    private static final Vector3f pos3;
    private static final Vector2f uv0;
    private static final Vector2f uv1;
    private static final Vector2f uv2;
    private static final Vector2f uv3;

    private static boolean isBufferMax() {
        return BUFFED_VERTEX >= 48;
    }

    private static void flush(VertexBufferWriter writer, boolean force, VertexFormatDescription format) {
        if (!force && !ForgeExternalRenderHelper.isBufferMax()) {
            return;
        }
        if (BUFFED_VERTEX == 0) {
            return;
        }
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, BUFFED_VERTEX, format);
        STACK.pop();
        BUFFER_PTR = SCRATCH_BUFFER;
        BUFFED_VERTEX = 0;
    }

    private static boolean isPerspectiveProjection() {
        return RenderSystem.getModelViewMatrix().m32() == 0.0f;
    }

    private static int calcColorSodium(int quadColor, int vertexColor, int unshadedDiffuse, boolean applyDiffuse, boolean shaded, float nx, float ny, float nz) {
        int r = (quadColor & 0xFF) * (vertexColor & 0xFF) + 255 >>> 8;
        int g = (quadColor >>> 8 & 0xFF) * (vertexColor >>> 8 & 0xFF) + 255 >>> 8;
        int b = (quadColor >>> 16 & 0xFF) * (vertexColor >>> 16 & 0xFF) + 255 >>> 8;
        int a = (quadColor >>> 24 & 0xFF) * (vertexColor >>> 24 & 0xFF) + 255 >>> 8;
        if (applyDiffuse) {
            float3.set(nx, ny, nz);
            int factor = shaded ? (int)(255.0f * ShadeSeparatingSuperByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1)) : unshadedDiffuse;
            r = r * factor + 255 >>> 8;
            g = g * factor + 255 >>> 8;
            b = b * factor + 255 >>> 8;
        }
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static int calcColorIris(int quadColor, int vertexColor) {
        int r = (quadColor & 0xFF) * (vertexColor & 0xFF) + 255 >>> 8;
        int g = (quadColor >>> 8 & 0xFF) * (vertexColor >>> 8 & 0xFF) + 255 >>> 8;
        int b = (quadColor >>> 16 & 0xFF) * (vertexColor >>> 16 & 0xFF) + 255 >>> 8;
        int a = (quadColor >>> 24 & 0xFF) * (vertexColor >>> 24 & 0xFF) + 255 >>> 8;
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static void IrisRenderShadowInto(ShadeSeparatingSuperByteBuffer byteBuffer, PoseStack input, VertexBufferWriter writer, VertexFormatDescription format) {
        PoseStack transforms = byteBuffer.getTransforms();
        modelMat.set((Matrix4fc)input.m_85850_().m_252922_());
        Matrix4f localTransforms = transforms.m_85850_().m_252922_();
        modelMat.mul((Matrix4fc)localTransforms);
        PoseStack.Pose pose = (PoseStack.Pose)input.f_85834_.peekFirst();
        Matrix3f sunNormal = pose.m_252943_();
        float3.set(sunNormal.m02, sunNormal.m12, sunNormal.m22);
        SuperByteBuffer.SpriteShiftFunc spriteShiftFunc = byteBuffer.getSpriteShiftFunc();
        boolean isTerrain = format == IrisTerrainVertex.FORMAT;
        TemplateMesh template = byteBuffer.getTemplateMesh();
        int vertexCount = template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            float nz;
            float ny;
            float unpackedZ;
            float unpackedY;
            int packedNormal = template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)normalMat, (float)unpackedX, (float)(unpackedY = NormI8.unpackY((int)packedNormal)), (float)(unpackedZ = NormI8.unpackZ((int)packedNormal)));
            if (float3.dot(nx, ny = MatrixHelper.transformNormalY((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ), nz = MatrixHelper.transformNormalZ((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ)) >= 0.0f) continue;
            pos0.set(template.x(i), template.y(i), template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos1.set(template.x(i + 1), template.y(i + 1), template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos2.set(template.x(i + 2), template.y(i + 2), template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            pos3.set(template.x(i + 3), template.y(i + 3), template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            if (spriteShiftFunc != null) {
                spriteShiftFunc.shift(template.u(i), template.v(i), shiftOutput);
                uv0.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 1), template.v(i + 1), shiftOutput);
                uv1.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 2), template.v(i + 2), shiftOutput);
                uv2.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 3), template.v(i + 3), shiftOutput);
                uv3.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
            } else {
                uv0.set(template.u(i), template.v(i));
                uv1.set(template.u(i + 1), template.v(i + 1));
                uv2.set(template.u(i + 2), template.v(i + 2));
                uv3.set(template.u(i + 3), template.v(i + 3));
            }
            if (isTerrain) {
                IrisTerrainVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, -1, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, -1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, -1, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, -1, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                BUFFER_PTR += 52L;
            } else {
                IrisEntityVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, -1, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, -1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, -1, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, -1, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                BUFFER_PTR += 56L;
            }
            BUFFED_VERTEX += 4;
            ForgeExternalRenderHelper.flush(writer, false, format);
        }
        ForgeExternalRenderHelper.flush(writer, true, format);
    }

    private static void IrisRenderInto(ShadeSeparatingSuperByteBuffer byteBuffer, PoseStack input, VertexBufferWriter writer, VertexFormatDescription format) {
        PoseStack transforms = byteBuffer.getTransforms();
        modelMat.set((Matrix4fc)input.m_85850_().m_252922_());
        Matrix4f localTransforms = transforms.m_85850_().m_252922_();
        modelMat.mul((Matrix4fc)localTransforms);
        normalMat.set((Matrix3fc)input.m_85850_().m_252943_());
        Matrix3f localNormalTransforms = transforms.m_85850_().m_252943_();
        normalMat.mul((Matrix3fc)localNormalTransforms);
        SuperByteBuffer.SpriteShiftFunc spriteShiftFunc = byteBuffer.getSpriteShiftFunc();
        boolean useLevelLight = byteBuffer.isUsingLevelLight();
        boolean hasCustomLight = byteBuffer.hasCustomLight();
        boolean isTerrain = format == IrisTerrainVertex.FORMAT;
        boolean isPerspectiveProjection = ForgeExternalRenderHelper.isPerspectiveProjection();
        TemplateMesh template = byteBuffer.getTemplateMesh();
        int vertexCount = template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            int packedNormal = template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float unpackedY = NormI8.unpackY((int)packedNormal);
            float unpackedZ = NormI8.unpackZ((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float ny = MatrixHelper.transformNormalY((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float nz = MatrixHelper.transformNormalZ((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            pos0.set(template.x(i), template.y(i), template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos2.set(template.x(i + 2), template.y(i + 2), template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            if (isPerspectiveProjection && nx * (ForgeExternalRenderHelper.pos0.x + ForgeExternalRenderHelper.pos2.x) + ny * (ForgeExternalRenderHelper.pos0.y + ForgeExternalRenderHelper.pos2.y) + nz * (ForgeExternalRenderHelper.pos0.z + ForgeExternalRenderHelper.pos2.z) > 0.0f) continue;
            pos1.set(template.x(i + 1), template.y(i + 1), template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos3.set(template.x(i + 3), template.y(i + 3), template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            int tangent = NormalHelper.computeTangent((float)nx, (float)ny, (float)nz, (float)ForgeExternalRenderHelper.pos0.x, (float)ForgeExternalRenderHelper.pos0.y, (float)ForgeExternalRenderHelper.pos0.z, (float)ForgeExternalRenderHelper.uv0.x, (float)ForgeExternalRenderHelper.uv0.y, (float)ForgeExternalRenderHelper.pos1.x, (float)ForgeExternalRenderHelper.pos1.y, (float)ForgeExternalRenderHelper.pos1.z, (float)ForgeExternalRenderHelper.uv1.x, (float)ForgeExternalRenderHelper.uv1.y, (float)ForgeExternalRenderHelper.pos2.x, (float)ForgeExternalRenderHelper.pos2.y, (float)ForgeExternalRenderHelper.pos2.z, (float)ForgeExternalRenderHelper.uv2.x, (float)ForgeExternalRenderHelper.uv2.y);
            if (spriteShiftFunc != null) {
                spriteShiftFunc.shift(template.u(i), template.v(i), shiftOutput);
                uv0.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 1), template.v(i + 1), shiftOutput);
                uv1.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 2), template.v(i + 2), shiftOutput);
                uv2.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 3), template.v(i + 3), shiftOutput);
                uv3.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
            } else {
                uv0.set(template.u(i), template.v(i));
                uv1.set(template.u(i + 1), template.v(i + 1));
                uv2.set(template.u(i + 2), template.v(i + 2));
                uv3.set(template.u(i + 3), template.v(i + 3));
            }
            float mid_u = (ForgeExternalRenderHelper.uv0.x + ForgeExternalRenderHelper.uv1.x + ForgeExternalRenderHelper.uv2.x + ForgeExternalRenderHelper.uv3.x) / 4.0f;
            float mid_v = (ForgeExternalRenderHelper.uv0.y + ForgeExternalRenderHelper.uv1.y + ForgeExternalRenderHelper.uv2.y + ForgeExternalRenderHelper.uv3.y) / 4.0f;
            int vertexColor = byteBuffer.getVertexColor();
            int color0 = ForgeExternalRenderHelper.calcColorIris(template.color(i), vertexColor);
            int color1 = ForgeExternalRenderHelper.calcColorIris(template.color(i + 1), vertexColor);
            int color2 = ForgeExternalRenderHelper.calcColorIris(template.color(i + 2), vertexColor);
            int color3 = ForgeExternalRenderHelper.calcColorIris(template.color(i + 3), vertexColor);
            int light0 = template.light(i);
            int light1 = template.light(i + 1);
            int light2 = template.light(i + 2);
            int light3 = template.light(i + 3);
            if (hasCustomLight) {
                int packedLight = byteBuffer.getPackedLight();
                light0 = SuperByteBuffer.maxLight(light0, packedLight);
                light1 = SuperByteBuffer.maxLight(light1, packedLight);
                light2 = SuperByteBuffer.maxLight(light2, packedLight);
                light3 = SuperByteBuffer.maxLight(light3, packedLight);
            }
            if (useLevelLight) {
                float3.set((template.x(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light0 = SuperByteBuffer.maxLight(light0, byteBuffer.getLight(float3));
                float3.set((template.x(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light1 = SuperByteBuffer.maxLight(light1, byteBuffer.getLight(float3));
                float3.set((template.x(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light2 = SuperByteBuffer.maxLight(light2, byteBuffer.getLight(float3));
                float3.set((template.x(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light3 = SuperByteBuffer.maxLight(light3, byteBuffer.getLight(float3));
            }
            if (isTerrain) {
                IrisTerrainVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, color0, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, mid_u, mid_v, light0, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, color1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, mid_u, mid_v, light1, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, color2, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, mid_u, mid_v, light2, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, color3, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, mid_u, mid_v, light3, normal, tangent);
                BUFFER_PTR += 52L;
            } else {
                int overlay0;
                int overlay1;
                int overlay2;
                int overlay3;
                if (byteBuffer.hasCustomOverlay()) {
                    overlay2 = overlay3 = byteBuffer.getOverlay();
                    overlay1 = overlay3;
                    overlay0 = overlay3;
                } else {
                    overlay0 = template.overlay(i);
                    overlay1 = template.overlay(i + 1);
                    overlay2 = template.overlay(i + 2);
                    overlay3 = template.overlay(i + 3);
                }
                IrisEntityVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, color0, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, mid_u, mid_v, overlay0, light0, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, color1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, mid_u, mid_v, overlay1, light1, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, color2, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, mid_u, mid_v, overlay2, light2, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += 56L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, color3, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, mid_u, mid_v, overlay3, light3, normal, tangent);
                BUFFER_PTR += 56L;
            }
            BUFFED_VERTEX += 4;
            ForgeExternalRenderHelper.flush(writer, false, format);
        }
        ForgeExternalRenderHelper.flush(writer, true, format);
    }

    private static void SodiumRenderInto(ShadeSeparatingSuperByteBuffer byteBuffer, PoseStack input, VertexBufferWriter writer, VertexFormatDescription format) {
        boolean applyDiffuse;
        PoseStack transforms = byteBuffer.getTransforms();
        modelMat.set((Matrix4fc)input.m_85850_().m_252922_());
        Matrix4f localTransforms = transforms.m_85850_().m_252922_();
        modelMat.mul((Matrix4fc)localTransforms);
        normalMat.set((Matrix3fc)input.m_85850_().m_252943_());
        Matrix3f localNormalTransforms = transforms.m_85850_().m_252943_();
        normalMat.mul((Matrix3fc)localNormalTransforms);
        boolean shaded = true;
        int shadeSwapIndex = 0;
        int[] shadeSwapVertices = byteBuffer.getShadeSwapVertices();
        int nextShadeSwapVertex = shadeSwapIndex < shadeSwapVertices.length ? shadeSwapVertices[shadeSwapIndex] : Integer.MAX_VALUE;
        int unshadedDiffuse = 255;
        boolean bl = applyDiffuse = !byteBuffer.isDisableDiffuse();
        if (!byteBuffer.isDisableDiffuse()) {
            lightDir0.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[0]).normalize();
            lightDir1.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[1]).normalize();
            if (shadeSwapVertices.length > 0) {
                float3.set(0.0f, 1.0f, 0.0f);
                unshadedDiffuse = (int)(255.0f * ShadeSeparatingSuperByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1));
            }
        }
        SuperByteBuffer.SpriteShiftFunc spriteShiftFunc = byteBuffer.getSpriteShiftFunc();
        boolean useLevelLight = byteBuffer.isUsingLevelLight();
        boolean hasCustomLight = byteBuffer.hasCustomLight();
        boolean isPerspectiveProjection = ForgeExternalRenderHelper.isPerspectiveProjection();
        TemplateMesh template = byteBuffer.getTemplateMesh();
        int vertexCount = template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            if (i >= nextShadeSwapVertex) {
                shaded = !shaded;
                nextShadeSwapVertex = ++shadeSwapIndex < shadeSwapVertices.length ? shadeSwapVertices[shadeSwapIndex] : Integer.MAX_VALUE;
            }
            int packedNormal = template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float unpackedY = NormI8.unpackY((int)packedNormal);
            float unpackedZ = NormI8.unpackZ((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float ny = MatrixHelper.transformNormalY((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float nz = MatrixHelper.transformNormalZ((Matrix3f)normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            pos0.set(template.x(i), template.y(i), template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos2.set(template.x(i + 2), template.y(i + 2), template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            if (isPerspectiveProjection && nx * (ForgeExternalRenderHelper.pos0.x + ForgeExternalRenderHelper.pos2.x) + ny * (ForgeExternalRenderHelper.pos0.y + ForgeExternalRenderHelper.pos2.y) + nz * (ForgeExternalRenderHelper.pos0.z + ForgeExternalRenderHelper.pos2.z) > 0.0f) continue;
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            pos1.set(template.x(i + 1), template.y(i + 1), template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos3.set(template.x(i + 3), template.y(i + 3), template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            if (spriteShiftFunc != null) {
                spriteShiftFunc.shift(template.u(i), template.v(i), shiftOutput);
                uv0.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 1), template.v(i + 1), shiftOutput);
                uv1.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 2), template.v(i + 2), shiftOutput);
                uv2.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
                spriteShiftFunc.shift(template.u(i + 3), template.v(i + 3), shiftOutput);
                uv3.set(ForgeExternalRenderHelper.shiftOutput.u, ForgeExternalRenderHelper.shiftOutput.v);
            } else {
                uv0.set(template.u(i), template.v(i));
                uv1.set(template.u(i + 1), template.v(i + 1));
                uv2.set(template.u(i + 2), template.v(i + 2));
                uv3.set(template.u(i + 3), template.v(i + 3));
            }
            int vertexColor = byteBuffer.getVertexColor();
            int color0 = ForgeExternalRenderHelper.calcColorSodium(template.color(i), vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color1 = ForgeExternalRenderHelper.calcColorSodium(template.color(i + 1), vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color2 = ForgeExternalRenderHelper.calcColorSodium(template.color(i + 2), vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color3 = ForgeExternalRenderHelper.calcColorSodium(template.color(i + 3), vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int light0 = template.light(i);
            int light1 = template.light(i + 1);
            int light2 = template.light(i + 2);
            int light3 = template.light(i + 3);
            if (hasCustomLight) {
                int packedLight = byteBuffer.getPackedLight();
                light0 = SuperByteBuffer.maxLight(light0, packedLight);
                light1 = SuperByteBuffer.maxLight(light1, packedLight);
                light2 = SuperByteBuffer.maxLight(light2, packedLight);
                light3 = SuperByteBuffer.maxLight(light3, packedLight);
            }
            if (useLevelLight) {
                float3.set((template.x(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light0 = SuperByteBuffer.maxLight(light0, byteBuffer.getLight(float3));
                float3.set((template.x(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light1 = SuperByteBuffer.maxLight(light1, byteBuffer.getLight(float3));
                float3.set((template.x(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light2 = SuperByteBuffer.maxLight(light2, byteBuffer.getLight(float3));
                float3.set((template.x(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.y(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (template.z(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light3 = SuperByteBuffer.maxLight(light3, byteBuffer.getLight(float3));
            }
            if (format == BlockVertex.FORMAT) {
                BlockVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, color0, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, light0, normal);
                BlockVertex.write(BUFFER_PTR += 32L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, color1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, light1, normal);
                BlockVertex.write(BUFFER_PTR += 32L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, color2, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, light2, normal);
                BlockVertex.write(BUFFER_PTR += 32L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, color3, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, light3, normal);
                BUFFER_PTR += 32L;
            } else {
                int overlay0;
                int overlay1;
                int overlay2;
                int overlay3;
                if (byteBuffer.hasCustomOverlay()) {
                    overlay2 = overlay3 = byteBuffer.getOverlay();
                    overlay1 = overlay3;
                    overlay0 = overlay3;
                } else {
                    overlay0 = template.overlay(i);
                    overlay1 = template.overlay(i + 1);
                    overlay2 = template.overlay(i + 2);
                    overlay3 = template.overlay(i + 3);
                }
                EntityVertex.write(BUFFER_PTR, ForgeExternalRenderHelper.pos0.x, ForgeExternalRenderHelper.pos0.y, ForgeExternalRenderHelper.pos0.z, color0, ForgeExternalRenderHelper.uv0.x, ForgeExternalRenderHelper.uv0.y, overlay0, light0, normal);
                EntityVertex.write(BUFFER_PTR += 36L, ForgeExternalRenderHelper.pos1.x, ForgeExternalRenderHelper.pos1.y, ForgeExternalRenderHelper.pos1.z, color1, ForgeExternalRenderHelper.uv1.x, ForgeExternalRenderHelper.uv1.y, overlay1, light1, normal);
                EntityVertex.write(BUFFER_PTR += 36L, ForgeExternalRenderHelper.pos2.x, ForgeExternalRenderHelper.pos2.y, ForgeExternalRenderHelper.pos2.z, color2, ForgeExternalRenderHelper.uv2.x, ForgeExternalRenderHelper.uv2.y, overlay2, light2, normal);
                EntityVertex.write(BUFFER_PTR += 36L, ForgeExternalRenderHelper.pos3.x, ForgeExternalRenderHelper.pos3.y, ForgeExternalRenderHelper.pos3.z, color3, ForgeExternalRenderHelper.uv3.x, ForgeExternalRenderHelper.uv3.y, overlay3, light3, normal);
                BUFFER_PTR += 36L;
            }
            BUFFED_VERTEX += 4;
            ForgeExternalRenderHelper.flush(writer, false, format);
        }
        ForgeExternalRenderHelper.flush(writer, true, format);
    }

    boolean isShadowPass() {
        return ShadowRenderer.ACTIVE;
    }

    @Override
    public boolean renderInto(ShadeSeparatingSuperByteBuffer byteBuffer, PoseStack input, VertexConsumer builder) {
        VertexBufferWriter writer = VertexBufferWriter.tryOf((VertexConsumer)builder);
        if (writer == null) {
            return false;
        }
        if (builder instanceof BufferBuilder) {
            BufferBuilder bb = (BufferBuilder)builder;
            VertexFormatDescription format = VertexFormatRegistry.instance().get(bb.f_85658_);
            if (format == IrisTerrainVertex.FORMAT || format == IrisEntityVertex.FORMAT) {
                if (!this.isShadowPass()) {
                    ForgeExternalRenderHelper.IrisRenderInto(byteBuffer, input, writer, format);
                } else {
                    ForgeExternalRenderHelper.IrisRenderShadowInto(byteBuffer, input, writer, format);
                }
                return true;
            }
            if (format == BlockVertex.FORMAT || format == EntityVertex.FORMAT) {
                ForgeExternalRenderHelper.SodiumRenderInto(byteBuffer, input, writer, format);
                return true;
            }
        }
        return false;
    }

    static {
        BUFFER_PTR = SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)2688L);
        BUFFED_VERTEX = 0;
        modelMat = new Matrix4f();
        normalMat = new Matrix3f();
        float3 = new Vector3f();
        lightDir0 = new Vector3f();
        lightDir1 = new Vector3f();
        shiftOutput = new SuperByteBuffer.ShiftOutput();
        pos0 = new Vector3f();
        pos1 = new Vector3f();
        pos2 = new Vector3f();
        pos3 = new Vector3f();
        uv0 = new Vector2f();
        uv1 = new Vector2f();
        uv2 = new Vector2f();
        uv3 = new Vector2f();
    }
}

