/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.placement;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.createmod.ponder.config.CClient;
import net.createmod.ponder.enums.PonderConfig;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PlacementClient {
    static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    @Nullable
    static BlockPos target = null;
    @Nullable
    static BlockPos lastTarget = null;
    static int animationTick = 0;

    public static void tick() {
        PlacementClient.setTarget(null);
        PlacementClient.checkHelpers();
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static void checkHelpers() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        InteractionHand[] interactionHandArray = mc.f_91077_;
        if (!(interactionHandArray instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult ray = (BlockHitResult)interactionHandArray;
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_6144_()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack heldItem = mc.f_91074_.m_21120_(hand);
            ArrayList<IPlacementHelper> filteredForHeldItem = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : PlacementHelpers.getHelpersView()) {
                if (!helper.matchesItem(heldItem)) continue;
                filteredForHeldItem.add(helper);
            }
            if (filteredForHeldItem.isEmpty()) continue;
            BlockPos pos = ray.m_82425_();
            BlockState state = world.m_8055_(pos);
            ArrayList<IPlacementHelper> filteredForState = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : filteredForHeldItem) {
                if (!helper.matchesState(state)) continue;
                filteredForState.add(helper);
            }
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((Player)mc.f_91074_, (Level)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                h.renderAt(pos, state, ray, offset);
                PlacementClient.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(@Nullable BlockPos target) {
        PlacementClient.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    public static void onRenderCrosshairOverlay(Window window, GuiGraphics graphics, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && animationTick > 0) {
            float screenY = (float)window.m_85446_() / 2.0f;
            float screenX = (float)window.m_85445_() / 2.0f;
            float progress = PlacementClient.getCurrentAlpha();
            PlacementClient.drawDirectionIndicator(graphics, partialTicks, screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    private static void drawDirectionIndicator(GuiGraphics graphics, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        Vec3 projTarget = VecHelper.projectToPlayerView(VecHelper.getCenterOf((Vec3i)lastTarget), partialTicks);
        Vec3 target = new Vec3(projTarget.f_82479_, projTarget.f_82480_, 0.0);
        if (projTarget.f_82481_ > 0.0) {
            target = target.m_82548_();
        }
        Vec3 norm = target.m_82541_();
        Vec3 ref = new Vec3(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(Math.acos(norm.m_82526_(ref)));
        if (norm.f_82479_ < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)PonderConfig.Client().placementIndicator.get());
        PoseStack poseStack = graphics.m_280168_();
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementClient.fadedArrow(poseStack, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementClient.textured(poseStack, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(PoseStack ms, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        ms.m_85836_();
        ms.m_252880_(centerX, centerY, 5.0f);
        ms.m_252781_(Axis.f_252403_.m_252977_(angle.getValue(0.0f)));
        double scale = (Double)PonderConfig.Client().indicatorScale.get();
        ms.m_85841_((float)scale, (float)scale, 1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = ms.m_85850_().m_252922_();
        bufferbuilder.m_252986_(mat, 0.0f, -(10.0f + length), 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_252986_(mat, -9.0f, -3.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, -6.0f, -6.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, -3.0f, -8.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 0.0f, -8.5f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 3.0f, -8.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 6.0f, -6.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 9.0f, -3.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        ms.m_85849_();
    }

    public static void textured(PoseStack ms, float centerX, float centerY, float alpha, float snappedAngle) {
        PonderGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        ms.m_85836_();
        ms.m_252880_(centerX, centerY, 50.0f);
        float scale = ((Double)PonderConfig.Client().indicatorScale.get()).floatValue() * 0.75f;
        ms.m_85841_(scale, scale, 1.0f);
        ms.m_85841_(12.0f, 12.0f, 1.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Matrix4f mat = ms.m_85850_().m_252922_();
        buffer.m_252986_(mat, -1.0f, -1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, ty).m_5752_();
        buffer.m_252986_(mat, -1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, ty + th).m_5752_();
        buffer.m_252986_(mat, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx + tw, ty + th).m_5752_();
        buffer.m_252986_(mat, 1.0f, -1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx + tw, ty).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        ms.m_85849_();
    }
}

