/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.net;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.net.ClientboundPacket;
import net.createmod.catnip.net.SimpleCatnipActions;
import net.createmod.ponder.Ponder;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientboundSimpleActionPacket
implements ClientboundPacket {
    public static final ResourceLocation ID = Ponder.asResource("simple_action_packet");
    private static final Map<String, Supplier<Consumer<String>>> actions = new HashMap<String, Supplier<Consumer<String>>>();
    private final String action;
    private final String value;

    public static void addAction(String name, Supplier<Consumer<String>> action) {
        actions.put(name, action);
    }

    public ClientboundSimpleActionPacket(String action, String value) {
        this.action = action;
        this.value = value;
    }

    public ClientboundSimpleActionPacket(FriendlyByteBuf buffer) {
        this.action = buffer.m_130277_();
        this.value = buffer.m_130277_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.action);
        buffer.m_130070_(this.value);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    static {
        ClientboundSimpleActionPacket.addAction("test", () -> System.out::println);
        ClientboundSimpleActionPacket.addAction("configScreen", () -> SimpleCatnipActions::configScreen);
    }

    public static class Handler {
        public static void handle(ClientboundSimpleActionPacket packet) {
            if (!actions.containsKey(packet.action)) {
                Ponder.LOGGER.warn("Received ClientboundSimpleActionPacket with invalid Action {}, ignoring the packet", (Object)packet.action);
                return;
            }
            Minecraft.m_91087_().execute(() -> actions.get(packet.action).get().accept(packet.value));
        }
    }
}

