/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class BlockFace
extends Pair<BlockPos, Direction> {
    public BlockFace(BlockPos first, Direction second) {
        super(first, second);
    }

    public boolean isEquivalent(BlockFace other) {
        if (this.equals(other)) {
            return true;
        }
        return this.getConnectedPos().equals((Object)other.getPos()) && this.getPos().equals((Object)other.getConnectedPos());
    }

    public BlockPos getPos() {
        return (BlockPos)this.getFirst();
    }

    public Direction getFace() {
        return (Direction)this.getSecond();
    }

    public Direction getOppositeFace() {
        return ((Direction)this.getSecond()).m_122424_();
    }

    public BlockFace getOpposite() {
        return new BlockFace(this.getConnectedPos(), this.getOppositeFace());
    }

    public BlockPos getConnectedPos() {
        return this.getPos().m_121945_(this.getFace());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.getPos()));
        NBTHelper.writeEnum(compoundNBT, "Face", this.getFace());
        return compoundNBT;
    }

    public static BlockFace fromNBT(CompoundTag compound) {
        return new BlockFace(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Pos")), NBTHelper.readEnum(compound, "Face", Direction.class));
    }
}

