/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.lang;

import java.util.List;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class LangBuilder {
    String namespace;
    @Nullable
    MutableComponent component;
    public static final float DEFAULT_SPACE_WIDTH = 4.0f;

    public LangBuilder(String namespace) {
        this.namespace = namespace;
    }

    public LangBuilder space() {
        return this.text(" ");
    }

    public LangBuilder newLine() {
        return this.text("\n");
    }

    public LangBuilder translate(String langKey, Object ... args) {
        Object[] args1 = LangBuilder.resolveBuilders(args);
        return this.add(Component.m_237110_((String)(this.namespace + "." + langKey), (Object[])args1));
    }

    public LangBuilder text(String literalText) {
        return this.add(Component.m_237113_((String)literalText));
    }

    public LangBuilder text(ChatFormatting format, String literalText) {
        return this.add(Component.m_237113_((String)literalText).m_130940_(format));
    }

    public LangBuilder text(int color, String literalText) {
        return this.add(Component.m_237113_((String)literalText).m_130938_(s -> s.m_178520_(color)));
    }

    public LangBuilder add(LangBuilder otherBuilder) {
        return this.add(otherBuilder.component());
    }

    public LangBuilder add(MutableComponent customComponent) {
        this.component = this.component == null ? customComponent : this.component.m_7220_((Component)customComponent);
        return this;
    }

    public LangBuilder add(Component component) {
        if (component instanceof MutableComponent) {
            MutableComponent mutableComponent = (MutableComponent)component;
            return this.add(mutableComponent);
        }
        return this.add(component.m_6881_());
    }

    public LangBuilder style(ChatFormatting format) {
        this.assertComponent();
        this.component = this.component.m_130940_(format);
        return this;
    }

    public LangBuilder color(int color) {
        this.assertComponent();
        this.component = this.component.m_130938_(s -> s.m_178520_(color));
        return this;
    }

    public LangBuilder color(Color color) {
        return this.color(color.getRGB());
    }

    public MutableComponent component() {
        this.assertComponent();
        return this.component;
    }

    public String string() {
        return this.component().getString();
    }

    public String json() {
        return Component.Serializer.m_130703_((Component)this.component());
    }

    public void sendStatus(Player player) {
        player.m_5661_((Component)this.component(), true);
    }

    public void sendChat(Player player) {
        player.m_5661_((Component)this.component(), false);
    }

    public void addTo(List<? super MutableComponent> tooltip) {
        tooltip.add((MutableComponent)this.component());
    }

    public void forGoggles(List<? super MutableComponent> tooltip) {
        this.forGoggles(tooltip, 0);
    }

    public void forGoggles(List<? super MutableComponent> tooltip, int indents) {
        tooltip.add((MutableComponent)new LangBuilder(this.namespace).text(Strings.repeat((char)' ', (int)LangBuilder.getIndents(Minecraft.m_91087_().f_91062_, 4 + indents))).add(this).component());
    }

    static int getIndents(Font font, int defaultIndents) {
        int spaceWidth = font.m_92895_(" ");
        if (4.0f == (float)spaceWidth) {
            return defaultIndents;
        }
        return Mth.m_14167_((float)(4.0f * (float)defaultIndents / (float)spaceWidth));
    }

    private void assertComponent() {
        if (this.component == null) {
            throw new IllegalStateException("No components were added to builder");
        }
    }

    public static Object[] resolveBuilders(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof LangBuilder)) continue;
            LangBuilder cb = (LangBuilder)object;
            args[i] = cb.component();
        }
        return args;
    }
}

