/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final Couple<Color> COLOR_NAV_ARROW = Couple.create(new Color(-2136303207, true), new Color(816486809)).map(Color::setImmutable);
    protected static boolean currentlyRenderingPreviousScreen = false;
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    @Nullable
    protected BoxWidget backTrack;

    public NavigatableSimiScreen() {
        Window window = Minecraft.m_91087_().m_91268_();
        this.depthPointX = window.m_85445_() / 2;
        this.depthPointY = window.m_85446_() / 2;
    }

    public void m_7379_() {
        ScreenOpener.clearStack();
        super.m_7379_();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.backTrack = null;
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        this.backTrack = (BoxWidget)((AbstractSimiWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(31, this.f_96544_ - 31 - 20).withBounds(20, 20)).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)).enableFade(0, 5)).withPadding(2.0f, 2.0f)).fade(1.0f)).withCallback(() -> ScreenOpener.openPreviousScreen(this, null));
        this.m_142416_(this.backTrack);
        Screen previousScreen = screenHistory.get(0);
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen screen = (NavigatableSimiScreen)previousScreen;
            screen.initBackTrackIcon(this.backTrack);
        } else {
            this.backTrack.showing(PonderGuiTextures.ICON_DISABLE);
        }
    }

    protected abstract void initBackTrackIcon(BoxWidget var1);

    protected Component backTrackingComponent() {
        if (ScreenOpener.getBackStepScreen() instanceof NavigatableSimiScreen) {
            return Lang.builder("catnip").translate("gui.step_back", new Object[0]).component();
        }
        return Lang.builder("catnip").translate("gui.exit", new Object[0]).component();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack == null) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        int x = (int)Mth.m_14179_((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
        int maxX = this.backTrack.m_252754_() + this.backTrack.m_5711_();
        Couple<Color> colors = COLOR_NAV_ARROW;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, -300.0f);
        if (x + 30 < this.backTrack.m_252754_()) {
            UIRenderHelper.breadcrumbArrow(graphics, x + 30, this.f_96544_ - 51, 0, maxX - (x + 30), 20, 5, colors);
        }
        UIRenderHelper.breadcrumbArrow(graphics, x, this.f_96544_ - 51, 0, 30, 20, 5, colors);
        UIRenderHelper.breadcrumbArrow(graphics, x - 30, this.f_96544_ - 51, 0, 30, 20, 5, colors);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 500.0f);
        if (this.backTrack.m_198029_()) {
            Component component = this.backTrackingComponent();
            graphics.m_280614_(this.f_96547_, component, 41 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.f_96544_ - 16, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
            if (Mth.m_14033_((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        poseStack.m_85849_();
    }

    public void m_280273_(GuiGraphics graphics) {
        if (!NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            super.m_280273_(graphics);
        }
    }

    @Override
    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            this.m_280273_(graphics);
            return;
        }
        this.m_280273_(graphics);
        PoseStack ms = graphics.m_280168_();
        Window window = this.f_96541_.m_91268_();
        float guiScaledWidth = window.m_85445_();
        float guiScaledHeight = window.m_85446_();
        Screen lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float tValue = this.transition.getValue(partialTicks);
        float tValueAbsolute = Math.abs(tValue);
        if (lastScreen != null && lastScreen != this && !this.transition.settled()) {
            currentlyRenderingPreviousScreen = true;
            ms.m_85836_();
            UIRenderHelper.framebuffer.m_83954_(Minecraft.f_91002_);
            UIRenderHelper.framebuffer.m_83947_(true);
            lastScreen.m_88315_(graphics, 0, 0, partialTicks);
            ms.m_85849_();
            ms.m_85836_();
            this.f_96541_.m_91385_().m_83947_(true);
            int dpx = (int)(guiScaledWidth / 2.0f);
            int dpy = (int)(guiScaledHeight / 2.0f);
            if (lastScreen instanceof NavigatableSimiScreen) {
                NavigatableSimiScreen navigableScreen = (NavigatableSimiScreen)lastScreen;
                if (tValue > 0.0f) {
                    dpx = navigableScreen.depthPointX;
                    dpy = navigableScreen.depthPointY;
                }
            }
            float scale = 1.0f + 0.2f * tValue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, guiScaledWidth, guiScaledHeight, 0.0f, 1000.0f, 3000.0f);
            PoseStack poseStack2 = new PoseStack();
            poseStack2.m_85850_().m_252922_().set((Matrix4fc)matrix4f);
            poseStack2.m_252880_((float)dpx, (float)dpy, 0.0f);
            poseStack2.m_85841_(scale, scale, 1.0f);
            poseStack2.m_252880_((float)(-dpx), (float)(-dpy), 0.0f);
            UIRenderHelper.drawFramebuffer(poseStack2, 1.0f - tValueAbsolute);
            RenderSystem.disableBlend();
            ms.m_85849_();
            currentlyRenderingPreviousScreen = false;
        }
        float scale = tValue > 0.0f ? 1.0f - 0.5f * (1.0f - tValueAbsolute) : 1.0f + 0.5f * (1.0f - tValueAbsolute);
        int dpx = (int)(guiScaledWidth / 2.0f);
        int dpy = (int)(guiScaledHeight / 2.0f);
        ms.m_252880_((float)dpx, (float)dpy, 0.0f);
        ms.m_85841_(scale, scale, 1.0f);
        ms.m_252880_((float)(-dpx), (float)(-dpy), 0.0f);
    }

    @Override
    public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, null);
            return true;
        }
        return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        List<Screen> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, this.f_96541_.f_91080_);
        int spacing = 20;
        ArrayList<String> names = new ArrayList<String>();
        for (Screen screen : history) {
            names.add(NavigatableSimiScreen.screenTitle(screen));
        }
        int bWidth = 0;
        for (String name : names) {
            bWidth += this.f_96547_.m_92895_(name) + spacing;
        }
        MutableInt mutableInt = new MutableInt(this.f_96543_ - bWidth);
        MutableInt y = new MutableInt(this.f_96544_ - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (mutableInt.getValue() < 25) {
            mutableInt.setValue(25);
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 600.0f);
        names.forEach(s -> {
            int sWidth = this.f_96547_.m_92895_(s);
            UIRenderHelper.breadcrumbArrow(graphics, x.getValue(), y.getValue(), 0, sWidth + spacing, 14, spacing / 2, new Color(-586149872), new Color(0x44101010));
            graphics.m_280488_(this.f_96547_, s, x.getValue() + 5, y.getValue() + 3, first.getValue() != false ? -1114130 : -2232577);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        poseStack.m_85849_();
    }

    public static boolean isCurrentlyRenderingPreviousScreen() {
        return currentlyRenderingPreviousScreen;
    }

    private static String screenTitle(Screen screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

