/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.TickableGuiEventListener;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public abstract class AbstractSimiScreen
extends Screen {
    protected static final Color BACKGROUND_COLOR = new Color(0x50101010, true);
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;

    protected AbstractSimiScreen(Component title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(CommonComponents.f_237098_);
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.windowWidth) / 2;
        this.guiTop = (this.f_96544_ - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void m_86600_() {
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.m_142416_((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_142416_(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_169411_(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.m_169411_(guiEventListener);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = NavigatableSimiScreen.currentlyRenderingPreviousScreen ? 0.0f : this.f_96541_.m_91296_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        this.prepareFrame();
        this.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderWindow(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        this.endFrame();
        poseStack.m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.m_7933_(keyCode, scanCode, modifiers);
        if (keyPressed || this.m_7222_() != null) {
            return keyPressed;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        boolean consumed = false;
        for (GuiEventListener widget : this.m_6702_()) {
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).m_7933_(keyCode, scanCode, modifiers)) continue;
            consumed = true;
        }
        return consumed;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
    }

    protected abstract void renderWindow(GuiGraphics var1, int var2, int var3, float var4);

    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.f_169369_) {
            List<Component> tooltip;
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).m_274382_() || !simiWidget.f_93624_ || (tooltip = simiWidget.getToolTip()).isEmpty()) continue;
            int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.m_252754_();
            int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.m_252907_();
            graphics.m_280666_(this.f_96547_, tooltip, ttx, tty);
        }
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(GuiGraphics graphics) {
        graphics.m_280509_(this.guiLeft + this.windowWidth, this.guiTop + this.windowHeight, this.guiLeft, this.guiTop, -741092397);
    }

    protected List<Renderable> getRenderables() {
        return this.f_169369_;
    }

    public GuiEventListener m_7222_() {
        GuiEventListener focused = super.m_7222_();
        if (focused instanceof AbstractWidget && !focused.m_93696_()) {
            focused = null;
        }
        this.m_7522_(focused);
        return focused;
    }
}

