/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.config.ui.ConfigAnnotations;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.ConfigTextField;
import net.createmod.catnip.config.ui.HintableTextFieldWidget;
import net.createmod.catnip.config.ui.entries.BooleanEntry;
import net.createmod.catnip.config.ui.entries.EnumEntry;
import net.createmod.catnip.config.ui.entries.NumberEntry;
import net.createmod.catnip.config.ui.entries.StringEntry;
import net.createmod.catnip.config.ui.entries.SubMenuEntry;
import net.createmod.catnip.config.ui.entries.ValueEntry;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.ConfirmationScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.net.ServerboundConfigPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SubMenuConfigScreen
extends ConfigScreen {
    public final ModConfig.Type type;
    protected ForgeConfigSpec spec;
    protected UnmodifiableConfig configGroup;
    protected ConfigScreenList list;
    @Nullable
    protected BoxWidget resetAll;
    @Nullable
    protected BoxWidget saveChanges;
    @Nullable
    protected BoxWidget discardChanges;
    @Nullable
    protected BoxWidget goBack;
    @Nullable
    protected BoxWidget serverLocked;
    @Nullable
    protected HintableTextFieldWidget search;
    protected int listWidth;
    protected String title;
    protected Set<String> highlights = new HashSet<String>();

    public static SubMenuConfigScreen find(ConfigHelper.ConfigPath path) {
        ForgeConfigSpec spec = ConfigHelper.findForgeConfigSpecFor(path.getType(), path.getModID());
        UnmodifiableConfig values = spec.getValues();
        BaseConfigScreen base = new BaseConfigScreen(null, path.getModID());
        SubMenuConfigScreen screen = new SubMenuConfigScreen(base, "root", path.getType(), spec, values);
        ArrayList remainingPath = Lists.newArrayList((Object[])path.getPath());
        block0: while (!remainingPath.isEmpty()) {
            String next = (String)remainingPath.remove(0);
            for (Map.Entry entry : values.valueMap().entrySet()) {
                String key = (String)entry.getKey();
                Object obj = entry.getValue();
                if (!key.equalsIgnoreCase(next)) continue;
                if (!(obj instanceof AbstractConfig)) {
                    screen.highlights.add(path.getPath()[path.getPath().length - 1]);
                    continue;
                }
                values = (UnmodifiableConfig)obj;
                screen = new SubMenuConfigScreen(screen, SubMenuConfigScreen.toHumanReadable(key), path.getType(), spec, values);
                continue block0;
            }
        }
        ConfigScreen.modID = path.getModID();
        return screen;
    }

    public SubMenuConfigScreen(@Nullable Screen parent, String title, ModConfig.Type type, ForgeConfigSpec configSpec, UnmodifiableConfig configGroup) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.title = title;
        this.configGroup = configGroup;
    }

    public SubMenuConfigScreen(Screen parent, ModConfig.Type type, ForgeConfigSpec configSpec) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.title = "root";
        this.configGroup = configSpec.getValues();
    }

    protected void clearChanges() {
        ConfigHelper.changes.clear();
        for (ConfigScreenList.Entry e : this.list.m_6702_()) {
            if (!(e instanceof ValueEntry)) continue;
            ValueEntry valueEntry = (ValueEntry)e;
            valueEntry.onValueChange();
        }
    }

    protected void saveChanges() {
        UnmodifiableConfig values = this.spec.getValues();
        ConfigHelper.changes.forEach((path, change) -> {
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)values.get(path);
            configValue.set(change.value);
            if (this.type == ModConfig.Type.SERVER) {
                assert (ConfigScreen.modID != null);
                CatnipServices.NETWORK.sendToServer(new ServerboundConfigPacket<Object>(ConfigScreen.modID, (String)path, change.value));
            }
            String command = change.annotations.get("Execute");
            if (this.f_96541_.f_91074_ != null && command != null && command.startsWith("/")) {
                this.f_96541_.f_91074_.f_108617_.m_246623_(command.substring(1));
            }
        });
        this.clearChanges();
    }

    protected void resetConfig(UnmodifiableConfig values) {
        values.valueMap().forEach((key, obj) -> {
            if (obj instanceof AbstractConfig) {
                this.resetConfig((UnmodifiableConfig)obj);
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                ArrayList<String> comments = new ArrayList<String>();
                if (valueSpec.getComment() != null) {
                    comments.addAll(Arrays.asList(valueSpec.getComment().split("\n")));
                }
                Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(comments);
                ConfigHelper.setValue(String.join((CharSequence)".", configValue.getPath()), configValue, valueSpec.getDefault(), metadata.getSecond());
            }
        });
        for (ConfigScreenList.Entry e : this.list.m_6702_()) {
            if (!(e instanceof ValueEntry)) continue;
            ValueEntry valueEntry = (ValueEntry)e;
            valueEntry.onValueChange();
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.listWidth = Math.min(this.f_96543_ - 80, 300);
        int yCenter = this.f_96544_ / 2;
        int listL = this.f_96543_ / 2 - this.listWidth / 2;
        int listR = this.f_96543_ / 2 + this.listWidth / 2;
        this.resetAll = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listR + 10, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> new ConfirmationScreen().centered().withText(FormattedText.m_130775_((String)("Resetting all settings of the " + this.type.toString() + " config. Are you sure?"))).withAction(success -> {
            if (success.booleanValue()) {
                this.resetConfig(this.spec.getValues());
            }
        }).open(this));
        this.resetAll.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_RESET.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.resetAll)));
        this.resetAll.getToolTip().add((Component)Component.m_237113_((String)"Reset All"));
        this.resetAll.getToolTip().addAll(FontHelper.cutStringTextComponent("Click here to reset all settings to their default value.", FontHelper.Palette.ALL_GRAY));
        this.saveChanges = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            ConfirmationScreen confirm = new ConfirmationScreen().centered().withText(FormattedText.m_130775_((String)("Saving " + ConfigHelper.changes.size() + " changed value" + (ConfigHelper.changes.size() != 1 ? "s" : "")))).withAction(success -> {
                if (success.booleanValue()) {
                    this.saveChanges();
                }
            });
            this.addAnnotationsToConfirm(confirm).open(this);
        });
        this.saveChanges.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_SAVE.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.saveChanges)));
        this.saveChanges.getToolTip().add((Component)Component.m_237113_((String)"Save Changes"));
        this.saveChanges.getToolTip().addAll(FontHelper.cutStringTextComponent("Click here to save your current changes.", FontHelper.Palette.ALL_GRAY));
        this.discardChanges = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            new ConfirmationScreen().centered().withText(FormattedText.m_130775_((String)("Discarding " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "")))).withAction(success -> {
                if (success.booleanValue()) {
                    this.clearChanges();
                }
            }).open(this);
        });
        this.discardChanges.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_DISCARD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.discardChanges)));
        this.discardChanges.getToolTip().add((Component)Component.m_237113_((String)"Discard Changes"));
        this.discardChanges.getToolTip().addAll(FontHelper.cutStringTextComponent("Click here to discard all the changes you made.", FontHelper.Palette.ALL_GRAY));
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(this::attemptBackstep);
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Component.m_237113_((String)"Go Back"));
        this.m_142416_(this.resetAll);
        this.m_142416_(this.saveChanges);
        this.m_142416_(this.discardChanges);
        this.m_142416_(this.goBack);
        this.list = new ConfigScreenList(this.f_96541_, this.listWidth, this.f_96544_ - 80, 35, this.f_96544_ - 45, 40);
        this.list.m_93507_(this.f_96543_ / 2 - this.list.getWidth() / 2);
        this.m_142416_(this.list);
        this.search = new ConfigTextField(this.f_96547_, this.f_96543_ / 2 - this.listWidth / 2, this.f_96544_ - 35, this.listWidth, 20);
        this.search.m_94151_(this::updateFilter);
        this.search.setHint("Ctrl + F to Search...");
        this.search.m_94198_();
        this.m_142416_((GuiEventListener)this.search);
        this.configGroup.valueMap().forEach((key, obj) -> {
            String humanKey = SubMenuConfigScreen.toHumanReadable(key);
            if (obj instanceof AbstractConfig) {
                SubMenuEntry entry = new SubMenuEntry(this, humanKey, this.spec, (UnmodifiableConfig)obj);
                entry.path = key;
                this.list.m_6702_().add(entry);
                if (this.configGroup.valueMap().size() == 1) {
                    ScreenOpener.open(new SubMenuConfigScreen(this.parent, humanKey, this.type, this.spec, (UnmodifiableConfig)obj));
                }
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                Object value = configValue.get();
                ConfigScreenList.LabeledEntry entry = null;
                if (value instanceof Boolean) {
                    entry = new BooleanEntry(humanKey, (ForgeConfigSpec.ConfigValue<Boolean>)configValue, valueSpec);
                } else if (value instanceof Enum) {
                    entry = new EnumEntry(humanKey, (ForgeConfigSpec.ConfigValue<Enum<?>>)configValue, valueSpec);
                } else if (value instanceof Number) {
                    entry = NumberEntry.create(value, humanKey, configValue, valueSpec);
                } else if (value instanceof String) {
                    entry = new StringEntry(humanKey, (ForgeConfigSpec.ConfigValue<String>)configValue, valueSpec);
                }
                if (entry == null) {
                    entry = new ConfigScreenList.LabeledEntry("Impl missing - " + configValue.get().getClass().getSimpleName() + "  " + humanKey + " : " + String.valueOf(value));
                }
                if (this.highlights.contains(key)) {
                    entry.annotations.put("highlight", ":)");
                }
                this.list.m_6702_().add(entry);
            }
        });
        this.list.m_6702_().sort((e, e2) -> {
            int group = (e2 instanceof SubMenuEntry ? 1 : 0) - (e instanceof SubMenuEntry ? 1 : 0);
            if (group == 0 && e instanceof ConfigScreenList.LabeledEntry) {
                ConfigScreenList.LabeledEntry le = (ConfigScreenList.LabeledEntry)e;
                if (e2 instanceof ConfigScreenList.LabeledEntry) {
                    ConfigScreenList.LabeledEntry le2 = (ConfigScreenList.LabeledEntry)e2;
                    return le.label.getComponent().getString().compareTo(le2.label.getComponent().getString());
                }
            }
            return group;
        });
        this.list.search(this.highlights.stream().findFirst().orElse(""));
        if (this.type != ModConfig.Type.SERVER) {
            return;
        }
        if (this.f_96541_.m_91091_()) {
            return;
        }
        boolean canEdit = this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_20310_(2);
        Couple<Color> red = AbstractSimiWidget.COLOR_FAIL;
        Couple<Color> green = AbstractSimiWidget.COLOR_SUCCESS;
        DelegatedStencilElement stencil = new DelegatedStencilElement();
        this.serverLocked = (BoxWidget)((ElementWidget)new BoxWidget(listR + 10, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f)).showingElement(stencil);
        if (!canEdit) {
            this.list.m_6702_().forEach(e -> e.setEditable(false));
            this.resetAll.f_93623_ = false;
            stencil.withStencilRenderer((ms, w, h, alpha) -> PonderGuiTextures.ICON_CONFIG_LOCKED.render(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16.0f, 16.0f, red));
            this.serverLocked.withBorderColors(red);
            this.serverLocked.getToolTip().add((Component)Component.m_237113_((String)"Locked").m_130940_(ChatFormatting.BOLD));
            this.serverLocked.getToolTip().addAll(FontHelper.cutStringTextComponent("You do not have enough permissions to edit the server config. You can still look at the current values here though.", FontHelper.Palette.ALL_GRAY));
        } else {
            stencil.withStencilRenderer((ms, w, h, alpha) -> PonderGuiTextures.ICON_CONFIG_UNLOCKED.render(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16.0f, 16.0f, green));
            this.serverLocked.withBorderColors(green);
            this.serverLocked.getToolTip().add((Component)Component.m_237113_((String)"Unlocked").m_130940_(ChatFormatting.BOLD));
            this.serverLocked.getToolTip().addAll(FontHelper.cutStringTextComponent("You have enough permissions to edit the server config. Changes you make here will be synced with the server when you save them.", FontHelper.Palette.ALL_GRAY));
        }
        this.m_142416_(this.serverLocked);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.f_96543_ / 2;
        graphics.m_280137_(this.f_96541_.f_91062_, ConfigScreen.modID + " > " + this.type.toString().toLowerCase(Locale.ROOT) + " > " + this.title, x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_6574_(@Nonnull Minecraft client, int width, int height) {
        double scroll = this.list.m_93517_();
        this.m_6575_(client, width, height);
        this.list.m_93410_(scroll);
    }

    @Override
    @Nullable
    public GuiEventListener m_7222_() {
        if (ConfigScreenList.currentText != null) {
            return ConfigScreenList.currentText;
        }
        return super.m_7222_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.search != null && Screen.m_96637_() && keyCode == 70) {
            this.search.m_93692_(true);
        }
        if (keyCode == 259) {
            this.attemptBackstep();
        }
        return false;
    }

    private void updateFilter(String search) {
        if (this.list.search(search)) {
            this.search.m_94202_(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        } else {
            this.search.m_94202_(((Color)AbstractSimiWidget.COLOR_SUCCESS.getFirst()).getRGB());
        }
    }

    private void attemptBackstep() {
        if (ConfigHelper.changes.isEmpty() || !(this.parent instanceof BaseConfigScreen)) {
            ScreenOpener.open(this.parent);
            return;
        }
        this.showLeavingPrompt(success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            ScreenOpener.open(this.parent);
        });
    }

    public void m_7379_() {
        if (ConfigHelper.changes.isEmpty()) {
            super.m_7379_();
            return;
        }
        this.showLeavingPrompt(success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            super.m_7379_();
        });
    }

    public void showLeavingPrompt(Consumer<ConfirmationScreen.Response> action) {
        ConfirmationScreen screen = new ConfirmationScreen().centered().withThreeActions(action).addText(FormattedText.m_130775_((String)("Leaving with " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "") + " for this config")));
        this.addAnnotationsToConfirm(screen).open(this);
    }

    private ConfirmationScreen addAnnotationsToConfirm(ConfirmationScreen screen) {
        AtomicBoolean relog = new AtomicBoolean(false);
        AtomicBoolean restart = new AtomicBoolean(false);
        ConfigHelper.changes.values().forEach(change -> {
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
                relog.set(true);
            }
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
                restart.set(true);
            }
        });
        if (relog.get()) {
            screen.addText(FormattedText.m_130775_((String)" "));
            screen.addText(FormattedText.m_130775_((String)"At least one changed value will require you to relog to take full effect"));
        }
        if (restart.get()) {
            screen.addText(FormattedText.m_130775_((String)" "));
            screen.addText(FormattedText.m_130775_((String)"At least one changed value will require you to restart your game to take full effect"));
        }
        return screen;
    }
}

