/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.HintableTextFieldWidget;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigModListScreen
extends ConfigScreen {
    @Nullable
    ConfigScreenList list;
    @Nullable
    HintableTextFieldWidget search;
    @Nullable
    BoxWidget goBack;
    List<ModEntry> allEntries = new ArrayList<ModEntry>();

    public ConfigModListScreen(@Nullable Screen parent) {
        super(parent);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int listWidth = Math.min(this.f_96543_ - 80, 300);
        this.list = new ConfigScreenList(this.f_96541_, listWidth, this.f_96544_ - 60, 15, this.f_96544_ - 45, 40);
        this.list.m_93507_(this.f_96543_ / 2 - this.list.getWidth() / 2);
        this.m_142416_(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        CatnipServices.PLATFORM.getLoadedMods().forEach(id -> this.allEntries.add(new ModEntry((String)id, this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.f_93623_ ? 1 : 0) - (e1.button.f_93623_ ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.m_6702_().clear();
        this.list.m_6702_().addAll(this.allEntries);
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.f_96543_ / 2 - listWidth / 2 - 30, this.f_96544_ / 2 + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> ScreenOpener.open(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Component.m_237113_((String)"Go Back"));
        this.m_142416_(this.goBack);
        this.search = new HintableTextFieldWidget(this.f_96547_, this.f_96543_ / 2 - listWidth / 2, this.f_96544_ - 35, listWidth, 20);
        this.search.m_94151_(this::updateFilter);
        this.search.setHint("Ctrl + F to Search...");
        this.search.m_94198_();
        this.m_142416_((GuiEventListener)this.search);
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.search != null && !this.search.m_5953_(x, y)) {
            this.search.m_93692_(false);
        }
        return super.m_6375_(x, y, button);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.search != null && Screen.m_96637_() && keyCode == 70) {
            this.m_7522_((GuiEventListener)this.search);
        }
        if (keyCode == 259) {
            ScreenOpener.open(this.parent);
        }
        return false;
    }

    private void updateFilter(String search) {
        assert (this.list != null);
        assert (this.search != null);
        this.list.m_6702_().clear();
        for (ModEntry modEntry : this.allEntries) {
            if (!modEntry.id.contains(search.toLowerCase(Locale.ROOT))) continue;
            this.list.m_6702_().add(modEntry);
        }
        this.list.m_93410_(this.list.m_93517_());
        if (!this.list.m_6702_().isEmpty()) {
            this.search.m_94202_(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        } else {
            this.search.m_94202_(((Color)AbstractSimiWidget.COLOR_FAIL.getFirst()).getRGB());
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, Screen parent) {
            super(CatnipServices.PLATFORM.getModDisplayName(id));
            this.id = id;
            this.button = (BoxWidget)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_OPEN.asStencil().at(10.0f, 0.0f));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyForgeConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else {
                this.button.f_93623_ = false;
                this.button.updateGradientFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(Component.m_237113_((String)CatnipServices.PLATFORM.getModDisplayName(id)));
                this.labelTooltip.addAll(FontHelper.cutTextComponent((Component)Component.m_237113_((String)"This Mod does not have any configs registered or is not using Forge's config system"), FontHelper.Palette.ALL_GRAY));
            }
            this.listeners.add(this.button);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.m_252865_(x + width - 108);
            this.button.m_253211_(y + 10);
            this.button.setHeight(height - 20);
            this.button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

