/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.math;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.api.objects.data.DhApiRaycastResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;

public class Raycast {
    private static IDhApiTerrainDataCache terrainCache = null;
    private static Instant lastCacheLoad = Instant.EPOCH;

    private Raycast() {
    }

    public static void traceDistantAsync(Vec3 direction, float tickDelta, Consumer<BlockHitResult> callback) {
        Entity cameraEntity = CommonClient.Game.f_91075_;
        if (cameraEntity == null || cameraEntity.m_9236_() == null) {
            return;
        }
        Vec3 rayStartVec = cameraEntity.m_20299_(tickDelta);
        CompletableFuture<BlockHitResult> ft = CompletableFuture.supplyAsync(() -> {
            if (DhApi.Delayed.worldProxy == null) {
                return null;
            }
            IDhApiLevelWrapper levelWrapper = DhApi.Delayed.worldProxy.getSinglePlayerLevel();
            if (levelWrapper == null) {
                return null;
            }
            if (terrainCache == null || Duration.between(lastCacheLoad, Instant.now()).getSeconds() > 10L) {
                terrainCache = DhApi.Delayed.terrainRepo.getSoftCache();
                lastCacheLoad = Instant.now();
            }
            DhApiResult rayCastResult = DhApi.Delayed.terrainRepo.raycast(levelWrapper, rayStartVec.f_82479_, rayStartVec.f_82480_, rayStartVec.f_82481_, (float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_, 4096, terrainCache);
            if (!rayCastResult.success || rayCastResult.payload == null) {
                return null;
            }
            Vec3 pos = new Vec3((double)((DhApiRaycastResult)rayCastResult.payload).pos.x, (double)((DhApiRaycastResult)rayCastResult.payload).pos.y, (double)((DhApiRaycastResult)rayCastResult.payload).pos.z);
            return new BlockHitResult(pos, Direction.UP, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), true);
        });
        ft.thenAccept(result -> Optional.ofNullable(result).ifPresent(callback));
    }

    public static HitResult traceDirectional(Vec3 direction, float tickDelta, double maxDistance, boolean hitFluids) {
        Entity cameraEntity = CommonClient.Game.f_91075_;
        if (cameraEntity == null || cameraEntity.m_9236_() == null) {
            return null;
        }
        Vec3 rayStartVec = cameraEntity.m_20299_(tickDelta);
        Vec3 rayEndVec = rayStartVec.m_82549_(direction.m_82490_(maxDistance));
        AABB boundingBox = cameraEntity.m_20191_().m_82369_(cameraEntity.m_20252_(1.0f).m_82490_(maxDistance)).m_82377_(1.0, 1.0, 1.0);
        BlockHitResult blockHitResult = cameraEntity.m_9236_().m_45547_(new ClipContext(rayStartVec, rayEndVec, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, cameraEntity));
        EntityHitResult entityHitResult = Raycast.traceEntity(cameraEntity, rayStartVec, rayEndVec, boundingBox, targetEntity -> !targetEntity.m_5833_());
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (rayStartVec.m_82557_(blockHitResult.m_82450_()) < rayStartVec.m_82557_(entityHitResult.m_82450_())) {
            return blockHitResult;
        }
        return entityHitResult;
    }

    private static EntityHitResult traceEntity(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate) {
        double minDist = min.m_82557_(max);
        EntityHitResult minHitResult = null;
        for (Entity ent : entity.m_9236_().m_6249_(entity, box, predicate)) {
            EntityHitResult hitResult;
            double hitDist;
            AABB targetBoundingBox = ent.m_20191_().m_82400_((double)ent.m_6143_()).m_82400_(0.25);
            Optional hitPos = targetBoundingBox.m_82371_(min, max);
            if (hitPos.isEmpty() || !(minDist > (hitDist = min.m_82557_((hitResult = new EntityHitResult(ent, (Vec3)hitPos.get())).m_82450_())))) continue;
            minDist = hitDist;
            minHitResult = hitResult;
        }
        return minHitResult;
    }
}

