/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTEventListeners;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.EventListenerBonus;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.event.BlockEventListener;
import daripher.skilltree.skill.bonus.event.SkillEventListener;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class InflictDamageBonus
implements EventListenerBonus<InflictDamageBonus> {
    private float chance;
    private float damage;
    private SkillEventListener eventListener;

    public InflictDamageBonus(float chance, float damage, SkillEventListener eventListener) {
        this.chance = chance;
        this.damage = damage;
        this.eventListener = eventListener;
    }

    public InflictDamageBonus(float chance, float damage) {
        this(chance, damage, new BlockEventListener());
    }

    @Override
    public void applyEffect(LivingEntity target) {
        target.m_6469_(target.m_9236_().m_269111_().m_269425_(), this.damage);
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.INFLICT_DAMAGE.get();
    }

    public InflictDamageBonus copy() {
        return new InflictDamageBonus(this.chance, this.damage, this.eventListener);
    }

    @Override
    public InflictDamageBonus multiply(double multiplier) {
        if (this.chance < 1.0f) {
            this.chance *= (float)multiplier;
        } else {
            this.damage *= (float)multiplier;
        }
        return this;
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof InflictDamageBonus)) {
            return false;
        }
        InflictDamageBonus otherBonus = (InflictDamageBonus)other;
        if (otherBonus.chance < 1.0f && this.chance < 1.0f && otherBonus.damage != this.damage) {
            return false;
        }
        return Objects.equals(otherBonus.eventListener, this.eventListener);
    }

    @Override
    public SkillBonus<EventListenerBonus<InflictDamageBonus>> merge(SkillBonus<?> other) {
        if (!(other instanceof InflictDamageBonus)) {
            throw new IllegalArgumentException();
        }
        InflictDamageBonus otherBonus = (InflictDamageBonus)other;
        if (otherBonus.chance < 1.0f && this.chance < 1.0f) {
            return new InflictDamageBonus(otherBonus.chance + this.chance, this.damage, this.eventListener);
        }
        return new InflictDamageBonus(this.chance, otherBonus.damage + this.damage, this.eventListener);
    }

    @Override
    public MutableComponent getTooltip() {
        String damageDescription = TooltipHelper.formatNumber(this.damage);
        String targetDescription = this.eventListener.getTarget().name().toLowerCase();
        String bonusDescription = this.getDescriptionId() + "." + targetDescription;
        if (this.chance < 1.0f) {
            bonusDescription = bonusDescription + ".chance";
        }
        MutableComponent tooltip = Component.m_237110_((String)bonusDescription, (Object[])new Object[]{damageDescription});
        if (this.chance < 1.0f) {
            tooltip = TooltipHelper.getSkillBonusTooltip((Component)tooltip, (double)this.chance, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        tooltip = this.eventListener.getTooltip((Component)tooltip);
        return tooltip.m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return this.chance > 0.0f ^ this.eventListener.getTarget() == SkillBonus.Target.PLAYER;
    }

    @Override
    public SkillEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, int row, Consumer<EventListenerBonus<InflictDamageBonus>> consumer) {
        editor.addLabel(0, 0, "Chance", ChatFormatting.GOLD);
        editor.addLabel(110, 0, "Duration", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 90, 14, this.chance).setNumericResponder(v -> {
            this.setChance(v.floatValue());
            consumer.accept(this.copy());
        });
        editor.addNumericTextField(110, 0, 90, 14, this.damage).setNumericResponder(v -> {
            this.setDamage(v.intValue());
            consumer.accept(this.copy());
        });
        editor.shiftWidgets(0, 19);
        editor.addLabel(0, 0, "Event", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.eventListener, PSTEventListeners.eventsList()).setToNameFunc(e -> Component.m_237113_((String)PSTEventListeners.getName(e))).setResponder(e -> {
            this.setEventListener((SkillEventListener)e);
            consumer.accept(this.copy());
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.eventListener.addEditorWidgets(editor, e -> {
            this.setEventListener((SkillEventListener)e);
            consumer.accept(this.copy());
        });
    }

    public void setEventListener(SkillEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public InflictDamageBonus deserialize(JsonObject json) throws JsonParseException {
            float chance = json.get("chance").getAsFloat();
            float damage = json.get("damage").getAsInt();
            InflictDamageBonus bonus = new InflictDamageBonus(chance, damage);
            bonus.eventListener = SerializationHelper.deserializeEventListener(json);
            return bonus;
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof InflictDamageBonus)) {
                throw new IllegalArgumentException();
            }
            InflictDamageBonus aBonus = (InflictDamageBonus)bonus;
            json.addProperty("chance", (Number)Float.valueOf(aBonus.chance));
            json.addProperty("damage", (Number)Float.valueOf(aBonus.damage));
            SerializationHelper.serializeEventListener(json, aBonus.eventListener);
        }

        @Override
        public InflictDamageBonus deserialize(CompoundTag tag) {
            float chance = tag.m_128457_("chance");
            float damage = tag.m_128457_("damage");
            InflictDamageBonus bonus = new InflictDamageBonus(chance, damage);
            bonus.eventListener = SerializationHelper.deserializeEventListener(tag);
            return bonus;
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof InflictDamageBonus)) {
                throw new IllegalArgumentException();
            }
            InflictDamageBonus aBonus = (InflictDamageBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("chance", aBonus.chance);
            tag.m_128350_("damage", aBonus.damage);
            SerializationHelper.serializeEventListener(tag, aBonus.eventListener);
            return tag;
        }

        @Override
        public InflictDamageBonus deserialize(FriendlyByteBuf buf) {
            float amount = buf.readFloat();
            float damage = buf.readFloat();
            InflictDamageBonus bonus = new InflictDamageBonus(amount, damage);
            bonus.eventListener = NetworkHelper.readEventListener(buf);
            return bonus;
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof InflictDamageBonus)) {
                throw new IllegalArgumentException();
            }
            InflictDamageBonus aBonus = (InflictDamageBonus)bonus;
            buf.writeFloat(aBonus.chance);
            buf.writeFloat(aBonus.damage);
            NetworkHelper.writeEventListener(buf, aBonus.eventListener);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new InflictDamageBonus(0.05f, 5.0f);
        }
    }
}

