/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTItemConditions;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.condition.item.ItemCondition;
import daripher.skilltree.skill.bonus.condition.item.NoneItemCondition;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class GemPowerBonus
implements SkillBonus<GemPowerBonus> {
    @Nonnull
    private ItemCondition itemCondition;
    private float multiplier;

    public GemPowerBonus(@Nonnull ItemCondition itemCondition, float multiplier) {
        this.itemCondition = itemCondition;
        this.multiplier = multiplier;
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.GEM_POWER.get();
    }

    public GemPowerBonus copy() {
        return new GemPowerBonus(this.itemCondition, this.multiplier);
    }

    @Override
    public GemPowerBonus multiply(double multiplier) {
        return new GemPowerBonus(this.itemCondition, (float)((double)this.getMultiplier() * multiplier));
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof GemPowerBonus)) {
            return false;
        }
        GemPowerBonus otherBonus = (GemPowerBonus)other;
        return Objects.equals(otherBonus.itemCondition, this.itemCondition);
    }

    @Override
    public SkillBonus<GemPowerBonus> merge(SkillBonus<?> other) {
        if (!(other instanceof GemPowerBonus)) {
            throw new IllegalArgumentException();
        }
        GemPowerBonus otherBonus = (GemPowerBonus)other;
        return new GemPowerBonus(this.itemCondition, otherBonus.multiplier + this.multiplier);
    }

    @Override
    public MutableComponent getTooltip() {
        Component itemDescription = this.itemCondition.getTooltip("crafted");
        AttributeModifier.Operation operation = AttributeModifier.Operation.MULTIPLY_BASE;
        MutableComponent bonusDescription = Component.m_237115_((String)(this.getDescriptionId() + ".bonus"));
        bonusDescription = TooltipHelper.getSkillBonusTooltip((Component)bonusDescription, (double)this.multiplier, operation).m_130948_(TooltipHelper.getItemBonusStyle(this.isPositive()));
        return Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{itemDescription, bonusDescription}).m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return this.multiplier > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, int row, Consumer<GemPowerBonus> consumer) {
        editor.addLabel(0, 0, "Multiplier", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 50, 14, this.multiplier).setNumericResponder(v -> {
            this.setMultiplier(v.floatValue());
            consumer.accept(this.copy());
        });
        editor.shiftWidgets(0, 19);
        editor.addLabel(0, 0, "Item Condition", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.itemCondition, PSTItemConditions.conditionsList()).setToNameFunc(a -> Component.m_237113_((String)PSTItemConditions.getName(a))).setResponder(c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this.copy());
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.itemCondition.addEditorWidgets(editor, c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this.copy());
        });
    }

    public void setItemCondition(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    @Nonnull
    public ItemCondition getItemCondition() {
        return this.itemCondition;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GemPowerBonus that = (GemPowerBonus)obj;
        if (!Objects.equals(this.itemCondition, that.itemCondition)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    public int hashCode() {
        return Objects.hash(this.itemCondition, Float.valueOf(this.multiplier));
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public GemPowerBonus deserialize(JsonObject json) throws JsonParseException {
            ItemCondition condition = SerializationHelper.deserializeItemCondition(json);
            float multiplier = json.get("multiplier").getAsFloat();
            return new GemPowerBonus(condition, multiplier);
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof GemPowerBonus)) {
                throw new IllegalArgumentException();
            }
            GemPowerBonus aBonus = (GemPowerBonus)bonus;
            SerializationHelper.serializeItemCondition(json, aBonus.itemCondition);
            json.addProperty("multiplier", (Number)Float.valueOf(aBonus.multiplier));
        }

        @Override
        public GemPowerBonus deserialize(CompoundTag tag) {
            ItemCondition condition = SerializationHelper.deserializeItemCondition(tag);
            float multiplier = tag.m_128457_("multiplier");
            return new GemPowerBonus(condition, multiplier);
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof GemPowerBonus)) {
                throw new IllegalArgumentException();
            }
            GemPowerBonus aBonus = (GemPowerBonus)bonus;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeItemCondition(tag, aBonus.itemCondition);
            tag.m_128350_("multiplier", aBonus.multiplier);
            return tag;
        }

        @Override
        public GemPowerBonus deserialize(FriendlyByteBuf buf) {
            return new GemPowerBonus(NetworkHelper.readItemCondition(buf), buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof GemPowerBonus)) {
                throw new IllegalArgumentException();
            }
            GemPowerBonus aBonus = (GemPowerBonus)bonus;
            NetworkHelper.writeItemCondition(buf, aBonus.itemCondition);
            buf.writeFloat(aBonus.multiplier);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new GemPowerBonus(NoneItemCondition.INSTANCE, 0.1f);
        }
    }
}

