/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.multiplier;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.entity.player.PlayerHelper;
import daripher.skilltree.init.PSTItemConditions;
import daripher.skilltree.init.PSTLivingMultipliers;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.condition.item.EquipmentCondition;
import daripher.skilltree.skill.bonus.condition.item.ItemCondition;
import daripher.skilltree.skill.bonus.multiplier.LivingMultiplier;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class EnchantsAmountMultiplier
implements LivingMultiplier {
    @Nonnull
    private ItemCondition itemCondition;

    public EnchantsAmountMultiplier(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    @Override
    public float getValue(LivingEntity entity) {
        return this.getEnchants(PlayerHelper.getAllEquipment(entity).filter(this.itemCondition::met));
    }

    private int getEnchants(Stream<ItemStack> items) {
        return items.map(EnchantmentHelper::m_44831_).map(Map::size).reduce(Integer::sum).orElse(0);
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, SkillBonus.Target target) {
        Component itemDescription = this.itemCondition.getTooltip("where");
        return Component.m_237110_((String)this.getDescriptionId(target), (Object[])new Object[]{bonusTooltip, itemDescription});
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<LivingMultiplier> consumer) {
        editor.addLabel(0, 0, "Item Condition", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.itemCondition, PSTItemConditions.conditionsList()).setToNameFunc(c -> Component.m_237113_((String)PSTItemConditions.getName(c))).setResponder(c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.itemCondition.addEditorWidgets(editor, (ItemCondition c) -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this);
        });
    }

    @Override
    public LivingMultiplier.Serializer getSerializer() {
        return (LivingMultiplier.Serializer)PSTLivingMultipliers.ENCHANTS_AMOUNT.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantsAmountMultiplier that = (EnchantsAmountMultiplier)o;
        return Objects.equals(this.itemCondition, that.itemCondition);
    }

    public int hashCode() {
        return Objects.hash(this.itemCondition);
    }

    public void setItemCondition(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    public static class Serializer
    implements LivingMultiplier.Serializer {
        @Override
        public LivingMultiplier deserialize(JsonObject json) throws JsonParseException {
            ItemCondition itemCondition = SerializationHelper.deserializeItemCondition(json);
            return new EnchantsAmountMultiplier(itemCondition);
        }

        @Override
        public void serialize(JsonObject json, LivingMultiplier multiplier) {
            if (!(multiplier instanceof EnchantsAmountMultiplier)) {
                throw new IllegalArgumentException();
            }
            EnchantsAmountMultiplier aMultiplier = (EnchantsAmountMultiplier)multiplier;
            SerializationHelper.serializeItemCondition(json, aMultiplier.itemCondition);
        }

        @Override
        public LivingMultiplier deserialize(CompoundTag tag) {
            ItemCondition itemCondition = SerializationHelper.deserializeItemCondition(tag);
            return new EnchantsAmountMultiplier(itemCondition);
        }

        @Override
        public CompoundTag serialize(LivingMultiplier multiplier) {
            if (!(multiplier instanceof EnchantsAmountMultiplier)) {
                throw new IllegalArgumentException();
            }
            EnchantsAmountMultiplier aMultiplier = (EnchantsAmountMultiplier)multiplier;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeItemCondition(tag, aMultiplier.itemCondition);
            return tag;
        }

        @Override
        public LivingMultiplier deserialize(FriendlyByteBuf buf) {
            ItemCondition itemCondition = NetworkHelper.readItemCondition(buf);
            return new EnchantsAmountMultiplier(itemCondition);
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingMultiplier multiplier) {
            if (!(multiplier instanceof EnchantsAmountMultiplier)) {
                throw new IllegalArgumentException();
            }
            EnchantsAmountMultiplier aMultiplier = (EnchantsAmountMultiplier)multiplier;
            NetworkHelper.writeItemCondition(buf, aMultiplier.itemCondition);
        }

        @Override
        public LivingMultiplier createDefaultInstance() {
            return new EnchantsAmountMultiplier(new EquipmentCondition(EquipmentCondition.Type.ANY));
        }
    }
}

