/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.event;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTEventListeners;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.init.PSTLivingMultipliers;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.EventListenerBonus;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import daripher.skilltree.skill.bonus.condition.living.NoneLivingCondition;
import daripher.skilltree.skill.bonus.event.SkillEventListener;
import daripher.skilltree.skill.bonus.multiplier.LivingMultiplier;
import daripher.skilltree.skill.bonus.multiplier.NoneLivingMultiplier;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EvasionEventListener
implements SkillEventListener {
    private LivingCondition playerCondition = NoneLivingCondition.INSTANCE;
    private LivingCondition enemyCondition = NoneLivingCondition.INSTANCE;
    private LivingMultiplier playerMultiplier = NoneLivingMultiplier.INSTANCE;
    private LivingMultiplier enemyMultiplier = NoneLivingMultiplier.INSTANCE;
    private SkillBonus.Target target = SkillBonus.Target.ENEMY;

    public void onEvent(@Nonnull Player player, @Nullable LivingEntity enemy, @Nonnull EventListenerBonus<?> skill) {
        Player target;
        if (this.enemyCondition != NoneLivingCondition.INSTANCE && enemy == null) {
            return;
        }
        if (!this.playerCondition.met((LivingEntity)player)) {
            return;
        }
        if (!this.enemyCondition.met(enemy)) {
            return;
        }
        Object object = target = this.target == SkillBonus.Target.PLAYER ? player : enemy;
        if (target == null) {
            return;
        }
        ((EventListenerBonus)skill.multiply(this.playerMultiplier.getValue((LivingEntity)player) * this.enemyMultiplier.getValue(enemy))).applyEffect((LivingEntity)target);
    }

    @Override
    public MutableComponent getTooltip(Component bonusTooltip) {
        MutableComponent eventTooltip = Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{bonusTooltip});
        eventTooltip = this.playerCondition.getTooltip(eventTooltip, "you");
        eventTooltip = this.enemyCondition.getTooltip(eventTooltip, "target");
        eventTooltip = this.playerMultiplier.getTooltip(eventTooltip, SkillBonus.Target.PLAYER);
        eventTooltip = this.enemyMultiplier.getTooltip(eventTooltip, SkillBonus.Target.ENEMY);
        return eventTooltip;
    }

    @Override
    public SkillEventListener.Serializer getSerializer() {
        return (SkillEventListener.Serializer)PSTEventListeners.EVASION.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvasionEventListener listener = (EvasionEventListener)o;
        return Objects.equals(this.playerCondition, listener.playerCondition) && Objects.equals(this.enemyCondition, listener.enemyCondition) && Objects.equals(this.playerMultiplier, listener.playerMultiplier) && Objects.equals(this.enemyMultiplier, listener.enemyMultiplier) && this.target == listener.target;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.playerCondition, this.enemyCondition, this.playerMultiplier, this.enemyMultiplier, this.target});
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<SkillEventListener> consumer) {
        editor.addLabel(0, 0, "Player Condition", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.playerCondition, PSTLivingConditions.conditionsList()).setToNameFunc(c -> Component.m_237113_((String)PSTLivingConditions.getName(c))).setResponder(c -> {
            this.setPlayerCondition((LivingCondition)c);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.playerCondition.addEditorWidgets(editor, (LivingCondition c) -> {
            this.setPlayerCondition((LivingCondition)c);
            consumer.accept(this);
        });
        editor.addLabel(0, 0, "Enemy Condition", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.enemyCondition, PSTLivingConditions.conditionsList()).setToNameFunc(c -> Component.m_237113_((String)PSTLivingConditions.getName(c))).setResponder(c -> {
            this.setEnemyCondition((LivingCondition)c);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.enemyCondition.addEditorWidgets(editor, (LivingCondition c) -> {
            this.setEnemyCondition((LivingCondition)c);
            consumer.accept(this);
        });
        editor.addLabel(0, 0, "Player Multiplier", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.playerMultiplier, PSTLivingMultipliers.multiplierList()).setToNameFunc(m -> Component.m_237113_((String)PSTLivingMultipliers.getName(m))).setResponder(m -> {
            this.setPlayerMultiplier((LivingMultiplier)m);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.playerMultiplier.addEditorWidgets(editor, (LivingMultiplier m) -> {
            this.setPlayerMultiplier((LivingMultiplier)m);
            consumer.accept(this);
        });
        editor.addLabel(0, 0, "Enemy Multiplier", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.enemyMultiplier, PSTLivingMultipliers.multiplierList()).setToNameFunc(m -> Component.m_237113_((String)PSTLivingMultipliers.getName(m))).setResponder(m -> {
            this.setEnemyMultiplier((LivingMultiplier)m);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.enemyMultiplier.addEditorWidgets(editor, (LivingMultiplier m) -> {
            this.setPlayerMultiplier((LivingMultiplier)m);
            consumer.accept(this);
        });
        editor.addLabel(0, 0, "Target", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 95, 14, 10, this.target).setToNameFunc(t -> Component.m_237113_((String)TooltipHelper.idToName(t.name().toLowerCase()))).setResponder(t -> {
            this.setTarget((SkillBonus.Target)((Object)t));
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    @Override
    public SkillBonus.Target getTarget() {
        return this.target;
    }

    public void setEnemyCondition(LivingCondition enemyCondition) {
        this.enemyCondition = enemyCondition;
    }

    public void setPlayerCondition(LivingCondition playerCondition) {
        this.playerCondition = playerCondition;
    }

    public void setEnemyMultiplier(LivingMultiplier enemyMultiplier) {
        this.enemyMultiplier = enemyMultiplier;
    }

    public void setPlayerMultiplier(LivingMultiplier playerMultiplier) {
        this.playerMultiplier = playerMultiplier;
    }

    public void setTarget(SkillBonus.Target target) {
        this.target = target;
    }

    public static class Serializer
    implements SkillEventListener.Serializer {
        @Override
        public SkillEventListener deserialize(JsonObject json) throws JsonParseException {
            EvasionEventListener listener = new EvasionEventListener();
            listener.setEnemyCondition(SerializationHelper.deserializeLivingCondition(json, "enemy_condition"));
            listener.setPlayerCondition(SerializationHelper.deserializeLivingCondition(json, "player_condition"));
            listener.setEnemyMultiplier(SerializationHelper.deserializeLivingMultiplier(json, "enemy_multiplier"));
            listener.setPlayerMultiplier(SerializationHelper.deserializeLivingMultiplier(json, "player_multiplier"));
            listener.setTarget(SkillBonus.Target.valueOf(json.get("target").getAsString().toUpperCase()));
            return listener;
        }

        @Override
        public void serialize(JsonObject json, SkillEventListener listener) {
            if (!(listener instanceof EvasionEventListener)) {
                throw new IllegalArgumentException();
            }
            EvasionEventListener aListener = (EvasionEventListener)listener;
            SerializationHelper.serializeLivingCondition(json, aListener.enemyCondition, "enemy_condition");
            SerializationHelper.serializeLivingCondition(json, aListener.playerCondition, "player_condition");
            SerializationHelper.serializeLivingMultiplier(json, aListener.enemyMultiplier, "enemy_multiplier");
            SerializationHelper.serializeLivingMultiplier(json, aListener.playerMultiplier, "player_multiplier");
            json.addProperty("target", aListener.target.name().toLowerCase());
        }

        @Override
        public SkillEventListener deserialize(CompoundTag tag) {
            EvasionEventListener listener = new EvasionEventListener();
            listener.setEnemyCondition(SerializationHelper.deserializeLivingCondition(tag, "enemy_condition"));
            listener.setPlayerCondition(SerializationHelper.deserializeLivingCondition(tag, "player_condition"));
            listener.setEnemyMultiplier(SerializationHelper.deserializeLivingMultiplier(tag, "enemy_multiplier"));
            listener.setPlayerMultiplier(SerializationHelper.deserializeLivingMultiplier(tag, "player_multiplier"));
            listener.setTarget(SkillBonus.Target.valueOf(tag.m_128461_("target").toUpperCase()));
            return listener;
        }

        @Override
        public CompoundTag serialize(SkillEventListener listener) {
            if (!(listener instanceof EvasionEventListener)) {
                throw new IllegalArgumentException();
            }
            EvasionEventListener aListener = (EvasionEventListener)listener;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeLivingCondition(tag, aListener.enemyCondition, "enemy_condition");
            SerializationHelper.serializeLivingCondition(tag, aListener.playerCondition, "player_condition");
            SerializationHelper.serializeLivingMultiplier(tag, aListener.enemyMultiplier, "enemy_multiplier");
            SerializationHelper.serializeLivingMultiplier(tag, aListener.playerMultiplier, "player_multiplier");
            tag.m_128359_("target", aListener.target.name().toLowerCase());
            return tag;
        }

        @Override
        public SkillEventListener deserialize(FriendlyByteBuf buf) {
            EvasionEventListener listener = new EvasionEventListener();
            listener.setEnemyCondition(NetworkHelper.readLivingCondition(buf));
            listener.setPlayerCondition(NetworkHelper.readLivingCondition(buf));
            listener.setEnemyMultiplier(NetworkHelper.readLivingMultiplier(buf));
            listener.setPlayerMultiplier(NetworkHelper.readLivingMultiplier(buf));
            listener.setTarget(SkillBonus.Target.values()[buf.readInt()]);
            return listener;
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillEventListener listener) {
            if (!(listener instanceof EvasionEventListener)) {
                throw new IllegalArgumentException();
            }
            EvasionEventListener aListener = (EvasionEventListener)listener;
            NetworkHelper.writeLivingCondition(buf, aListener.enemyCondition);
            NetworkHelper.writeLivingCondition(buf, aListener.playerCondition);
            NetworkHelper.writeLivingMultiplier(buf, aListener.enemyMultiplier);
            NetworkHelper.writeLivingMultiplier(buf, aListener.playerMultiplier);
            buf.writeInt(aListener.target.ordinal());
        }

        @Override
        public SkillEventListener createDefaultInstance() {
            return new EvasionEventListener();
        }
    }
}

