/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.condition.living;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public final class HasEffectCondition
implements LivingCondition {
    private MobEffect effect;
    private int amplifier;

    public HasEffectCondition(MobEffect effect) {
        this(effect, 0);
    }

    public HasEffectCondition(MobEffect effect, int amplifier) {
        this.effect = effect;
        this.amplifier = amplifier;
    }

    @Override
    public boolean met(LivingEntity living) {
        if (this.amplifier == 0) {
            return living.m_21023_(this.effect);
        }
        MobEffectInstance effect = living.m_21124_(this.effect);
        return effect != null && effect.m_19564_() >= this.amplifier;
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, String target) {
        String key = this.getDescriptionId();
        MutableComponent targetDescription = Component.m_237115_((String)"%s.target.%s".formatted(key, target));
        Component effectDescription = this.effect.m_19482_();
        if (this.amplifier == 0) {
            return Component.m_237110_((String)key, (Object[])new Object[]{bonusTooltip, targetDescription, effectDescription});
        }
        MutableComponent amplifierDescription = Component.m_237115_((String)("potion.potency." + this.amplifier));
        effectDescription = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectDescription, amplifierDescription});
        return Component.m_237110_((String)(key + ".amplifier"), (Object[])new Object[]{bonusTooltip, targetDescription, effectDescription});
    }

    @Override
    public LivingCondition.Serializer getSerializer() {
        return (LivingCondition.Serializer)PSTLivingConditions.HAS_EFFECT.get();
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<LivingCondition> consumer) {
        editor.addLabel(0, 0, "Effect", ChatFormatting.GREEN);
        editor.addLabel(150, 0, "Level", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 145, 14, 10, this.effect, ForgeRegistries.MOB_EFFECTS.getValues()).setToNameFunc(a -> Component.m_237115_((String)a.m_19481_())).setResponder(e -> {
            this.setEffect((MobEffect)e);
            consumer.accept(this);
        });
        editor.addNumericTextField(150, 0, 50, 14, this.amplifier).setNumericFilter(d -> d >= 0.0 && d == (double)d.intValue()).setNumericResponder(v -> {
            this.setAmplifier(v.intValue());
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasEffectCondition that = (HasEffectCondition)o;
        return this.amplifier == that.amplifier && Objects.equals(this.effect, that.effect);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.amplifier);
    }

    public void setEffect(MobEffect effect) {
        this.effect = effect;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public static class Serializer
    implements LivingCondition.Serializer {
        @Override
        public LivingCondition deserialize(JsonObject json) throws JsonParseException {
            MobEffect effect = SerializationHelper.deserializeEffect(json);
            int amplifier = !json.has("amplifier") ? 0 : json.get("amplifier").getAsInt();
            return new HasEffectCondition(effect, amplifier);
        }

        @Override
        public void serialize(JsonObject json, LivingCondition condition) {
            if (!(condition instanceof HasEffectCondition)) {
                throw new IllegalArgumentException();
            }
            HasEffectCondition aCondition = (HasEffectCondition)condition;
            SerializationHelper.serializeEffect(json, aCondition.effect);
            json.addProperty("amplifier", (Number)aCondition.amplifier);
        }

        @Override
        public LivingCondition deserialize(CompoundTag tag) {
            MobEffect effect = SerializationHelper.deserializeEffect(tag);
            int amplifier = !tag.m_128441_("amplifier") ? 0 : tag.m_128451_("amplifier");
            return new HasEffectCondition(effect, amplifier);
        }

        @Override
        public CompoundTag serialize(LivingCondition condition) {
            if (!(condition instanceof HasEffectCondition)) {
                throw new IllegalArgumentException();
            }
            HasEffectCondition aCondition = (HasEffectCondition)condition;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeEffect(tag, aCondition.effect);
            tag.m_128405_("amplifier", aCondition.amplifier);
            return tag;
        }

        @Override
        public LivingCondition deserialize(FriendlyByteBuf buf) {
            return new HasEffectCondition(NetworkHelper.readEffect(buf), buf.readInt());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingCondition condition) {
            if (!(condition instanceof HasEffectCondition)) {
                throw new IllegalArgumentException();
            }
            HasEffectCondition aCondition = (HasEffectCondition)condition;
            NetworkHelper.writeEffect(buf, aCondition.effect);
            buf.writeInt(aCondition.amplifier);
        }

        @Override
        public LivingCondition createDefaultInstance() {
            return new HasEffectCondition(MobEffects.f_19614_);
        }
    }
}

