/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.condition.living;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class FoodLevelCondition
implements LivingCondition {
    private int min;
    private int max;

    public FoodLevelCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean met(LivingEntity living) {
        if (!(living instanceof Player)) {
            return false;
        }
        Player player = (Player)living;
        int hunger = player.m_36324_().m_38702_();
        if (this.min == -1) {
            return hunger <= this.max;
        }
        if (this.max == -1) {
            return hunger >= this.min;
        }
        return hunger <= this.max && hunger >= this.min;
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, String target) {
        String key = this.getDescriptionId();
        MutableComponent targetDescription = Component.m_237115_((String)"%s.target.%s".formatted(key, target));
        if (this.min == -1) {
            return Component.m_237110_((String)(key + ".max"), (Object[])new Object[]{bonusTooltip, targetDescription, this.max});
        }
        if (this.max == -1) {
            if (this.min == 1) {
                return Component.m_237110_((String)(key + ".min.1"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min});
            }
            return Component.m_237110_((String)(key + ".min"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min});
        }
        return Component.m_237110_((String)(key + ".range"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min, this.max});
    }

    @Override
    public LivingCondition.Serializer getSerializer() {
        return (LivingCondition.Serializer)PSTLivingConditions.FOOD_LEVEL.get();
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<LivingCondition> consumer) {
        editor.addLabel(0, 0, "Min", ChatFormatting.GREEN);
        editor.addLabel(55, 0, "Max", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 50, 14, this.min).setNumericResponder(a -> {
            this.setMin(a.intValue());
            consumer.accept(this);
        });
        editor.addNumericTextField(55, 0, 50, 14, this.max).setNumericResponder(a -> {
            this.setMax(a.intValue());
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoodLevelCondition that = (FoodLevelCondition)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public static class Serializer
    implements LivingCondition.Serializer {
        @Override
        public LivingCondition deserialize(JsonObject json) throws JsonParseException {
            int min = json.has("min") ? json.get("min").getAsInt() : -1;
            int max = json.has("max") ? json.get("max").getAsInt() : -1;
            return new FoodLevelCondition(min, max);
        }

        @Override
        public void serialize(JsonObject json, LivingCondition condition) {
            if (!(condition instanceof FoodLevelCondition)) {
                throw new IllegalArgumentException();
            }
            FoodLevelCondition aCondition = (FoodLevelCondition)condition;
            if (aCondition.min != -1) {
                json.addProperty("min", (Number)aCondition.min);
            }
            if (aCondition.max != -1) {
                json.addProperty("max", (Number)aCondition.max);
            }
        }

        @Override
        public LivingCondition deserialize(CompoundTag tag) {
            int min = tag.m_128441_("min") ? tag.m_128451_("min") : -1;
            int max = tag.m_128441_("max") ? tag.m_128451_("max") : -1;
            return new FoodLevelCondition(min, max);
        }

        @Override
        public CompoundTag serialize(LivingCondition condition) {
            if (!(condition instanceof FoodLevelCondition)) {
                throw new IllegalArgumentException();
            }
            FoodLevelCondition aCondition = (FoodLevelCondition)condition;
            CompoundTag tag = new CompoundTag();
            if (aCondition.min != -1) {
                tag.m_128405_("min", aCondition.min);
            }
            if (aCondition.max != -1) {
                tag.m_128405_("max", aCondition.max);
            }
            return tag;
        }

        @Override
        public LivingCondition deserialize(FriendlyByteBuf buf) {
            return new FoodLevelCondition(buf.readInt(), buf.readInt());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingCondition condition) {
            if (!(condition instanceof FoodLevelCondition)) {
                throw new IllegalArgumentException();
            }
            FoodLevelCondition aCondition = (FoodLevelCondition)condition;
            buf.writeInt(aCondition.min);
            buf.writeInt(aCondition.max);
        }

        @Override
        public LivingCondition createDefaultInstance() {
            return new FoodLevelCondition(15, -1);
        }
    }
}

