/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.skill.bonus.item.ItemDurabilityBonus;
import java.util.List;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements IForgeItemStack {
    @ModifyReturnValue(method={"getMaxDamage"}, at={@At(value="RETURN")})
    private int applyDurabilityModifiers(int original) {
        List<ItemDurabilityBonus> durabilityBonuses = ItemHelper.getDurabilityBonuses((ItemStack)this);
        original = (int)((float)original + ItemStackMixin.getDurabilityBonus(durabilityBonuses, AttributeModifier.Operation.ADDITION));
        original = (int)((float)original * ItemStackMixin.getDurabilityBonus(durabilityBonuses, AttributeModifier.Operation.MULTIPLY_BASE));
        original = (int)((float)original * ItemStackMixin.getDurabilityBonus(durabilityBonuses, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return original;
    }

    private static float getDurabilityBonus(List<ItemDurabilityBonus> durabilityBonuses, AttributeModifier.Operation operation) {
        float bonus = operation == AttributeModifier.Operation.ADDITION ? 0.0f : 1.0f;
        return bonus += durabilityBonuses.stream().filter(b -> b.getOperation() == operation).map(ItemDurabilityBonus::getAmount).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

