/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.quiver;

import daripher.skilltree.item.ItemBonusProvider;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import daripher.skilltree.skill.bonus.item.QuiverCapacityBonus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="skilltree")
public class QuiverItem
extends Item
implements ICurioItem,
ItemBonusProvider {
    private static final String ARROWS_TAG = "Arrows";
    private static final String ARROWS_COUNT_TAG = "ArrowsCount";
    private final int capacity;

    public QuiverItem(int capacity) {
        super(new Item.Properties().m_41487_(1).m_41503_(capacity));
        this.capacity = capacity;
    }

    public QuiverItem() {
        this(250);
    }

    @SubscribeEvent
    public static void storeArrowsOnPickup(EntityItemPickupEvent event) {
        ItemStack arrows = event.getItem().m_32055_();
        if (!(arrows.m_41720_() instanceof ArrowItem)) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).ifPresent(inv -> {
            Optional curio = inv.findFirstCurio(ItemHelper::isQuiver);
            if (curio.isEmpty()) {
                return;
            }
            ItemStack quiver = ((SlotResult)curio.get()).stack();
            if (quiver.m_41619_() || QuiverItem.isFull(quiver)) {
                return;
            }
            if (!QuiverItem.containsArrows(quiver)) {
                QuiverItem.setArrows(quiver, arrows.m_41777_(), arrows.m_41613_());
                event.getItem().m_32045_(ItemStack.f_41583_);
                event.setResult(Event.Result.ALLOW);
            } else if (ItemStack.m_150942_((ItemStack)QuiverItem.getArrows(quiver), (ItemStack)arrows)) {
                int capacity = QuiverItem.getCapacity(quiver);
                int arrowsTaken = Math.min(capacity - QuiverItem.getArrowsCount(quiver), arrows.m_41613_());
                QuiverItem.addArrows(quiver, arrowsTaken);
                if (arrows.m_41613_() == arrowsTaken) {
                    event.getItem().m_32045_(ItemStack.f_41583_);
                } else {
                    arrows.m_41774_(arrowsTaken);
                }
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void takeArrowFromQuiver(LivingGetProjectileEvent event) {
        CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).ifPresent(inv -> {
            Optional curio = inv.findFirstCurio(ItemHelper::isQuiver);
            if (curio.isEmpty()) {
                return;
            }
            ItemStack quiver = ((SlotResult)curio.get()).stack();
            if (quiver.m_41619_()) {
                return;
            }
            if (QuiverItem.containsArrows(quiver)) {
                event.setProjectileItemStack(QuiverItem.getArrows(quiver).m_41777_());
            }
        });
    }

    @SubscribeEvent
    public static void removeArrowFromQuiver(ArrowLooseEvent event) {
        if (event.getEntity().m_7500_()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).ifPresent(inv -> {
            Optional curio = inv.findFirstCurio(ItemHelper::isQuiver);
            if (curio.isEmpty()) {
                return;
            }
            ItemStack quiver = ((SlotResult)curio.get()).stack();
            if (quiver.m_41619_()) {
                return;
            }
            if (QuiverItem.containsArrows(quiver)) {
                QuiverItem.addArrows(quiver, -1);
            }
        });
    }

    public static boolean isFull(ItemStack quiver) {
        return QuiverItem.getArrowsCount(quiver) == QuiverItem.getCapacity(quiver);
    }

    public static boolean isEmpty(ItemStack quiver) {
        return QuiverItem.getArrowsCount(quiver) == 0;
    }

    public static int getCapacity(ItemStack quiver) {
        int capacity = ((QuiverItem)quiver.m_41720_()).capacity;
        capacity += (int)QuiverItem.getCapacityBonus(quiver, AttributeModifier.Operation.ADDITION);
        float multiplier = 1.0f + QuiverItem.getCapacityBonus(quiver, AttributeModifier.Operation.MULTIPLY_BASE);
        capacity = (int)((float)capacity * multiplier);
        multiplier = 1.0f + QuiverItem.getCapacityBonus(quiver, AttributeModifier.Operation.MULTIPLY_TOTAL);
        capacity = (int)((float)capacity * multiplier);
        return capacity;
    }

    private static float getCapacityBonus(ItemStack quiver, AttributeModifier.Operation operation) {
        return ItemHelper.getItemBonuses(quiver, QuiverCapacityBonus.class).stream().filter(b -> b.getOperation() == operation).map(QuiverCapacityBonus::getAmount).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static boolean containsArrows(ItemStack stack) {
        return stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_(ARROWS_TAG) && !QuiverItem.getArrows(stack).m_41619_() && QuiverItem.getArrowsCount(stack) > 0;
    }

    public static ItemStack getArrows(ItemStack stack) {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)Objects.requireNonNull(stack.m_41784_().m_128423_(ARROWS_TAG))));
    }

    public static int getArrowsCount(ItemStack stack) {
        return stack.m_41784_().m_128451_(ARROWS_COUNT_TAG);
    }

    public static void addArrows(ItemStack stack, ItemStack arrows, int count) {
        if (QuiverItem.isEmpty(stack)) {
            QuiverItem.setArrows(stack, arrows);
        }
        QuiverItem.addArrows(stack, count);
    }

    public static void setArrows(ItemStack stack, ItemStack arrows, int count) {
        arrows = arrows.m_41777_();
        arrows.m_41764_(1);
        stack.m_41784_().m_128365_(ARROWS_TAG, (Tag)arrows.m_41739_(new CompoundTag()));
        QuiverItem.setArrowsCount(stack, count);
    }

    public static void setArrows(ItemStack stack, ItemStack arrow) {
        stack.m_41784_().m_128365_(ARROWS_TAG, (Tag)arrow.m_41739_(new CompoundTag()));
    }

    public static void setArrowsCount(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(ARROWS_COUNT_TAG, count);
    }

    public static void addArrows(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(ARROWS_COUNT_TAG, QuiverItem.getArrowsCount(stack) + count);
    }

    public void m_7373_(@NotNull ItemStack stack, Level level, List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent capacity = Component.m_237113_((String)("" + QuiverItem.getCapacity(stack))).m_130940_(ChatFormatting.BLUE);
        components.add((Component)Component.m_237110_((String)"quiver.capacity", (Object[])new Object[]{capacity}).m_130940_(ChatFormatting.YELLOW));
        if (!QuiverItem.containsArrows(stack)) {
            return;
        }
        ItemStack arrows = QuiverItem.getArrows(stack);
        MutableComponent arrowName = Component.m_237119_().m_7220_(arrows.m_41786_()).m_130940_(ChatFormatting.GRAY);
        MutableComponent contents = Component.m_237110_((String)"quiver.contents", (Object[])new Object[]{arrowName}).m_130940_(ChatFormatting.YELLOW);
        components.add((Component)contents);
        arrows.m_41720_().m_7373_(arrows, level, components, tooltipFlag);
    }

    public int getDamage(ItemStack stack) {
        if (!QuiverItem.containsArrows(stack)) {
            return 0;
        }
        return QuiverItem.getCapacity(stack) - QuiverItem.getArrowsCount(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        int arrowsLeft;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        for (arrowsLeft = QuiverItem.getArrowsCount(stack); arrowsLeft >= 64; arrowsLeft -= 64) {
            this.dropArrows(player, stack, 64);
        }
        if (arrowsLeft > 0) {
            this.dropArrows(player, stack, arrowsLeft);
        }
        QuiverItem.setArrows(stack, ItemStack.f_41583_, 0);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        this.getItemBonuses().stream().map(ItemBonus::getTooltip).forEach(tooltips::add);
        return tooltips;
    }

    @Override
    @NotNull
    public List<ItemBonus<?>> getItemBonuses() {
        return List.of();
    }

    private void dropArrows(Player player, ItemStack stack, int count) {
        ItemStack arrowsStack = QuiverItem.getArrows(stack).m_41777_();
        arrowsStack.m_41764_(count);
        player.m_19983_(arrowsStack);
    }
}

