/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import daripher.skilltree.client.data.SkillTexturesData;
import daripher.skilltree.client.data.SkillTreeClientData;
import daripher.skilltree.client.screen.ScreenHelper;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.Button;
import daripher.skilltree.client.widget.CheckBox;
import daripher.skilltree.client.widget.ConfirmationButton;
import daripher.skilltree.client.widget.DropDownList;
import daripher.skilltree.client.widget.Label;
import daripher.skilltree.client.widget.NumericTextField;
import daripher.skilltree.client.widget.SkillButton;
import daripher.skilltree.client.widget.SkillConnection;
import daripher.skilltree.client.widget.TextArea;
import daripher.skilltree.client.widget.TextField;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.skill.PassiveSkill;
import daripher.skilltree.skill.PassiveSkillTree;
import daripher.skilltree.skill.bonus.SkillBonus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;

public class SkillTreeEditorScreen
extends Screen {
    private final Map<ResourceLocation, SkillButton> skillButtons = new HashMap<ResourceLocation, SkillButton>();
    private final List<SkillConnection> skillConnections = new ArrayList<SkillConnection>();
    private final Set<ResourceLocation> selectedSkills = new LinkedHashSet<ResourceLocation>();
    private final PassiveSkillTree skillTree;
    private Tools selectedTools = Tools.MAIN;
    protected float scrollSpeedX;
    protected float scrollSpeedY;
    protected float scrollX;
    protected float scrollY;
    protected int maxScrollX;
    protected int maxScrollY;
    protected int toolsY;
    protected int toolsX;
    private boolean closeOnEsc = true;
    private int prevMouseX;
    private int prevMouseY;
    private float zoom = 1.0f;
    private int selectedSubMenu = -1;
    private int dragX;
    private int dragY;
    private boolean selectingArea;
    private boolean mirroring;
    private float mirrorAngle;
    private int mirrorSides = 2;
    private float mirrorCenterX;
    private float mirrorCenterY;
    private double lastUsedDistance = 10.0;
    private double lastUsedAngle = 0.0;
    private static final Set<Attribute> EDITABLE_ATTRIBUTES = new HashSet<Attribute>();

    public SkillTreeEditorScreen(ResourceLocation skillTreeId) {
        super((Component)Component.m_237119_());
        this.f_96541_ = Minecraft.m_91087_();
        this.skillTree = SkillTreeClientData.getOrCreateEditorTree(skillTreeId);
    }

    public void m_7856_() {
        if (this.skillTree == null) {
            this.getMinecraft().m_91152_(null);
            return;
        }
        this.m_169413_();
        this.addSkillButtons();
        this.maxScrollX -= this.f_96543_ / 2 - 350;
        this.maxScrollY -= this.f_96544_ / 2 - 350;
        if (this.maxScrollX < 0) {
            this.maxScrollX = 0;
        }
        if (this.maxScrollY < 0) {
            this.maxScrollY = 0;
        }
        this.addSkillConnections();
        this.addToolButtons();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.updateScroll(partialTick);
        this.m_280273_(graphics);
        this.renderConnections(graphics, mouseX, mouseY);
        this.renderSkills(graphics, mouseX, mouseY, partialTick);
        this.renderMirrorMode(graphics);
        this.renderOverlay(graphics);
        this.renderWidgets(graphics, mouseX, mouseY, partialTick);
        this.renderSkillTooltip(graphics, mouseX, mouseY, partialTick);
        this.renderSkillSelection(graphics, mouseX, mouseY);
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
    }

    private void renderMirrorMode(@NotNull GuiGraphics graphics) {
        if (!this.mirroring) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f + this.mirrorCenterX + this.scrollX, (float)this.f_96544_ / 2.0f + this.mirrorCenterY + this.scrollY, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.mirrorAngle));
        for (int i = 0; i < this.mirrorSides; ++i) {
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(360.0f / (float)this.mirrorSides));
            graphics.m_280509_(-1, -1, 1, this.f_96543_ * 2, 0x55CFCFCF);
        }
        ScreenHelper.drawRectangle(graphics, -4, -4, 8, 8, 0x55CFCFCF);
        graphics.m_280168_().m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.selectedSkills.isEmpty()) {
            graphics.m_280509_(this.toolsX - 10, 0, this.f_96543_, this.toolsY, -587202560);
        }
        for (Renderable widget : this.f_169369_) {
            if (widget instanceof SkillButton) continue;
            widget.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        this.widgets().filter(DropDownList.class::isInstance).map(DropDownList.class::cast).forEach(w -> w.renderList(graphics));
        graphics.m_280168_().m_85849_();
    }

    private void renderSkillTooltip(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.getWidgetAt(mouseX, mouseY).isPresent()) {
            return;
        }
        SkillButton skillAtMouse = this.getSkillAt(mouseX, mouseY);
        float tooltipX = (float)mouseX + (float)(this.prevMouseX - mouseX) * partialTick;
        float tooltipY = (float)mouseY + (float)(this.prevMouseY - mouseY) * partialTick;
        if (skillAtMouse == null) {
            return;
        }
        ScreenHelper.renderSkillTooltip(this.skillTree, skillAtMouse, graphics, tooltipX, tooltipY, this.f_96543_, this.f_96544_);
    }

    private void renderSkills(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(this.scrollX, this.scrollY, 0.0f);
        for (SkillButton widget : this.skillButtons.values()) {
            graphics.m_280168_().m_85836_();
            double widgetCenterX = widget.x + (float)widget.m_5711_() / 2.0f;
            double widgetCenterY = widget.y + (float)widget.m_93694_() / 2.0f;
            graphics.m_280168_().m_85837_(widgetCenterX, widgetCenterY, 0.0);
            graphics.m_280168_().m_85841_(this.zoom, this.zoom, 1.0f);
            graphics.m_280168_().m_85837_(-widgetCenterX, -widgetCenterY, 0.0);
            widget.m_88315_(graphics, mouseX, mouseY, partialTick);
            if (this.selectedSkills.contains(widget.skill.getId())) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(widget.x, widget.y, 0.0f);
                this.renderSkillSelection(graphics, widget);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderSkillSelection(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.selectingArea) {
            return;
        }
        ScreenHelper.drawRectangle(graphics, this.dragX, this.dragY, mouseX - this.dragX, mouseY - this.dragY, -292164812);
    }

    private void renderSkillSelection(GuiGraphics graphics, SkillButton widget) {
        ScreenHelper.drawRectangle(graphics, -1, -1, widget.m_5711_() + 2, widget.m_93694_() + 2, -1439498496);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.clickedWidget(mouseX, mouseY, button)) {
            return true;
        }
        if (SkillTreeEditorScreen.m_96638_() && button == 0) {
            this.selectingArea = true;
            this.dragX = (int)mouseX;
            this.dragY = (int)mouseY;
        }
        return this.clickedSkill(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.selectingArea) {
            this.addSelectedSkillsToSelection(mouseX, mouseY);
            this.selectingArea = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void addSelectedSkillsToSelection(double mouseX, double mouseY) {
        double temp;
        double sx1 = (float)this.dragX - this.scrollX;
        double sx2 = mouseX - (double)this.scrollX;
        double sy1 = (float)this.dragY - this.scrollY;
        double sy2 = mouseY - (double)this.scrollY;
        if (sx1 > sx2) {
            temp = sx1;
            sx1 = sx2;
            sx2 = temp;
        }
        if (sy1 < sy2) {
            temp = sy1;
            sy1 = sy2;
            sy2 = temp;
        }
        for (SkillButton skill : this.skillButtons.values()) {
            double by2;
            double by1;
            double bx2;
            double skillSize = (float)skill.skill.getButtonSize() * this.zoom;
            double bx1 = (double)skill.x + (double)skill.m_5711_() / 2.0 - skillSize / 2.0;
            if (!this.overlap(sx1, sx2, sy1, sy2, bx1, bx2 = bx1 + skillSize, by1 = (by2 = (double)skill.y + (double)skill.m_93694_() / 2.0 - skillSize / 2.0) + skillSize, by2)) continue;
            this.selectedSkills.add(skill.skill.getId());
        }
        this.m_232761_();
    }

    private boolean overlap(double x1, double x2, double y1, double y2, double x3, double x4, double y3, double y4) {
        return x1 < x4 && x2 > x3 && y1 > y4 && y2 < y3;
    }

    private boolean clickedWidget(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (GuiEventListener guiEventListener : this.widgets().toList()) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            clicked = true;
        }
        return clicked;
    }

    private boolean clickedSkill(double mouseX, double mouseY) {
        SkillButton skill = this.getSkillAt(mouseX, mouseY);
        if (skill == null) {
            return false;
        }
        this.playButtonSound();
        this.skillButtonPressed(skill);
        return true;
    }

    private void playButtonSound() {
        this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private List<AbstractWidget> textFields() {
        ArrayList<AbstractWidget> list = new ArrayList<AbstractWidget>();
        for (GuiEventListener widget : this.m_6702_()) {
            if (!this.isTextField(widget)) continue;
            list.add((AbstractWidget)widget);
        }
        return list;
    }

    private List<DropDownList> dropDownLists() {
        ArrayList<DropDownList> list = new ArrayList<DropDownList>();
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof DropDownList)) continue;
            list.add((DropDownList)widget);
        }
        return list;
    }

    private boolean isTextField(GuiEventListener widget) {
        return widget instanceof EditBox || widget instanceof MultiLineEditBox;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.selectedSubMenu != -1) {
                this.selectSubMenu(-1);
                this.closeOnEsc = false;
                return true;
            }
            if (this.selectedTools != Tools.MAIN) {
                this.selectTools(Tools.MAIN);
                this.closeOnEsc = false;
                return true;
            }
            if (!this.selectedSkills.isEmpty()) {
                this.selectedSkills.clear();
                this.m_232761_();
                this.closeOnEsc = false;
                return true;
            }
            if (this.m_6913_()) {
                this.m_7379_();
                return true;
            }
        }
        if (keyCode == 78 && Screen.m_96637_()) {
            this.createNewSkill(0.0f, 0.0f, null);
            this.m_232761_();
            return true;
        }
        return this.keyPressedOnTextField(keyCode, scanCode, modifiers);
    }

    private boolean keyPressedOnTextField(int keyCode, int scanCode, int modifiers) {
        return this.textFields().stream().anyMatch(b -> b.m_7933_(keyCode, scanCode, modifiers));
    }

    public boolean m_6913_() {
        if (!this.closeOnEsc) {
            this.closeOnEsc = true;
            return false;
        }
        return super.m_6913_();
    }

    private void removeSelectedSkills() {
        this.selectedSkills().forEach(skill -> {
            this.skillTree.getSkillIds().remove(skill.getId());
            SkillTreeClientData.deleteEditorSkill(skill);
            SkillTreeClientData.saveEditorSkillTree(this.skillTree);
        });
        this.selectedSkills.clear();
        this.m_232761_();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.textFields().forEach(b -> b.m_7920_(keyCode, scanCode, modifiers));
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int keyCode) {
        for (AbstractWidget textField : this.textFields()) {
            if (!textField.m_5534_(character, keyCode)) continue;
            return true;
        }
        for (DropDownList dropDownList : this.dropDownLists()) {
            if (!dropDownList.m_5534_(character, keyCode)) continue;
            return true;
        }
        return false;
    }

    private Optional<? extends GuiEventListener> getWidgetAt(double mouseX, double mouseY) {
        Optional<DropDownList> openedList = this.widgets().filter(DropDownList.class::isInstance).map(DropDownList.class::cast).filter(w -> w.isOpened() && w.m_5953_(mouseX, mouseY)).findFirst();
        if (openedList.isPresent()) {
            return openedList;
        }
        return this.widgets().filter(w -> w.m_5953_(mouseX, mouseY)).findFirst();
    }

    private Stream<? extends GuiEventListener> widgets() {
        return this.m_6702_().stream().filter(Predicate.not(SkillButton.class::isInstance));
    }

    @Nullable
    private SkillButton getSkillAt(double mouseX, double mouseY) {
        if (mouseX > (double)this.toolsX && mouseY < (double)this.toolsY) {
            return null;
        }
        mouseX -= (double)this.scrollX;
        mouseY -= (double)this.scrollY;
        for (SkillButton button : this.skillButtons.values()) {
            double skillSize = (float)button.skill.getButtonSize() * this.zoom;
            double skillX = (double)button.x + (double)button.m_5711_() / 2.0 - skillSize / 2.0;
            double skillY = (double)button.y + (double)button.m_93694_() / 2.0 - skillSize / 2.0;
            if (!(mouseX >= skillX) || !(mouseY >= skillY) || !(mouseX < skillX + skillSize) || !(mouseY < skillY + skillSize)) continue;
            return button;
        }
        return null;
    }

    private void addSkillButtons() {
        this.skillButtons.clear();
        this.getTreeSkills().forEach(this::addSkillButton);
    }

    private void addToolButtons() {
        if (this.selectedSkills.isEmpty()) {
            return;
        }
        this.toolsX = this.f_96543_ - 210;
        this.toolsY = 10;
        switch (this.selectedTools) {
            case MAIN: {
                this.addMainTools();
                break;
            }
            case TEXTURES: {
                this.addTexturesTools();
                break;
            }
            case BUTTON: {
                this.addButtonTools();
                break;
            }
            case BONUSES: {
                this.addBonusesTools();
                break;
            }
            case NODE: {
                this.addNodeToolsButtons();
                break;
            }
            case TAGS: {
                this.addTagsToolsButtons();
                break;
            }
            case DESCRIPTION: {
                this.addDescriptionsToolsButtons();
                break;
            }
            case CONNECTIONS: {
                this.addConnectionToolsButton();
            }
        }
        this.toolsY += 5;
    }

    private void addBonusesTools() {
        Button backButton = this.addButton(0, 0, 90, 14, "Back");
        if (this.selectedSubMenu == -1) {
            backButton.setPressFunc(b -> this.selectTools(Tools.MAIN));
        } else {
            backButton.setPressFunc(b -> this.selectSubMenu(-1));
            this.addConfirmationButton(110, 0, 90, 14, "Remove", "Confirm").setPressFunc(b -> {
                this.selectedSkills().forEach(s -> SkillTreeEditorScreen.removeSkillBonus(s, this.selectedSubMenu));
                this.selectSubMenu(-1);
                this.saveSelectedSkills();
                this.m_232761_();
            });
        }
        this.shiftWidgets(0, 29);
        PassiveSkill skill = this.getFirstSelectedSkill();
        if (this.selectedSkills().anyMatch(otherSkill -> !this.sameBonuses(skill, (PassiveSkill)otherSkill))) {
            return;
        }
        List<SkillBonus<?>> bonuses = skill.getBonuses();
        if (this.selectedSubMenu >= bonuses.size()) {
            this.selectedSubMenu = -1;
        }
        if (this.selectedSubMenu == -1) {
            for (int i = 0; i < bonuses.size(); ++i) {
                int index = i;
                SkillBonus<?> bonus = bonuses.get(i);
                String message = bonus.getTooltip().getString();
                message = TooltipHelper.getTrimmedMessage(this.f_96547_, message, 190);
                this.addButton(0, 0, 200, 14, message).setPressFunc(b -> this.selectSubMenu(index));
                this.shiftWidgets(0, 19);
            }
        } else {
            skill.getBonuses().get(this.selectedSubMenu).addEditorWidgets(this, this.selectedSubMenu, b -> {
                this.selectedSkills().forEach(s -> s.getBonuses().set(this.selectedSubMenu, b.copy()));
                this.saveSelectedSkills();
            });
        }
        if (this.selectedSubMenu == -1) {
            this.shiftWidgets(0, 10);
            this.addLabel(0, 0, "Add Bonus", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            SkillBonus<?> defaultBonusType = ((SkillBonus.Serializer)PSTSkillBonuses.ATTRIBUTE.get()).createDefaultInstance();
            DropDownList<SkillBonus> bonusTypeSelection = this.addDropDownList(0, 0, 200, 14, 10, defaultBonusType, PSTSkillBonuses.bonusList()).setToNameFunc(b -> Component.m_237113_((String)PSTSkillBonuses.getName(b)));
            this.shiftWidgets(0, 19);
            this.addButton(0, 0, 90, 14, "Add").setPressFunc(b -> {
                this.selectedSkills().forEach(s -> s.getBonuses().add(((SkillBonus)bonusTypeSelection.getValue()).copy()));
                this.m_232761_();
                this.saveSelectedSkills();
            });
            this.shiftWidgets(0, 19);
        }
    }

    private void selectSubMenu(int index) {
        this.selectedSubMenu = index;
        this.m_232761_();
    }

    private void addMainTools() {
        this.addButton(0, 0, 200, 14, "Bonuses").setPressFunc(b -> this.selectTools(Tools.BONUSES));
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 200, 14, "Textures").setPressFunc(b -> this.selectTools(Tools.TEXTURES));
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 200, 14, "Button").setPressFunc(b -> this.selectTools(Tools.BUTTON));
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 200, 14, "New Skill").setPressFunc(b -> this.selectTools(Tools.NODE));
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 200, 14, "Tags").setPressFunc(b -> this.selectTools(Tools.TAGS));
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 200, 14, "Description").setPressFunc(b -> this.selectTools(Tools.DESCRIPTION));
        this.shiftWidgets(0, 19);
        if (this.selectedSkills.size() >= 2) {
            this.addButton(0, 0, 200, 14, "Connections").setPressFunc(b -> this.selectTools(Tools.CONNECTIONS));
            this.shiftWidgets(0, 19);
        }
        this.addConfirmationButton(0, 0, 200, 14, "Remove", "Confirm").setPressFunc(b -> this.removeSelectedSkills());
        this.shiftWidgets(0, 19);
    }

    private void selectTools(Tools tools) {
        this.selectedTools = tools;
        this.m_232761_();
    }

    private void addNodeToolsButtons() {
        this.addButton(0, 0, 90, 14, "Back").setPressFunc(b -> this.selectTools(Tools.MAIN));
        this.shiftWidgets(0, 29);
        if (this.selectedSkills.isEmpty()) {
            return;
        }
        this.addLabel(0, 0, "Distance", ChatFormatting.GOLD);
        this.addLabel(65, 0, "Angle", ChatFormatting.GOLD);
        this.shiftWidgets(0, 19);
        NumericTextField distanceEditor = this.addNumericTextField(0, 0, 60, 14, this.lastUsedDistance);
        distanceEditor.setNumericResponder(v -> {
            this.lastUsedDistance = v;
        });
        NumericTextField angleEditor = this.addNumericTextField(65, 0, 60, 14, this.lastUsedAngle);
        angleEditor.setNumericResponder(v -> {
            this.lastUsedAngle = v;
        });
        this.shiftWidgets(0, 19);
        this.addButton(0, 0, 60, 14, "Add").setPressFunc(b -> this.createSkills(angleEditor, distanceEditor, (TriConsumer<Float, Float, PassiveSkill>)((TriConsumer)this::createNewSkill)));
        this.addButton(65, 0, 60, 14, "Copy").setPressFunc(b -> this.createSkills(angleEditor, distanceEditor, (TriConsumer<Float, Float, PassiveSkill>)((TriConsumer)this::createCopiedSkill)));
        this.shiftWidgets(0, 19);
        this.addLabel(0, 0, "Mirror", ChatFormatting.GOLD);
        this.addCheckBox(186, 0, this.mirroring).setResponder(v -> {
            this.mirroring = v;
            this.m_232761_();
        });
        this.shiftWidgets(0, 19);
        if (this.mirroring) {
            this.addLabel(0, 0, "Sides", ChatFormatting.GOLD);
            this.addNumericTextField(160, 0, 40, 14, this.mirrorSides).setNumericFilter(v -> v > 1.0).setNumericResponder(v -> {
                this.mirrorSides = v.intValue();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Rotation", ChatFormatting.GOLD);
            this.addNumericTextField(160, 0, 40, 14, this.mirrorAngle).setNumericResponder(v -> {
                this.mirrorAngle = v.floatValue();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Center", ChatFormatting.GOLD);
            this.addNumericTextField(160, 0, 40, 14, this.mirrorCenterX).setNumericResponder(v -> {
                this.mirrorCenterX = v.floatValue();
            });
            this.addNumericTextField(115, 0, 40, 14, this.mirrorCenterY).setNumericResponder(v -> {
                this.mirrorCenterY = v.floatValue();
            });
            if (this.selectedSkills.size() == 1) {
                this.addButton(70, 0, 40, 14, "Set").setPressFunc(b -> {
                    PassiveSkill skill = this.getFirstSelectedSkill();
                    this.mirrorCenterX = skill.getPositionX();
                    this.mirrorCenterY = skill.getPositionY();
                    this.m_232761_();
                });
                this.shiftWidgets(0, 19);
            }
        }
    }

    private void addTagsToolsButtons() {
        Button backButton = this.addButton(0, 0, 90, 14, "Back");
        this.shiftWidgets(0, 29);
        if (this.selectedSubMenu == -1) {
            backButton.setPressFunc(b -> this.selectTools(Tools.MAIN));
            if (this.selectedSkills.isEmpty()) {
                return;
            }
            PassiveSkill skill = this.getFirstSelectedSkill();
            if (this.selectedSkills().anyMatch(otherSkill -> !this.sameTags(skill, (PassiveSkill)otherSkill))) {
                return;
            }
            this.addLabel(0, 0, "Tag List", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            List<String> tags = skill.getTags();
            for (int i = 0; i < tags.size(); ++i) {
                int index = i;
                this.addTextField(0, 0, 200, 14, tags.get(i)).m_94151_(v -> {
                    this.selectedSkills().forEach(s -> s.getTags().set(index, (String)v));
                    this.saveSelectedSkills();
                });
                this.shiftWidgets(0, 19);
            }
            this.toolsY += 10;
            this.addButton(0, 0, 90, 14, "Add").setPressFunc(b -> {
                Object name = "New Tag";
                while (skill.getTags().contains(name)) {
                    name = (String)name + "1";
                }
                String finalName = name;
                this.selectedSkills().forEach(s -> s.getTags().add(finalName));
                this.saveSelectedSkills();
                this.m_232761_();
            });
            if (!tags.isEmpty()) {
                this.addButton(110, 0, 90, 14, "Remove").setPressFunc(b -> {
                    this.selectedSkills().forEach(s -> s.getTags().remove(tags.size() - 1));
                    this.saveSelectedSkills();
                    this.m_232761_();
                });
            }
            this.shiftWidgets(0, 19);
            this.addButton(0, 0, 200, 14, "Tree Limitations").setPressFunc(b -> this.selectSubMenu(0));
            this.shiftWidgets(0, 19);
        } else {
            backButton.setPressFunc(b -> this.selectSubMenu(-1));
            Map<String, Integer> limitations = this.skillTree.getSkillLimitations();
            List tags = limitations.keySet().stream().toList();
            ArrayList<Pair> editors = new ArrayList<Pair>();
            Runnable saveFunc = () -> {
                limitations.clear();
                for (Pair pair : editors) {
                    int limit = (int)((NumericTextField)((Object)((Object)pair.getValue()))).getNumericValue();
                    if (limit == 0) continue;
                    String tag = ((TextField)((Object)((Object)pair.getKey()))).m_94155_();
                    limitations.put(tag, limit);
                }
                SkillTreeClientData.saveEditorSkillTree(this.skillTree);
            };
            for (int i = 0; i < limitations.size(); ++i) {
                TextField tagEditor = this.addTextField(0, 0, 155, 14, (String)tags.get(i));
                NumericTextField limitEditor = this.addNumericTextField(160, 0, 40, 14, limitations.get(tags.get(i)).intValue());
                tagEditor.m_94151_(v -> saveFunc.run());
                editors.add(Pair.of((Object)((Object)tagEditor), (Object)((Object)limitEditor)));
                limitEditor.setNumericFilter(d -> d >= 0.0).setNumericResponder(v -> {
                    saveFunc.run();
                    if (v == 0.0) {
                        this.m_232761_();
                    }
                });
                this.shiftWidgets(0, 19);
            }
            this.shiftWidgets(0, 10);
            this.addButton(0, 0, 90, 14, "Add").setPressFunc(b -> {
                Object name = "New Tag";
                while (limitations.containsKey(name)) {
                    name = (String)name + "1";
                }
                limitations.put((String)name, 1);
                this.m_232761_();
                SkillTreeClientData.saveEditorSkillTree(this.skillTree);
            });
            this.shiftWidgets(0, 19);
        }
    }

    private void addDescriptionsToolsButtons() {
        Button backButton = this.addButton(0, 0, 90, 14, "Back");
        if (this.selectedSkills.isEmpty()) {
            return;
        }
        PassiveSkill skill = this.getFirstSelectedSkill();
        if (this.selectedSkills().anyMatch(otherSkill -> !this.sameDescription(skill, (PassiveSkill)otherSkill))) {
            return;
        }
        List<MutableComponent> description = skill.getDescription();
        if (this.selectedSubMenu == -1) {
            backButton.setPressFunc(b -> this.selectTools(Tools.MAIN));
            this.addConfirmationButton(110, 0, 90, 14, "Regenerate", "Confirm").setPressFunc(b -> this.regenerateSelectedSkillsDescription());
            this.shiftWidgets(0, 29);
            if (description != null) {
                for (int i = 0; i < description.size(); ++i) {
                    int index = i;
                    String message = description.get(i).getString();
                    message = TooltipHelper.getTrimmedMessage(this.f_96547_, message, 190);
                    this.addButton(0, 0, 200, 14, message).setPressFunc(b -> this.selectSubMenu(index));
                    this.shiftWidgets(0, 19);
                }
            }
            this.shiftWidgets(0, 10);
            this.addButton(0, 0, 90, 14, "Add").setPressFunc(b -> this.addSelectedSkillsDescriptionLine());
            this.addConfirmationButton(110, 0, 90, 14, "Clear", "Confirm").setPressFunc(b -> this.removeSelectedSkillsDescription());
            this.shiftWidgets(0, 19);
        } else {
            backButton.setPressFunc(b -> this.selectSubMenu(-1));
            this.addConfirmationButton(110, 0, 90, 14, "Remove", "Confirm").setPressFunc(b -> this.removeSelectedSkillsDescriptionLine());
            this.shiftWidgets(0, 29);
            if (description == null || this.selectedSubMenu > description.size()) {
                this.selectSubMenu(-1);
                return;
            }
            MutableComponent component = description.get(this.selectedSubMenu);
            this.addTextArea(0, 0, 200, 70, component.getString()).setResponder(this::setSelectedSkillsDescription);
            this.shiftWidgets(0, 75);
            this.addLabel(0, 0, "Color", ChatFormatting.GOLD);
            Style style = component.m_7383_();
            TextColor textColor = style.m_131135_();
            if (textColor == null) {
                textColor = TextColor.m_131266_((int)0xFFFFFF);
            }
            String color = Integer.toHexString(textColor.m_131265_());
            this.addTextField(120, 0, 80, 14, color).setSoftFilter(v -> v.matches("^#?[a-fA-F0-9]{6}")).m_94151_(v -> {
                int rgb = Integer.parseInt(SkillTreeEditorScreen.formatColor(v), 16);
                this.setSelectedSkillsDescriptionStyle(s -> s.m_178520_(rgb));
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Bold", ChatFormatting.GOLD);
            this.addCheckBox(186, 0, style.m_131154_()).setResponder(v -> {
                this.setSelectedSkillsDescriptionStyle(s -> s.m_131136_(v));
                this.m_232761_();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Italic", ChatFormatting.GOLD);
            this.addCheckBox(186, 0, style.m_131161_()).setResponder(v -> {
                this.setSelectedSkillsDescriptionStyle(s -> s.m_131155_(v));
                this.m_232761_();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Underline", ChatFormatting.GOLD);
            this.addCheckBox(186, 0, style.m_131171_()).setResponder(v -> {
                this.setSelectedSkillsDescriptionStyle(s -> s.m_131162_(v));
                this.m_232761_();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Strikethrough", ChatFormatting.GOLD);
            this.addCheckBox(186, 0, style.m_131168_()).setResponder(v -> {
                this.setSelectedSkillsDescriptionStyle(s -> s.m_178522_(v));
                this.m_232761_();
            });
            this.shiftWidgets(0, 19);
            this.addLabel(0, 0, "Obfuscated", ChatFormatting.GOLD);
            this.addCheckBox(186, 0, style.m_131176_()).setResponder(v -> {
                this.setSelectedSkillsDescriptionStyle(s -> s.m_178524_(v));
                this.m_232761_();
            });
            this.shiftWidgets(0, 19);
        }
    }

    private void createSkills(NumericTextField angleEditor, NumericTextField distanceEditor, TriConsumer<Float, Float, PassiveSkill> skillFactory) {
        float angle = (float)angleEditor.getNumericValue();
        float angleRadians = (float)Math.toRadians(angle);
        this.selectedSkills.forEach(skillId -> {
            PassiveSkill skill = SkillTreeClientData.getEditorSkill(skillId);
            float distance = (float)distanceEditor.getNumericValue();
            float skillX = skill.getPositionX() + Mth.m_14031_((float)angleRadians) * (distance += (float)skill.getButtonSize() / 2.0f + 8.0f);
            float skillY = skill.getPositionY() + Mth.m_14089_((float)angleRadians) * distance;
            skillFactory.accept((Object)Float.valueOf(skillX), (Object)Float.valueOf(skillY), (Object)skill);
        });
        if (this.mirroring) {
            float sectorSize = 360.0f / (float)this.mirrorSides;
            int i = 1;
            while (i < this.mirrorSides) {
                angle = this.mirrorSides == 2 ? -angle - this.mirrorAngle * 2.0f : angle - sectorSize;
                float finalAngle = (float)Math.toRadians(angle);
                int sector = i++;
                this.selectedSkills.forEach(skillId -> {
                    PassiveSkill skill = SkillTreeClientData.getEditorSkill(skillId);
                    if ((skill = this.getMirroredSkill(skill, sector)) == null) {
                        return;
                    }
                    float distance = (float)distanceEditor.getNumericValue();
                    float skillX = skill.getPositionX() + Mth.m_14031_((float)finalAngle) * (distance += (float)skill.getButtonSize() / 2.0f + 8.0f);
                    float skillY = skill.getPositionY() + Mth.m_14089_((float)finalAngle) * distance;
                    skillFactory.accept((Object)Float.valueOf(skillX), (Object)Float.valueOf(skillY), (Object)skill);
                });
            }
        }
        this.m_232761_();
    }

    @Nullable
    private PassiveSkill getMirroredSkill(PassiveSkill skill, int sector) {
        float skillX = skill.getPositionX();
        float skillY = skill.getPositionY();
        if (this.mirrorCenterX == skillX && this.mirrorCenterY == skillY) {
            return skill;
        }
        float originalAngle = (float)Math.toDegrees(Math.atan2(skillY - this.mirrorCenterY, skillX - this.mirrorCenterX)) + 90.0f;
        float sectorSize = 360.0f / (float)this.mirrorSides;
        float angle = (float)Math.toRadians(this.mirrorSides == 2 ? (double)(-originalAngle + this.mirrorAngle * 2.0f) : (double)(originalAngle + sectorSize * (float)sector));
        float distance = (float)Math.hypot(skillX - this.mirrorCenterX, skillY - this.mirrorCenterY);
        float mirroredSkillX = this.mirrorCenterX + Mth.m_14031_((float)angle) * distance;
        float mirroredSkillY = this.mirrorCenterY + Mth.m_14089_((float)((float)((double)angle + Math.PI))) * distance;
        return this.getSkillAtPosition(mirroredSkillX, mirroredSkillY);
    }

    @Nullable
    private PassiveSkill getSkillAtPosition(float x, float y) {
        for (PassiveSkill skill : this.getTreeSkills().toList()) {
            double distance = Math.hypot(x - skill.getPositionX(), y - skill.getPositionY());
            if (!(distance < (double)skill.getButtonSize())) continue;
            return skill;
        }
        return null;
    }

    private void createCopiedSkill(float x, float y, PassiveSkill original) {
        PassiveSkill skill = new PassiveSkill(this.createNewSkillId(), original.getButtonSize(), original.getBackgroundTexture(), original.getIconTexture(), original.getBorderTexture(), original.isStartingPoint());
        skill.setPosition(x, y);
        skill.setConnectedTree(original.getConnectedTreeId());
        skill.setStartingPoint(original.isStartingPoint());
        original.getBonuses().stream().map(SkillBonus::copy).forEach(skill::addSkillBonus);
        original.getTags().forEach(skill.getTags()::add);
        skill.setTitle(original.getTitle());
        skill.setTitleColor(original.getTitleColor());
        skill.setDescription(original.getDescription());
        skill.connect(original);
        SkillTreeClientData.saveEditorSkill(skill);
        SkillTreeClientData.loadEditorSkill(skill.getId());
        this.skillTree.getSkillIds().add(skill.getId());
        SkillTreeClientData.saveEditorSkillTree(this.skillTree);
    }

    private void createNewSkill(float x, float y, @Nullable PassiveSkill other) {
        ResourceLocation background = new ResourceLocation("skilltree", "textures/icons/background/lesser.png");
        ResourceLocation icon = new ResourceLocation("skilltree", "textures/icons/void.png");
        ResourceLocation border = new ResourceLocation("skilltree", "textures/tooltip/lesser.png");
        PassiveSkill skill = new PassiveSkill(this.createNewSkillId(), 16, background, icon, border, false);
        skill.setPosition(x, y);
        if (other != null) {
            skill.connect(other);
        }
        SkillTreeClientData.saveEditorSkill(skill);
        SkillTreeClientData.loadEditorSkill(skill.getId());
        this.skillTree.getSkillIds().add(skill.getId());
        SkillTreeClientData.saveEditorSkillTree(this.skillTree);
    }

    private ResourceLocation createNewSkillId() {
        ResourceLocation id;
        int counter = 1;
        while (SkillTreeClientData.getEditorSkill(id = new ResourceLocation("skilltree", "new_skill_" + counter++)) != null) {
        }
        return id;
    }

    private void addButtonTools() {
        boolean canEditTitleColor;
        this.addButton(0, 0, 90, 14, "Back").setPressFunc(b -> this.selectTools(Tools.MAIN));
        this.shiftWidgets(0, 29);
        PassiveSkill firstSelectedSkill = this.getFirstSelectedSkill();
        if (this.canEdit(PassiveSkill::getButtonSize)) {
            this.addLabel(0, 0, "Size", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addNumericTextField(0, 0, 40, 14, firstSelectedSkill.getButtonSize()).setNumericFilter(d -> d >= 2.0).setNumericResponder(this::setSelectedSkillsSize);
            this.shiftWidgets(0, 19);
        }
        if (this.selectedSkills.size() == 1) {
            this.toolsY -= 38;
            this.addLabel(65, 0, "Position", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addNumericTextField(65, 0, 60, 14, firstSelectedSkill.getPositionX()).setNumericResponder(v -> this.setSkillPosition(this.getFirstSelectedSkill(), v.floatValue(), firstSelectedSkill.getPositionY()));
            this.addNumericTextField(130, 0, 60, 14, firstSelectedSkill.getPositionY()).setNumericResponder(v -> this.setSkillPosition(this.getFirstSelectedSkill(), firstSelectedSkill.getPositionX(), v.floatValue()));
            this.shiftWidgets(0, 19);
        }
        if (this.canEdit(PassiveSkill::getTitle)) {
            this.addLabel(0, 0, "Title", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addTextField(0, 0, 200, 14, firstSelectedSkill.getTitle()).m_94151_(this::setSelectedSkillsTitle);
            this.shiftWidgets(0, 19);
        }
        if (canEditTitleColor = this.canEdit(PassiveSkill::getTitleColor)) {
            this.addLabel(0, 0, "Title Color", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addTextField(0, 0, 80, 14, firstSelectedSkill.getTitleColor()).setSoftFilter(v -> v.matches("^#?[a-fA-F0-9]{6}") || v.isEmpty()).m_94151_(this::setSelectedSkillsTitleColor);
            this.shiftWidgets(0, 19);
        }
        if (this.canEdit(PassiveSkill::isStartingPoint)) {
            if (canEditTitleColor) {
                this.shiftWidgets(100, -38);
            }
            this.addLabel(0, 0, "Starting Point", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addCheckBox(0, 0, firstSelectedSkill.isStartingPoint()).setResponder(v -> {
                this.selectedSkills().forEach(s -> s.setStartingPoint((boolean)v));
                this.saveSelectedSkills();
            });
            if (canEditTitleColor) {
                this.shiftWidgets(-100, 0);
            }
            this.shiftWidgets(0, 19);
        }
    }

    private void setSelectedSkillsSize(double size) {
        this.selectedSkills().forEach(skill -> {
            skill.setButtonSize((int)size);
            this.reAddSkillButton((PassiveSkill)skill);
        });
        this.addSkillConnections();
        this.saveSelectedSkills();
    }

    private void setSkillPosition(PassiveSkill skill, float x, float y) {
        skill.setPosition(x, y);
        this.reAddSkillButton(skill);
        this.addSkillConnections();
        this.saveSelectedSkills();
    }

    private void moveSelectedSkills(float x, float y) {
        this.selectedSkills.forEach(skillId -> {
            PassiveSkill skill = SkillTreeClientData.getEditorSkill(skillId);
            skill.setPosition(skill.getPositionX() + x, skill.getPositionY() + y);
            this.reAddSkillButton(skill);
        });
        this.addSkillConnections();
        this.saveSelectedSkills();
    }

    private PassiveSkill getFirstSelectedSkill() {
        ResourceLocation skillId = (ResourceLocation)this.selectedSkills.toArray()[0];
        return SkillTreeClientData.getEditorSkill(skillId);
    }

    private void setSelectedSkillsTitle(String title) {
        this.selectedSkills().forEach(skill -> skill.setTitle(title));
        this.saveSelectedSkills();
    }

    private void setSelectedSkillsTitleColor(String color) {
        String finalColor = SkillTreeEditorScreen.formatColor(color);
        this.selectedSkills().forEach(skill -> skill.setTitleColor(finalColor));
        this.saveSelectedSkills();
    }

    @NotNull
    private static String formatColor(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        return color;
    }

    private void setSelectedSkillsDescription(String line) {
        this.selectedSkills().forEach(skill -> {
            List<MutableComponent> description = skill.getDescription();
            Objects.requireNonNull(description);
            MutableComponent component = description.get(this.selectedSubMenu);
            Style style = component.m_7383_();
            description.set(this.selectedSubMenu, Component.m_237113_((String)line).m_130948_(style));
        });
        this.saveSelectedSkills();
    }

    private void setSelectedSkillsDescriptionStyle(Function<Style, Style> styleFunc) {
        this.selectedSkills().forEach(skill -> {
            List<MutableComponent> description = skill.getDescription();
            Objects.requireNonNull(description);
            MutableComponent component = description.get(this.selectedSubMenu);
            Style style = (Style)styleFunc.apply(component.m_7383_());
            description.set(this.selectedSubMenu, component.m_130948_(style));
            SkillTreeClientData.saveEditorSkill(skill);
            SkillTreeClientData.loadEditorSkill(skill.getId());
        });
    }

    private void regenerateSelectedSkillsDescription() {
        this.selectedSkills().forEach(skill -> skill.setDescription(null));
        this.saveSelectedSkills();
        this.selectedSkills().forEach(skill -> {
            ArrayList<MutableComponent> description = new ArrayList<MutableComponent>();
            this.skillButtons.get(skill.getId()).addSkillBonusTooltip(description);
            skill.setDescription(description);
        });
        this.m_232761_();
    }

    private void removeSelectedSkillsDescriptionLine() {
        this.selectedSkills().forEach(skill -> {
            List<MutableComponent> description = skill.getDescription();
            Objects.requireNonNull(description);
            description.remove(this.selectedSubMenu);
        });
        this.saveSelectedSkills();
        this.selectSubMenu(-1);
        this.m_232761_();
    }

    private void removeSelectedSkillsDescription() {
        this.selectedSkills().forEach(skill -> skill.setDescription(null));
        this.saveSelectedSkills();
        this.m_232761_();
    }

    private void addSelectedSkillsDescriptionLine() {
        this.selectedSkills().forEach(skill -> {
            List<MutableComponent> description = skill.getDescription();
            if (description == null) {
                description = new ArrayList<MutableComponent>();
                skill.setDescription(description);
            }
            description.add(Component.m_237119_().m_130948_(TooltipHelper.getSkillBonusStyle(true)));
        });
        this.saveSelectedSkills();
        this.m_232761_();
    }

    private void addTexturesTools() {
        this.addButton(0, 0, 90, 14, "Back").setPressFunc(b -> this.selectTools(Tools.MAIN));
        this.shiftWidgets(0, 29);
        PassiveSkill skill = this.getFirstSelectedSkill();
        if (this.canEdit(PassiveSkill::getBackgroundTexture)) {
            this.addLabel(0, 0, "Border", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addDropDownList(0, 0, 200, 14, 10, skill.getBackgroundTexture(), SkillTexturesData.BORDERS).setToNameFunc(TooltipHelper::getTextureName).setResponder(value -> {
                this.selectedSkills().forEach(s -> s.setBackgroundTexture((ResourceLocation)value));
                this.saveSelectedSkills();
            });
            this.shiftWidgets(0, 19);
        }
        if (this.canEdit(PassiveSkill::getBorderTexture)) {
            this.addLabel(0, 0, "Tooltip", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addDropDownList(0, 0, 200, 14, 10, skill.getBorderTexture(), SkillTexturesData.TOOLTIP_BACKGROUNDS).setToNameFunc(TooltipHelper::getTextureName).setResponder(value -> {
                this.selectedSkills().forEach(s -> s.setBorderTexture((ResourceLocation)value));
                this.saveSelectedSkills();
            });
            this.shiftWidgets(0, 19);
        }
        if (this.canEdit(PassiveSkill::getIconTexture)) {
            this.addLabel(0, 0, "Icon", ChatFormatting.GOLD);
            this.shiftWidgets(0, 19);
            this.addDropDownList(0, 0, 200, 14, 10, skill.getIconTexture(), SkillTexturesData.ICONS).setToNameFunc(TooltipHelper::getTextureName).setResponder(value -> {
                this.selectedSkills().forEach(s -> s.setIconTexture((ResourceLocation)value));
                this.saveSelectedSkills();
            });
            this.shiftWidgets(0, 19);
        }
    }

    private void addConnectionToolsButton() {
        this.addButton(0, 0, 90, 14, "Back").setPressFunc(b -> this.selectTools(Tools.MAIN));
        this.shiftWidgets(0, 29);
        if (this.selectedSkills.size() < 2) {
            return;
        }
        if (this.selectedSkillsConnected()) {
            Button disconnectButton = new Button(this.toolsX, this.toolsY, 100, 14, (Component)Component.m_237113_((String)"Disconnect"));
            this.m_142416_((GuiEventListener)disconnectButton);
            disconnectButton.setPressFunc(b -> this.disconnectSelectedSkills());
        } else {
            this.addLabel(0, 0, "Connect", new ChatFormatting[0]);
            this.shiftWidgets(0, 19);
            this.addButton(0, 0, 100, 14, "Direct").setPressFunc(b -> this.connectSelectedSkills(SkillConnection.Type.DIRECT));
            this.shiftWidgets(0, 19);
            this.addButton(0, 0, 100, 14, "Long").setPressFunc(b -> this.connectSelectedSkills(SkillConnection.Type.LONG));
            this.shiftWidgets(0, 19);
            this.addButton(0, 0, 100, 14, "One Way").setPressFunc(b -> this.connectSelectedSkills(SkillConnection.Type.ONE_WAY));
        }
        this.shiftWidgets(0, 19);
    }

    private void connectSelectedSkills(SkillConnection.Type connectionType) {
        ResourceLocation[] selectedSkillsArray = this.selectedSkills.toArray(new ResourceLocation[0]);
        for (int i = 0; i < this.selectedSkills.size() - 1; ++i) {
            PassiveSkill skill = SkillTreeClientData.getEditorSkill(selectedSkillsArray[i]);
            List<ResourceLocation> connections = switch (connectionType) {
                default -> throw new IncompatibleClassChangeError();
                case SkillConnection.Type.DIRECT -> skill.getDirectConnections();
                case SkillConnection.Type.LONG -> skill.getLongConnections();
                case SkillConnection.Type.ONE_WAY -> skill.getOneWayConnections();
            };
            connections.add(selectedSkillsArray[i + 1]);
        }
        this.saveSelectedSkills();
        this.m_232761_();
    }

    private void disconnectSelectedSkills() {
        ResourceLocation[] selectedSkillsArray = this.selectedSkills.toArray(new ResourceLocation[0]);
        for (int i = 0; i < this.selectedSkills.size() - 1; ++i) {
            PassiveSkill skill1 = SkillTreeClientData.getEditorSkill(selectedSkillsArray[i]);
            PassiveSkill skill2 = SkillTreeClientData.getEditorSkill(selectedSkillsArray[i + 1]);
            skill1.getDirectConnections().remove(skill2.getId());
            skill2.getDirectConnections().remove(skill1.getId());
            skill1.getLongConnections().remove(skill2.getId());
            skill2.getLongConnections().remove(skill1.getId());
            skill1.getOneWayConnections().remove(skill2.getId());
            skill2.getOneWayConnections().remove(skill1.getId());
        }
        this.saveSelectedSkills();
        this.m_232761_();
    }

    private boolean selectedSkillsConnected() {
        ResourceLocation[] selectedSkillsArray = this.selectedSkills.toArray(new ResourceLocation[0]);
        for (int i = 0; i < this.selectedSkills.size() - 1; ++i) {
            PassiveSkill skill2;
            PassiveSkill skill1 = SkillTreeClientData.getEditorSkill(selectedSkillsArray[i]);
            if (this.skillsConnected(skill1, skill2 = SkillTreeClientData.getEditorSkill(selectedSkillsArray[i + 1]))) continue;
            return false;
        }
        return true;
    }

    private boolean skillsConnected(PassiveSkill first, PassiveSkill second) {
        return first.getDirectConnections().contains(second.getId()) || second.getDirectConnections().contains(first.getId()) || first.getLongConnections().contains(second.getId()) || second.getLongConnections().contains(first.getId()) || first.getOneWayConnections().contains(second.getId()) || second.getOneWayConnections().contains(first.getId());
    }

    private void saveSelectedSkills() {
        this.selectedSkills.stream().map(this.skillButtons::get).map(button -> button.skill).forEach(SkillTreeClientData::saveEditorSkill);
    }

    protected void addSkillButton(PassiveSkill skill) {
        SkillButton button = new SkillButton(() -> Float.valueOf(0.0f), this.getSkillButtonX(skill), this.getSkillButtonY(skill), skill);
        this.m_142416_((GuiEventListener)button);
        button.skillLearned = true;
        this.skillButtons.put(skill.getId(), button);
        float skillX = skill.getPositionX();
        float skillY = skill.getPositionY();
        if ((float)this.maxScrollX < Mth.m_14154_((float)skillX)) {
            this.maxScrollX = (int)Mth.m_14154_((float)skillX);
        }
        if ((float)this.maxScrollY < Mth.m_14154_((float)skillY)) {
            this.maxScrollY = (int)Mth.m_14154_((float)skillY);
        }
    }

    protected void reAddSkillButton(PassiveSkill skill) {
        this.m_6702_().removeIf(w -> {
            if (!(w instanceof SkillButton)) return false;
            SkillButton b = (SkillButton)((Object)w);
            if (b.skill != skill) return false;
            return true;
        });
        this.skillButtons.remove(skill.getId());
        this.addSkillButton(skill);
    }

    private float getSkillButtonX(PassiveSkill skill) {
        float skillX = skill.getPositionX();
        return skillX - (float)skill.getButtonSize() / 2.0f + (float)this.f_96543_ / 2.0f + skillX * (this.zoom - 1.0f);
    }

    private float getSkillButtonY(PassiveSkill skill) {
        float skillY = skill.getPositionY();
        return skillY - (float)skill.getButtonSize() / 2.0f + (float)this.f_96544_ / 2.0f + skillY * (this.zoom - 1.0f);
    }

    public void addSkillConnections() {
        this.skillConnections.clear();
        this.getTreeSkills().forEach(this::addSkillConnections);
    }

    private Stream<PassiveSkill> getTreeSkills() {
        return this.skillTree.getSkillIds().stream().map(SkillTreeClientData::getEditorSkill);
    }

    private void addSkillConnections(PassiveSkill skill) {
        this.readSkillConnections(skill, SkillConnection.Type.DIRECT, skill.getDirectConnections());
        this.readSkillConnections(skill, SkillConnection.Type.LONG, skill.getLongConnections());
        this.readSkillConnections(skill, SkillConnection.Type.ONE_WAY, skill.getOneWayConnections());
    }

    private void readSkillConnections(PassiveSkill skill, SkillConnection.Type type, List<ResourceLocation> connections) {
        for (ResourceLocation connectedSkillId : new ArrayList<ResourceLocation>(connections)) {
            if (SkillTreeClientData.getEditorSkill(connectedSkillId) == null) {
                connections.remove(connectedSkillId);
                SkillTreeClientData.saveEditorSkill(skill);
                continue;
            }
            this.connectSkills(type, skill.getId(), connectedSkillId);
        }
    }

    protected void connectSkills(SkillConnection.Type type, ResourceLocation skillId1, ResourceLocation skillId2) {
        SkillButton button1 = this.skillButtons.get(skillId1);
        SkillButton button2 = this.skillButtons.get(skillId2);
        this.skillConnections.add(new SkillConnection(type, button1, button2));
    }

    protected void skillButtonPressed(SkillButton button) {
        ResourceLocation skillId;
        if (SkillTreeEditorScreen.m_96637_()) {
            return;
        }
        if (!SkillTreeEditorScreen.m_96638_() && !this.selectedSkills.isEmpty()) {
            this.selectedSkills.clear();
        }
        if (this.selectedSkills.contains(skillId = button.skill.getId())) {
            this.selectedSkills.remove(skillId);
        } else {
            this.selectedSkills.add(skillId);
        }
        this.m_232761_();
    }

    public void m_86600_() {
        this.textFields().forEach(widget -> {
            if (widget instanceof EditBox) {
                EditBox editBox = (EditBox)widget;
                editBox.m_94120_();
            }
            if (widget instanceof MultiLineEditBox) {
                MultiLineEditBox multiLineEditBox = (MultiLineEditBox)widget;
                multiLineEditBox.m_239213_();
            }
        });
        this.dropDownLists().forEach(DropDownList::tick);
    }

    private void updateScroll(float partialTick) {
        this.scrollX += this.scrollSpeedX * partialTick;
        this.scrollX = Math.max((float)(-this.maxScrollX) * this.zoom, Math.min((float)this.maxScrollX * this.zoom, this.scrollX));
        this.scrollSpeedX *= 0.8f;
        this.scrollY += this.scrollSpeedY * partialTick;
        this.scrollY = Math.max((float)(-this.maxScrollY) * this.zoom, Math.min((float)this.maxScrollY * this.zoom, this.scrollY));
        this.scrollSpeedY *= 0.8f;
    }

    private void renderOverlay(GuiGraphics graphics) {
        ResourceLocation texture = new ResourceLocation("skilltree:textures/screen/skill_tree_overlay.png");
        RenderSystem.enableBlend();
        graphics.m_280398_(texture, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
    }

    public void m_280273_(GuiGraphics graphics) {
        ResourceLocation texture = new ResourceLocation("skilltree:textures/screen/skill_tree_background.png");
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(this.scrollX / 3.0f, this.scrollY / 3.0f, 0.0f);
        int size = 2048;
        graphics.m_280398_(texture, (this.f_96543_ - size) / 2, (this.f_96544_ - size) / 2, 0, 0.0f, 0.0f, size, size, size, size);
        graphics.m_280168_().m_85849_();
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragAmountX, double dragAmountY) {
        if (mouseButton != 0 && mouseButton != 2) {
            return false;
        }
        if (mouseButton == 0 && SkillTreeEditorScreen.m_96638_()) {
            this.selectingArea = true;
            return true;
        }
        if (mouseButton == 0 && SkillTreeEditorScreen.m_96637_() && !this.selectedSkills.isEmpty()) {
            this.moveSelectedSkills((float)dragAmountX / this.zoom, (float)dragAmountY / this.zoom);
            return true;
        }
        if (this.maxScrollX > 0) {
            this.scrollSpeedX += (float)(dragAmountX * 0.25);
        }
        if (this.maxScrollY > 0) {
            this.scrollSpeedY += (float)(dragAmountY * 0.25);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.widgets().anyMatch(w -> w.m_6050_(mouseX, mouseY, amount))) {
            return true;
        }
        if (amount > 0.0 && this.zoom < 2.0f) {
            this.zoom += 0.05f;
        }
        if (amount < 0.0 && this.zoom > 0.25f) {
            this.zoom -= 0.05f;
        }
        this.m_232761_();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public Stream<PassiveSkill> selectedSkills() {
        return this.selectedSkills.stream().map(SkillTreeClientData::getEditorSkill);
    }

    public void shiftWidgets(int x, int y) {
        this.toolsX += x;
        this.toolsY += y;
    }

    private static void removeSkillBonus(PassiveSkill skill, int index) {
        skill.getBonuses().remove(index);
        SkillTreeClientData.saveEditorSkill(skill);
    }

    public TextField addTextField(int x, int y, int width, int height, String defaultValue) {
        Objects.requireNonNull(this.f_96541_);
        return (TextField)this.m_142416_((GuiEventListener)new TextField(this.f_96541_.f_91062_, this.toolsX + x, this.toolsY + y, width, height, defaultValue));
    }

    public NumericTextField addNumericTextField(int x, int y, int width, int height, double defaultValue) {
        Objects.requireNonNull(this.f_96541_);
        return (NumericTextField)this.m_142416_((GuiEventListener)new NumericTextField(this.f_96541_.f_91062_, this.toolsX + x, this.toolsY + y, width, height, defaultValue));
    }

    public TextArea addTextArea(int x, int y, int width, int height, String defaultValue) {
        Objects.requireNonNull(this.f_96541_);
        return (TextArea)this.m_142416_((GuiEventListener)new TextArea(this.f_96541_.f_91062_, this.toolsX + x, this.toolsY + y, width, height, defaultValue));
    }

    public void m_232761_() {
        super.m_232761_();
    }

    public Label addLabel(int x, int y, String text, ChatFormatting ... styles) {
        MutableComponent message = Component.m_237113_((String)text);
        for (ChatFormatting style : styles) {
            message.m_130940_(style);
        }
        return (Label)this.m_169394_((Renderable)new Label(this.toolsX + x, this.toolsY + y, (Component)message));
    }

    public CheckBox addCheckBox(int x, int y, boolean value) {
        return (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.toolsX + x, this.toolsY + y, value));
    }

    public <T> DropDownList<T> addDropDownList(int x, int y, int width, int height, int maxDisplayed, T defaultValue, Collection<T> possibleValues) {
        return (DropDownList)this.m_142416_((GuiEventListener)new DropDownList<T>(this.toolsX + x, this.toolsY + y, width, height, maxDisplayed, possibleValues, defaultValue));
    }

    public <T extends Enum<T>> DropDownList<T> addDropDownList(int x, int y, int width, int height, int maxDisplayed, T defaultValue) {
        Class<?> enumClass = defaultValue.getClass();
        List<Enum> enums = Stream.of((Enum[])enumClass.getEnumConstants()).map(enumClass::cast).toList();
        return (DropDownList)this.m_142416_((GuiEventListener)new DropDownList<Enum>(this.toolsX + x, this.toolsY + y, width, height, maxDisplayed, enums, defaultValue));
    }

    public DropDownList<Attribute> addAttributePicker(int x, int y, int width, int height, int maxDisplayed, Attribute defaultValue) {
        return this.addDropDownList(x, y, width, height, maxDisplayed, defaultValue, SkillTreeEditorScreen.getEditableAttributes()).setToNameFunc(attribute -> {
            ResourceLocation id = ForgeRegistries.ATTRIBUTES.getKey(attribute);
            if (attribute instanceof SlotAttribute) {
                SlotAttribute slotAttribute = (SlotAttribute)attribute;
                id = new ResourceLocation("curios", slotAttribute.getIdentifier());
            }
            Objects.requireNonNull(id);
            return Component.m_237113_((String)id.toString());
        });
    }

    public Button addButton(int x, int y, int width, int height, String message) {
        return this.addButton(x, y, width, height, (Component)Component.m_237113_((String)message));
    }

    public Button addButton(int x, int y, int width, int height, Component message) {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.toolsX + x, this.toolsY + y, width, height, message));
    }

    public ConfirmationButton addConfirmationButton(int x, int y, int width, int height, String message, String confirmationMessage) {
        ConfirmationButton button = new ConfirmationButton(this.toolsX + x, this.toolsY + y, width, height, (Component)Component.m_237113_((String)message));
        button.setConfirmationMessage((Component)Component.m_237113_((String)confirmationMessage));
        return (ConfirmationButton)this.m_142416_((GuiEventListener)button);
    }

    @NotNull
    private static Collection<Attribute> getEditableAttributes() {
        if (EDITABLE_ATTRIBUTES.isEmpty()) {
            ForgeRegistries.ATTRIBUTES.getValues().stream().filter(arg_0 -> ((AttributeSupplier)((AttributeSupplier)ForgeHooks.getAttributesView().get(EntityType.f_20532_))).m_22258_(arg_0)).forEach(EDITABLE_ATTRIBUTES::add);
            CuriosApi.getSlots().keySet().stream().map(SlotAttribute::getOrCreate).forEach(EDITABLE_ATTRIBUTES::add);
        }
        return EDITABLE_ATTRIBUTES;
    }

    protected void renderConnections(GuiGraphics graphics, int mouseX, int mouseY) {
        this.skillConnections.stream().filter(c -> c.getType() == SkillConnection.Type.DIRECT).forEach(c -> this.renderDirectConnection(graphics, (SkillConnection)c));
        this.skillConnections.stream().filter(c -> c.getType() == SkillConnection.Type.LONG).forEach(c -> this.renderLongConnection(graphics, (SkillConnection)c, mouseX, mouseY));
        this.skillConnections.stream().filter(c -> c.getType() == SkillConnection.Type.ONE_WAY).forEach(c -> this.renderOneWayConnection(graphics, (SkillConnection)c));
    }

    private void renderDirectConnection(GuiGraphics graphics, SkillConnection c) {
        ScreenHelper.renderConnection(graphics, this.scrollX, this.scrollY, c, this.zoom, 0.0f);
    }

    private void renderLongConnection(GuiGraphics graphics, SkillConnection connection, int mouseX, int mouseY) {
        SkillButton hoveredSkill = this.getSkillAt(mouseX, mouseY);
        if (hoveredSkill != connection.getFirstButton() && hoveredSkill != connection.getSecondButton()) {
            return;
        }
        ScreenHelper.renderGatewayConnection(graphics, this.scrollX, this.scrollY, connection, true, this.zoom, 0.0f);
    }

    private void renderOneWayConnection(GuiGraphics graphics, SkillConnection connection) {
        ScreenHelper.renderOneWayConnection(graphics, this.scrollX, this.scrollY, connection, true, this.zoom, 0.0f);
    }

    protected boolean sameBonuses(PassiveSkill skill, PassiveSkill otherSkill) {
        if (skill == otherSkill) {
            return true;
        }
        List<SkillBonus<?>> modifiers = skill.getBonuses();
        List<SkillBonus<?>> otherModifiers = otherSkill.getBonuses();
        if (modifiers.size() != otherModifiers.size()) {
            return false;
        }
        for (int i = 0; i < modifiers.size(); ++i) {
            if (modifiers.get(i).sameBonus(otherModifiers.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean sameTags(PassiveSkill skill, PassiveSkill otherSkill) {
        if (skill == otherSkill) {
            return true;
        }
        List<String> tags = skill.getTags();
        List<String> otherTags = otherSkill.getTags();
        if (tags.size() != otherTags.size()) {
            return false;
        }
        for (int i = 0; i < tags.size(); ++i) {
            if (tags.get(i).equals(otherTags.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean sameDescription(PassiveSkill skill, PassiveSkill otherSkill) {
        if (skill == otherSkill) {
            return true;
        }
        List<MutableComponent> description = skill.getDescription();
        List<MutableComponent> otherDescription = otherSkill.getDescription();
        if (description == null && otherDescription == null) {
            return true;
        }
        if (description == null || otherDescription == null) {
            return false;
        }
        if (description.size() != otherDescription.size()) {
            return false;
        }
        for (int i = 0; i < description.size(); ++i) {
            if (description.get(i).equals((Object)otherDescription.get(i))) continue;
            return false;
        }
        return true;
    }

    protected final boolean canEdit(Function<PassiveSkill, ?> function) {
        return this.selectedSkills().map(function).distinct().count() <= 1L;
    }

    private static enum Tools {
        MAIN,
        BONUSES,
        TEXTURES,
        BUTTON,
        CONNECTIONS,
        TAGS,
        DESCRIPTION,
        NODE;

    }
}

