/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style.particle;

import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.particle.TooltipParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.RandomUtils;

public class EnderParticle
extends TooltipParticle {
    protected final int CENTER_COLOR;
    protected final int EDGE_COLOR;
    protected Vec2 start;

    public EnderParticle(int centerColor, int edgeColor, float lifetime, Vec2 center, float range) {
        super(lifetime);
        this.CENTER_COLOR = centerColor;
        this.EDGE_COLOR = edgeColor;
        this.position = center;
        float rot = RandomUtils.nextFloat((float)0.0f, (float)360.0f);
        this.start = center.m_165910_(new Vec2((float)Math.cos(rot) * range, (float)Math.sin(rot) * range));
    }

    @Override
    public void renderParticle(TooltipContext context, float lifetime) {
        float mod = 1.0f - (float)Math.pow(1.0f - lifetime / this.MAX_LIFETIME, 3.0);
        float scale = (mod < 0.4f ? (float)Math.pow(mod / 0.4f, 3.0) : (mod < 0.9f ? 1.0f - (float)Math.pow((mod - 0.4f) / 0.5f, 3.0) : 0.0f)) * 1.2f;
        context.push(() -> {
            context.translate(Mth.m_14179_((float)((float)Math.pow(mod, 4.0)), (float)this.start.f_82470_, (float)this.position.f_82470_), Mth.m_14179_((float)((float)Math.pow(mod, 4.0)), (float)this.start.f_82471_, (float)this.position.f_82471_), 0.0f);
            context.scale(scale, scale, scale);
            context.push(() -> {
                context.translate(-0.5f, 0.5f, 0.0f);
                context.fill(0, 0, 1, 1, this.CENTER_COLOR);
                context.fill(1, 1, 1, 1, this.EDGE_COLOR);
                context.fill(-1, -1, 1, 1, this.EDGE_COLOR);
                context.fill(-1, 1, 1, 1, this.EDGE_COLOR);
                context.fill(1, -1, 1, 1, this.EDGE_COLOR);
            });
        });
    }
}

