/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.util;

import com.google.common.base.Strings;
import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.NumUtil;
import eu.gflash.notifmod.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class ReminderTimer {
    private static final Map<UUID, ReminderTimer> active = Collections.synchronizedMap(new HashMap());
    private final UUID id = UUID.randomUUID();
    private final Timer timer = new Timer(true);
    private final int seconds;
    private final String name;
    private final boolean repeat;
    private long start = -1L;

    public ReminderTimer(int seconds, String name, boolean repeat) {
        this.seconds = seconds;
        this.name = name;
        this.repeat = repeat;
    }

    public ReminderTimer(int seconds, String name) {
        this(seconds, name, false);
    }

    public void start() {
        ModConfig.getInstance().reminder.msgTypeStart.msgWithPre(() -> TextUtil.getWithFormat((class_2561)(Strings.isNullOrEmpty((String)this.name) ? class_2561.method_43469((String)"msg.notifmod.reminder.start.long.unnamed", (Object[])new Object[]{TextUtil.getWithFormat(NumUtil.secToHMSString(this.seconds), class_124.field_1054)}) : class_2561.method_43469((String)"msg.notifmod.reminder.start.long.named", (Object[])new Object[]{TextUtil.getWithFormat(NumUtil.secToHMSString(this.seconds), class_124.field_1054), TextUtil.getWithFormat(this.name, class_124.field_1054)})), class_124.field_1075), () -> TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.reminder.start.short"), class_124.field_1075));
        if (this.seconds > 0) {
            active.put(this.id, this);
            this.start = this.getCurrSecs();
            long t = (long)this.seconds * 1000L;
            if (this.repeat) {
                this.timer.scheduleAtFixedRate((TimerTask)new Task(), t, t);
            } else {
                this.timer.schedule((TimerTask)new Task(), t);
            }
        } else {
            new Task().run();
        }
    }

    public static void startNew(int seconds, String name, boolean repeat) {
        new ReminderTimer(seconds, name, repeat).start();
    }

    public static void startNew(int seconds, String name) {
        ReminderTimer.startNew(seconds, name, false);
    }

    public void kill() {
        this.timer.cancel();
        active.remove(this.id);
    }

    public static void killAll() {
        List.copyOf(active.values()).forEach(ReminderTimer::kill);
    }

    public static Collection<ReminderTimer> getActive() {
        return active.values();
    }

    public String getName() {
        return this.name;
    }

    public int getRemaining() {
        return this.start < 0L ? -1 : (int)((long)this.seconds - (this.getCurrSecs() - this.start - 1L) % (long)this.seconds - 1L);
    }

    public boolean isActive() {
        return active.containsKey(this.id);
    }

    public boolean isRepeating() {
        return this.repeat;
    }

    public boolean hasName() {
        return !Strings.isNullOrEmpty((String)this.name);
    }

    private long getCurrSecs() {
        return Math.floorDiv(System.currentTimeMillis(), 1000);
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        @Override
        public void run() {
            ModConfig.Reminder settings = ModConfig.getInstance().reminder;
            settings.msgTypeDone.msgWithPre(() -> TextUtil.getWithFormat((class_2561)(Strings.isNullOrEmpty((String)ReminderTimer.this.name) ? class_2561.method_43471((String)"msg.notifmod.reminder.done.unnamed") : class_2561.method_43469((String)"msg.notifmod.reminder.done.named", (Object[])new Object[]{TextUtil.getWithFormat(ReminderTimer.this.name, class_124.field_1054)})), class_124.field_1060), () -> Strings.isNullOrEmpty((String)ReminderTimer.this.name) ? TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.reminder.done.unnamed"), class_124.field_1060) : TextUtil.getWithFormat(ReminderTimer.this.name, class_124.field_1060));
            settings.playSound();
            if (!ReminderTimer.this.repeat) {
                active.remove(ReminderTimer.this.id);
            }
        }
    }
}

