/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.util.wiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.robertx22.library_of_exile.command_wrapper.CommandBuilder;
import com.robertx22.library_of_exile.command_wrapper.PermWrapper;
import com.robertx22.library_of_exile.command_wrapper.PlayerWrapper;
import com.robertx22.library_of_exile.command_wrapper.RegistryTypeWrapper;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.util.wiki.iWikiEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class WikiEntryCommands {
    public static void init(CommandDispatcher dis) {
        CommandBuilder.of("library_of_exile", dis, x -> {
            PlayerWrapper PLAYER = new PlayerWrapper();
            RegistryTypeWrapper REG = new RegistryTypeWrapper();
            x.addLiteral("generate", PermWrapper.OP);
            x.addLiteral("wiki_entries", PermWrapper.OP);
            x.addArg(PLAYER);
            x.addArg(REG);
            x.action(e -> {
                Player en = (Player)PLAYER.get((CommandContext<CommandSourceStack>)e);
                ExileRegistryType reg = (ExileRegistryType)REG.get((CommandContext<CommandSourceStack>)e);
                ExileRegistryContainer db = Database.getRegistry(reg);
                Object text = "";
                for (ExileRegistry o : db.getList()) {
                    if (!(o instanceof iWikiEntry)) continue;
                    iWikiEntry wiki = (iWikiEntry)((Object)o);
                    if (!wiki.getWikiEntry().use) continue;
                    text = (String)text + " - '" + o.GUID() + "' - " + wiki.getWikiEntry().text + "\n";
                }
                en.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + ChatFormatting.BOLD + "Click Here to Copy Text.")).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, (String)text))));
            });
        }, "");
    }
}

