/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.tooltip;

import com.robertx22.library_of_exile.wrappers.ExileText;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ExileTooltipUtils {
    public static List<Component> removeBlankLines(List<Component> list, RemoveOption opt) {
        ArrayList<Component> newt = new ArrayList<Component>();
        boolean lastIsEmpty = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getString().isBlank()) {
                lastIsEmpty = false;
                newt.add(list.get(i));
                continue;
            }
            if (!lastIsEmpty && opt != RemoveOption.ALL_BLANK_LINES) {
                newt.add(list.get(i));
            }
            lastIsEmpty = true;
        }
        list.clear();
        list.addAll(newt);
        return newt;
    }

    public static List<Component> mutableToComp(List<MutableComponent> list) {
        return new ArrayList<MutableComponent>(list);
    }

    public static List<MutableComponent> splitLongText(MutableComponent comp) {
        String[] originalList;
        ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
        Style format = comp.m_7383_();
        for (String comp1 : originalList = comp.getString().split("\n")) {
            componentList.add(ExileText.ofText(comp1).get().m_130948_(format));
        }
        return componentList;
    }

    public static List<Component> splitLongText(List<? extends Component> comps) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : comps) {
            if (component.getString().contains("\n")) {
                String[] originalList;
                Style format = component.m_7383_();
                for (String comp1 : originalList = component.getString().split("\n")) {
                    arrayList.add((Component)Component.m_237113_((String)comp1).m_130948_(format));
                }
                continue;
            }
            arrayList.add(component);
        }
        return arrayList;
    }

    public static MutableComponent joinMutableComps(Iterator<? extends Component> iterator, MutableComponent separator) {
        if (separator == null) {
            separator = Component.m_237113_((String)"");
        }
        MutableComponent starter = Component.m_237113_((String)"");
        while (iterator.hasNext()) {
            starter.m_7220_(iterator.next());
            if (!iterator.hasNext()) continue;
            starter.m_7220_((Component)separator);
        }
        return starter;
    }

    public static enum RemoveOption {
        ONLY_DOUBLE_BLANK_LINES,
        ALL_BLANK_LINES;

    }
}

