/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.particles;

import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.particles.ParticlePacket;
import com.robertx22.library_of_exile.packets.particles.ParticlePacketData;
import com.robertx22.library_of_exile.utils.GeometryUtils;
import com.robertx22.library_of_exile.utils.RGB;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector3d;
import org.joml.Vector3f;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ParticleEnum {
    THORNS{

        @Override
        public void activate(ParticlePacketData data, Level world) {
            Vector3d center = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d p = GeometryUtils.randomPos(center, world.m_213780_(), data.radius);
                Vector3d m = GeometryUtils.randomMotion(center, world.f_46441_);
                world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50052_.m_49966_()), p.x, p.y, p.z, m.x, m.y, m.z);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123753_, p.x, p.y, p.z, m.x, m.y, m.z);
            }
        }
    }
    ,
    AOE{

        @Override
        public void activate(ParticlePacketData data, Level world) {
            Vector3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d r = GeometryUtils.getRandomPosInRadiusCircle(p.x, p.y, p.z, data.radius);
                world.m_7106_(data.getParticleType(), r.x, r.y, r.z, data.mx, data.my, data.mz);
            }
        }
    }
    ,
    CIRCLE_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, Level world) {
            Vector3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 60.0f) {
                Vector3d r = GeometryUtils.getRandomPosInRadiusCircle(p.x, p.y, p.z, data.radius);
                this.spawnRedstone(world, data.color, r.x, r.y, r.z);
                ++i;
            }
        }
    }
    ,
    NOVA_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, Level world) {
            Vector3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 50.0f) {
                Vector3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.x, p.y, p.z, data.radius);
                this.spawnRedstone(world, data.color, r.x, r.y, r.z);
                ++i;
            }
        }
    }
    ,
    NOVA{

        @Override
        public void activate(ParticlePacketData data, Level world) {
            Vector3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.x, p.y, p.z, data.radius);
                world.m_7106_(data.getParticleType(), r.x, r.y, r.z, 0.0, 0.0, 0.0);
            }
        }
    };


    public static void sendToClients(Entity source, ParticlePacketData data) {
        if (source.m_9236_().f_46443_) {
            try {
                data.type.activate(data, source.m_9236_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Packets.sendToTracking(new ParticlePacket(data), source);
        }
    }

    public static void sendToClients(BlockPos pos, Level world, ParticlePacketData data) {
        if (!world.f_46443_) {
            Packets.sendToTracking(new ParticlePacket(data), pos, world);
        } else {
            data.type.activate(data, world);
        }
    }

    public Vector3d getCenter(ParticlePacketData data) {
        if (data.isVecPos) {
            return data.getPos();
        }
        BlockPos pos = data.getBlockPos();
        return new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public void spawnRedstone(Level world, RGB color, double xpos, double ypos, double zpos) {
        DustParticleOptions data = new DustParticleOptions(new Vector3f(color.getR(), color.getG(), color.getB()), 1.0f);
        world.m_6493_((ParticleOptions)data, true, xpos, ypos, zpos, 1.0, 1.0, 1.0);
    }

    public abstract void activate(ParticlePacketData var1, Level var2);
}

