/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.teleport;

import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.teleport.SavedTeleportPos;
import com.robertx22.library_of_exile.utils.TeleportUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SavedPlayerMapTeleports {
    public SavedTeleportPos home = new SavedTeleportPos();
    public List<SavedTeleportPos> last = new ArrayList<SavedTeleportPos>();

    SavedTeleportPos getLast() {
        return this.last.get(this.last.size() - 1);
    }

    void deleteLast() {
        if (!this.last.isEmpty()) {
            this.last.remove(this.last.size() - 1);
        }
    }

    public void entranceTeleportLogic(Player p, ResourceLocation to, BlockPos topos) {
        ResourceLocation from = p.m_9236_().m_220362_().m_135782_();
        this.teleportToMap(p, from, to, topos);
    }

    public void exitTeleportLogic(Player p) {
        ResourceLocation from = p.m_9236_().m_220362_().m_135782_();
        boolean fromMap = MapDimensions.isMap(from);
        if (fromMap) {
            if (this.last.isEmpty()) {
                this.teleportHome(p);
            } else {
                this.teleportToLast(p);
            }
        }
    }

    public void teleportHome(Player p) {
        ResourceLocation dim = this.home.getDimensionId();
        if (p.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim)) == null) {
            dim = p.m_20194_().m_129783_().m_46472_().m_135782_();
        }
        this.teleport(p, dim, this.home.getPos());
    }

    public void teleportToLast(Player p) {
        this.teleport(p, this.getLast().getDimensionId(), this.getLast().getPos());
        this.deleteLast();
    }

    public void teleportToMap(Player p, ResourceLocation from, ResourceLocation to, BlockPos topos) {
        boolean fromMap = MapDimensions.isMap(from);
        if (!fromMap) {
            this.home.setFrom(p);
            this.last = new ArrayList<SavedTeleportPos>();
        } else {
            SavedTeleportPos data = new SavedTeleportPos();
            data.setFrom(p);
            this.last.add(data);
        }
        this.teleport(p, to, topos);
    }

    private void teleport(Player p, ResourceLocation to, BlockPos pos) {
        TeleportUtils.teleport((ServerPlayer)p, pos, to);
    }
}

