/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.structure.dungeon;

import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.BuiltRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ExileLog;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DungeonRoomPlacer {
    public static boolean generatePiece(LevelAccessor world, BlockPos position, RandomSource random, Rotation rota, ResourceLocation id) {
        StructureTemplate template = (StructureTemplate)world.m_7654_().m_236738_().m_230407_(id).get();
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(rota).m_74392_(false);
        ObjectArrayList commandBlocks = template.m_230335_(BlockPos.f_121853_, new StructurePlaceSettings(), Blocks.f_50272_, true);
        ObjectArrayList structureBlocks = template.m_230335_(BlockPos.f_121853_, new StructurePlaceSettings(), Blocks.f_50677_, true);
        BlockPos finalPosition = position;
        commandBlocks.forEach(block -> {
            BlockPos worldPos = finalPosition.m_121955_((Vec3i)block.f_74675_());
            ExileEvents.DungeonDataBlockPlaced event = new ExileEvents.DungeonDataBlockPlaced(world, worldPos, (StructureTemplate.StructureBlockInfo)block, id);
            ExileEvents.DUNGEON_DATA_BLOCK_PLACED.callEvents(event);
        });
        structureBlocks.forEach(block -> {
            BlockPos worldPos = finalPosition.m_121955_((Vec3i)block.f_74675_());
            ExileEvents.DungeonDataBlockPlaced event = new ExileEvents.DungeonDataBlockPlaced(world, worldPos, (StructureTemplate.StructureBlockInfo)block, id);
            ExileEvents.DUNGEON_DATA_BLOCK_PLACED.callEvents(event);
        });
        settings.m_74381_(settings.m_74409_());
        if (template == null) {
            ExileLog.get().warn("FATAL ERROR: Structure does not exist (" + id + ")", new Object[0]);
            return false;
        }
        if (template.m_163801_().m_123341_() > 16 || template.m_163801_().m_123343_() > 16) {
            ExileLog.get().warn("FATAL ERROR: Structure is bigger than possible (" + id + ") " + template.m_163801_().toString(), new Object[0]);
            return false;
        }
        if (rota == Rotation.COUNTERCLOCKWISE_90) {
            settings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            position = position.m_7918_(0, 0, template.m_163801_().m_123343_() - 1);
        } else if (rota == Rotation.CLOCKWISE_90) {
            settings.m_74379_(Rotation.CLOCKWISE_90);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, 0);
        } else if (rota == Rotation.CLOCKWISE_180) {
            settings.m_74379_(Rotation.CLOCKWISE_180);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, template.m_163801_().m_123343_() - 1);
        } else {
            settings.m_74379_(Rotation.NONE);
        }
        boolean done = template.m_230328_((ServerLevelAccessor)world, position, position, settings, random, 18);
        return done;
    }

    public static boolean generateStructure(MapStructure struc, DungeonBuilder builder, LevelAccessor world, ChunkPos cpos) {
        builder.build();
        if (!builder.builtDungeon.hasRoomForChunk(struc, cpos)) {
            return false;
        }
        BuiltRoom room = builder.builtDungeon.getRoomForChunk(struc, cpos);
        if (room == null) {
            return false;
        }
        BlockPos position = cpos.m_151384_(0, 50, 0);
        DungeonRoomPlacer.generatePiece(world, position, world.m_213780_(), room.data.rotation, room.getStructure());
        return true;
    }
}

