/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.database.relic.stat;

import com.robertx22.library_of_exile.database.relic.stat.ExactRelicStat;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.registry.helpers.ExileKey;
import java.util.HashMap;
import java.util.List;

public class RelicStatsContainer {
    private HashMap<String, Float> map = new HashMap();

    public RelicStatsContainer(HashMap<String, Float> map) {
        this.map = map;
    }

    public static RelicStatsContainer calculate(List<ExactRelicStat> mods) {
        InCalc c = new InCalc();
        for (ExactRelicStat ex : mods) {
            c.add(ex);
        }
        return new RelicStatsContainer(c.map);
    }

    public float get(RelicStat stat) {
        return this.map.getOrDefault(stat.GUID(), Float.valueOf(stat.base)).floatValue();
    }

    public float get(ExileKey<? extends RelicStat, ?> key) {
        RelicStat stat = key.get();
        return this.map.getOrDefault(stat.GUID(), Float.valueOf(stat.base)).floatValue();
    }

    public static class InCalc {
        private HashMap<String, Float> map = new HashMap();

        public void add(ExactRelicStat ex) {
            if (!this.map.containsKey(ex.stat)) {
                this.map.put(ex.stat, Float.valueOf(ex.getStat().base));
            }
            float val = this.map.get(ex.stat).floatValue() + ex.num;
            val = ex.getStat().cap(val);
            this.map.put(ex.stat, Float.valueOf(val));
        }
    }
}

