/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.database.league;

import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.league.LibLeagues;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.ITranslated;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.util.UNICODE;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;

public abstract class League
implements ExileRegistry<League>,
ITranslated {
    public String id;

    public League(String id) {
        this.id = id;
    }

    public static League getFromPosition(ServerLevel level, BlockPos pos) {
        return LibDatabase.Leagues().getList().stream().filter(x -> x.isInSide(level, pos)).findAny().orElse(LibLeagues.INSTANCE.EMPTY.get());
    }

    public abstract boolean isInSide(ServerLevel var1, BlockPos var2);

    public abstract ChatFormatting getTextColor();

    public abstract String modid();

    public abstract String locName();

    @Override
    public ExileRegistryType getExileRegistryType() {
        return LibDatabase.LEAGUE;
    }

    @Override
    public int Weight() {
        return 1000;
    }

    @Override
    public String GUID() {
        return this.id;
    }

    public MutableComponent getPrettifiedName() {
        return Component.m_237113_((String)(UNICODE.SKULL + " ")).m_130940_(this.getTextColor()).m_7220_((Component)this.getTranslation(TranslationType.NAME).getTranslatedName(new Object[0]).m_130940_(this.getTextColor()));
    }

    @Override
    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of(this.modid()).name(ExileTranslation.registry(this, this.locName()));
    }

    public static boolean structureLeagueCheck(MapDimensionInfo map, MapStructure struc, ServerLevel level, BlockPos pos) {
        return map.isInside(struc, level, pos);
    }
}

