/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.command_wrapper;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.robertx22.library_of_exile.command_wrapper.ArgumentWrapper;
import com.robertx22.library_of_exile.command_wrapper.CommandSuggestions;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class StringWrapper
extends ArgumentWrapper<String> {
    public StringWrapper(String argName, Supplier<List<String>> sugg) {
        super(argName);
        this.suggests(sugg);
    }

    @Override
    public String getter(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)this.argName);
    }

    @Override
    public String id() {
        return "string";
    }

    @Override
    public RequiredArgumentBuilder getType() {
        RequiredArgumentBuilder b = Commands.m_82129_((String)this.argName, (ArgumentType)StringArgumentType.string());
        return b;
    }

    public StringWrapper registrySuggestion(final ExileRegistryType type) {
        this.suggestions = new CommandSuggestions(){

            @Override
            public List<String> suggestions() {
                ExileRegistryContainer reg = Database.getRegistry(type);
                List<String> list = reg.getList().stream().map(x -> x.GUID()).collect(Collectors.toList());
                list.add("random");
                return list;
            }
        };
        return this;
    }
}

