/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.Wave_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Player_Ceraunus_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.items.More_Tool_Attribute;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Ceraunus
extends Item
implements More_Tool_Attribute {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final String THROWN_UUID_KEY = "thrown_anchor";

    public Ceraunus(Item.Properties group) {
        super(group);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 15.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-3.3f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ENTITY_INTERACTION_RANGE_ID, "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_6777_(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.m_7500_();
    }

    public void m_6883_(ItemStack stack, Level level, Entity holder, int slot, boolean isSelected) {
        if (!level.m_5776_() && Ceraunus.getThrownUuid(stack) != null && this.getThrownEntity(level, stack) == null) {
            stack.m_41783_().m_128473_(THROWN_UUID_KEY);
        }
    }

    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack p_43419_) {
        return 72000;
    }

    public void m_5551_(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (p_43396_ instanceof Player) {
            Player player = (Player)p_43396_;
            int i = this.m_8105_(p_43394_) - p_43397_;
            float f = Ceraunus.getPowerForTime(i);
            if (!((double)f < 0.5) && !p_43395_.f_46443_) {
                float yawRadians = (float)Math.toRadians(90.0f + player.m_146908_());
                double vecX = Math.cos(yawRadians);
                double vecZ = Math.sin(yawRadians);
                double vec = 2.0;
                double spawnX = p_43396_.m_20185_() + vecX * vec;
                double spawnY = p_43396_.m_20186_();
                double spawnZ = p_43396_.m_20189_() + vecZ * vec;
                int numberOfWaves = 4;
                float angleStep = 25.0f;
                double firstAngleOffset = (double)(numberOfWaves - 1) / 2.0 * (double)angleStep;
                if (p_43396_.m_6144_()) {
                    player.m_36335_().m_41524_((Item)this, CMConfig.CeraunusCooldown);
                    p_43395_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.HEAVY_SMASH.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
                    for (int k = 0; k < numberOfWaves; ++k) {
                        double angle = (double)player.m_146908_() - firstAngleOffset + (double)((float)k * angleStep);
                        double rad = Math.toRadians(angle);
                        double dx = -Math.sin(rad);
                        double dz = Math.cos(rad);
                        Wave_Entity WaveEntity = new Wave_Entity(p_43395_, p_43396_, 60, (float)CMConfig.CeraunusWaveDamage);
                        WaveEntity.m_6034_(spawnX, spawnY, spawnZ);
                        WaveEntity.setState(1);
                        WaveEntity.m_146922_(-((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232)));
                        p_43396_.m_9236_().m_7967_((Entity)WaveEntity);
                    }
                } else if (Ceraunus.getThrownUuid(p_43394_) == null) {
                    Player_Ceraunus_Entity launchedBlock = new Player_Ceraunus_Entity(p_43395_, (LivingEntity)player);
                    launchedBlock.m_36781_((float)player.m_21133_(Attributes.f_22281_));
                    launchedBlock.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                    if (p_43395_.m_7967_((Entity)launchedBlock)) {
                        this.setThrownEntity(p_43394_, launchedBlock);
                    }
                }
            }
        }
    }

    public static float getPowerForTime(int p_40662_) {
        float f = (float)p_40662_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Nullable
    public static UUID getThrownUuid(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128403_(THROWN_UUID_KEY)) {
            return stack.m_41783_().m_128342_(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private Player_Ceraunus_Entity getThrownEntity(Level level, ItemStack stack) {
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel server = (ServerLevel)level;
            UUID id = Ceraunus.getThrownUuid(stack);
            if (id != null && (e = server.m_8791_(id)) instanceof Player_Ceraunus_Entity) {
                Player_Ceraunus_Entity ceraunus_entity = (Player_Ceraunus_Entity)e;
                return ceraunus_entity;
            }
        }
        return null;
    }

    private void setThrownEntity(ItemStack stack, Player_Ceraunus_Entity cube) {
        stack.m_41784_().m_128362_(THROWN_UUID_KEY, cube.m_20148_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)Cataclysm.PROXY.getISTERProperties());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43383_) {
        return p_43383_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43383_);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.ceraunus.desc").m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.ceraunus2.desc").m_130940_(ChatFormatting.DARK_GREEN));
    }
}

