/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;

public class WarpedFungusFeature
extends Feature<HugeFungusConfiguration> {
    public WarpedFungusFeature(Codec<HugeFungusConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeFungusConfiguration> context) {
        WorldGenLevel worldGenLevel = context.m_159774_();
        BlockPos originPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        ChunkGenerator chunkGenerator = context.m_159775_();
        HugeFungusConfiguration config = (HugeFungusConfiguration)context.m_159778_();
        Block baseBlock = config.f_65897_.m_60734_();
        BlockPos placePos = null;
        BlockState baseBlockState = worldGenLevel.m_8055_(originPos.m_7495_());
        if (baseBlockState.m_60713_(baseBlock)) {
            placePos = originPos;
        }
        if (placePos == null) {
            return false;
        }
        int height = Mth.m_216271_((RandomSource)random, (int)9, (int)13);
        if (random.m_188503_(12) == 0) {
            height *= 2;
        }
        if (!config.f_65901_) {
            int maxGenDepth = chunkGenerator.m_6331_();
            if (placePos.m_123342_() + height + 1 >= maxGenDepth) {
                return false;
            }
        }
        boolean largeStem = !config.f_65901_ && random.m_188501_() < 0.06f;
        worldGenLevel.m_7731_(originPos, Blocks.f_50016_.m_49966_(), 4);
        this.placeStem(worldGenLevel, random, config, placePos, height, largeStem);
        this.placeHat(worldGenLevel, random, config, placePos, height, largeStem);
        return true;
    }

    private static boolean isReplaceable(WorldGenLevel level, BlockPos pos, HugeFungusConfiguration config, boolean checkReplaceableBlocks) {
        if (level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_247087_)) {
            return true;
        }
        return checkReplaceableBlocks && config.f_283781_.test((Object)level, (Object)pos);
    }

    private void placeStem(WorldGenLevel level, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int height, boolean largeStem) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockState stemState = config.f_65898_;
        int stemRadius = largeStem ? 1 : 0;
        for (int x = -stemRadius; x <= stemRadius; ++x) {
            for (int z = -stemRadius; z <= stemRadius; ++z) {
                boolean isCorner = largeStem && Mth.m_14040_((int)x) == stemRadius && Mth.m_14040_((int)z) == stemRadius;
                for (int y = 0; y < height; ++y) {
                    mutableBlockPos.m_122154_((Vec3i)pos, x, y, z);
                    if (!WarpedFungusFeature.isReplaceable(level, (BlockPos)mutableBlockPos, config, true)) continue;
                    if (config.f_65901_) {
                        if (!level.m_8055_(mutableBlockPos.m_7495_()).m_60795_()) {
                            level.m_46961_((BlockPos)mutableBlockPos, true);
                        }
                        level.m_7731_((BlockPos)mutableBlockPos, stemState, 3);
                        continue;
                    }
                    if (isCorner) {
                        if (!(random.m_188501_() < 0.1f)) continue;
                        this.m_5974_((LevelWriter)level, (BlockPos)mutableBlockPos, stemState);
                        continue;
                    }
                    this.m_5974_((LevelWriter)level, (BlockPos)mutableBlockPos, stemState);
                }
            }
        }
    }

    private void placeHat(WorldGenLevel level, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int height, boolean largeStem) {
        int stemHeight;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        boolean beardValid = config.f_65899_.m_204336_(JNETags.Blocks.WART_BEARD_FEATURE_VALID);
        int hatHeight = Math.min(random.m_188503_(1 + height / 3) + 5, height);
        for (int y = stemHeight = height - hatHeight; y <= height; ++y) {
            int hatRadius;
            int n = hatRadius = y < height - random.m_188503_(3) ? 2 : 1;
            if (hatHeight > 8 && y < stemHeight + 4) {
                hatRadius = 3;
            }
            if (largeStem) {
                ++hatRadius;
            }
            for (int x = -hatRadius; x <= hatRadius; ++x) {
                for (int z = -hatRadius; z <= hatRadius; ++z) {
                    boolean isEdgeX = x == -hatRadius || x == hatRadius;
                    boolean isEdgeZ = z == -hatRadius || z == hatRadius;
                    boolean isCenter = !isEdgeX && !isEdgeZ && y != height;
                    boolean isCorner = isEdgeX && isEdgeZ;
                    boolean lowHat = y < stemHeight + 3;
                    mutableBlockPos.m_122154_((Vec3i)pos, x, y, z);
                    if (!WarpedFungusFeature.isReplaceable(level, (BlockPos)mutableBlockPos, config, false)) continue;
                    if (config.f_65901_ && !level.m_8055_(mutableBlockPos.m_7495_()).m_60795_()) {
                        level.m_46961_((BlockPos)mutableBlockPos, true);
                    }
                    if (lowHat) {
                        if (isCenter) continue;
                        this.placeHatDropBlock((LevelAccessor)level, random, (BlockPos)mutableBlockPos, config.f_65899_, beardValid);
                        continue;
                    }
                    if (isCenter) {
                        this.placeHatBlock((LevelAccessor)level, random, config, mutableBlockPos, 0.1f, 0.2f, beardValid ? 0.1f : 0.0f);
                        continue;
                    }
                    if (isCorner) {
                        this.placeHatBlock((LevelAccessor)level, random, config, mutableBlockPos, 0.01f, 0.7f, beardValid ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock((LevelAccessor)level, random, config, mutableBlockPos, 5.0E-4f, 0.98f, beardValid ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(LevelAccessor level, RandomSource random, HugeFungusConfiguration config, BlockPos.MutableBlockPos pos, float probability1, float probability2, float probability3) {
        if (random.m_188501_() < probability1) {
            this.m_5974_((LevelWriter)level, (BlockPos)pos, config.f_65900_);
        } else if (random.m_188501_() < probability2) {
            this.m_5974_((LevelWriter)level, (BlockPos)pos, config.f_65899_);
            WarpedFungusFeature.tryPlaceBeard((BlockPos)pos, level);
        }
    }

    private void placeHatDropBlock(LevelAccessor level, RandomSource random, BlockPos pos, BlockState state, boolean beardValid) {
        if (level.m_8055_(pos.m_7495_()).m_60713_(state.m_60734_())) {
            this.m_5974_((LevelWriter)level, pos, state);
        } else if ((double)random.m_188501_() < 0.15) {
            this.m_5974_((LevelWriter)level, pos, state);
        } else if (level.m_8055_(pos.m_7494_()).m_60713_(state.m_60734_())) {
            WarpedFungusFeature.tryPlaceBeard(pos, level);
        }
    }

    private static void tryPlaceBeard(BlockPos pos, LevelAccessor level) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_().m_122173_(Direction.DOWN);
        if (level.m_46859_((BlockPos)mutableBlockPos) && level.m_8055_(mutableBlockPos.m_7494_()).m_204336_(JNETags.Blocks.WART_BEARD_FEATURE_VALID)) {
            level.m_7731_((BlockPos)mutableBlockPos, ((Block)JNEBlocks.WARPED_WART_BEARD.get()).m_49966_(), 2);
        }
    }
}

