/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.misc_registry;

import java.util.HashSet;
import java.util.Set;
import net.jadenxgamer.netherexp.mixin.block.WoodTypeAccessor;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEBlockSetType;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class JNEWoodType {
    public static final Set<WoodType> WOOD_TYPES = new HashSet<WoodType>();
    public static final WoodType CLARET = JNEWoodType.registerWoodType("claret", JNEBlockSetType.CLARET, SoundType.f_244244_, SoundType.f_256908_, SoundEvents.f_244593_, SoundEvents.f_244579_);
    public static final WoodType SMOKESTALK = JNEWoodType.registerWoodType("smokestalk", JNEBlockSetType.SMOKESTALK, JNESoundType.SMOKESTALK_WOOD, SoundType.f_256995_, SoundEvents.f_243721_, SoundEvents.f_244336_);

    private static WoodType registerWoodType(String path, BlockSetType blockSetType, SoundType soundType, SoundType hangingSignSoundType, SoundEvent fenceGateCloseSound, SoundEvent fenceGateOpenSound) {
        String name = new ResourceLocation("netherexp", path).toString();
        WoodType result = new WoodType(name, blockSetType, soundType, hangingSignSoundType, fenceGateCloseSound, fenceGateOpenSound);
        WoodTypeAccessor.netherexp$invokeRegisterWoodType(result);
        WOOD_TYPES.add(result);
        return result;
    }

    public static void add() {
        for (WoodType woodType : WOOD_TYPES) {
            String name = new ResourceLocation(woodType.f_61839_()).m_135815_();
            Sheets.f_110743_.put(woodType, new Material(Sheets.f_110739_, new ResourceLocation("netherexp", "entity/signs/" + name)));
            Sheets.f_244291_.put(woodType, new Material(Sheets.f_110739_, new ResourceLocation("netherexp", "entity/signs/hanging/" + name)));
        }
    }
}

