/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class VineStemBlock
extends GrowingPlantHeadBlock {
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);
    private static final Map<Direction, VoxelShape> FACING_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (Object)Direction.NORTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)15.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)));
    private final StemGrownBlock stemGrownBlock;
    private final Supplier<Item> pickBlockItem;

    public VineStemBlock(StemGrownBlock stemGrownBlock, Supplier<Item> pickBlockItem, BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, false, 0.1);
        this.stemGrownBlock = stemGrownBlock;
        this.pickBlockItem = pickBlockItem;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        boolean a = (Boolean)blockState.m_61143_((Property)ATTACHED);
        if (a) {
            return FACING_TO_SHAPE.get(blockState.m_61143_((Property)FACING));
        }
        return SHAPE;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction direction;
        BlockPos blockPos2;
        BlockPos blockPos;
        int i = (Integer)state.m_61143_((Property)f_53924_);
        boolean a = (Boolean)state.m_61143_((Property)ATTACHED);
        if (!a && i < 25 && random.m_188500_() < 0.5 && this.m_5971_(level.m_8055_(blockPos = pos.m_121955_(this.f_53859_.m_122436_())))) {
            level.m_7731_(blockPos, this.m_214070_(state, level.f_46441_), 3);
        } else if (!a && i == 25 && level.m_8055_(blockPos2 = pos.m_121955_((direction = Direction.Plane.HORIZONTAL.m_235690_(random)).m_122436_())).m_60795_()) {
            level.m_7731_(blockPos2, this.stemGrownBlock.m_49966_(), 3);
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction), 3);
        }
    }

    public boolean m_6724_(BlockState blockState) {
        boolean a = (Boolean)blockState.m_61143_((Property)ATTACHED);
        return !a;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean a = (Boolean)state.m_61143_((Property)ATTACHED);
        if (a && !neighborState.m_60713_((Block)this.stemGrownBlock) && direction == state.m_61143_((Property)FACING)) {
            return (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
        }
        if (direction == this.f_53859_.m_122424_() && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        if (direction == this.f_53859_ && (neighborState.m_60713_((Block)this) || neighborState.m_60713_(this.m_7777_()))) {
            return this.m_142643_(state, this.m_7777_().m_49966_());
        }
        if (this.f_53860_) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_121955_(this.f_53859_.m_122424_().m_122436_());
        BlockState blockState2 = level.m_8055_(blockPos2);
        if (!this.m_142209_(blockState)) {
            return false;
        }
        return blockState2.m_60713_((Block)this.m_7272_()) || blockState2.m_60713_(this.m_7777_()) || blockState2.m_204336_(JNETags.Blocks.SOUL_SAND_BLOCKS);
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)this.pickBlockItem.get());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHED, FACING, f_53924_});
    }

    @NotNull
    protected Block m_7777_() {
        return (Block)JNEBlocks.SORROWSQUASH_STEM_PLANT.get();
    }

    protected int m_213627_(RandomSource random) {
        return NetherVines.m_221803_((RandomSource)random);
    }

    protected boolean m_5971_(BlockState blockState) {
        return NetherVines.m_54963_((BlockState)blockState);
    }
}

