/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.mixin.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jadenxgamer.netherexp.NetherExpClient;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.config.enums.NetherFogDistance;
import net.jadenxgamer.netherexp.registry.effect.JNEMobEffects;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Inject(method={"setupFog"}, at={@At(value="TAIL")})
    private static void netherexp$applyCustomFog(Camera camera, FogRenderer.FogMode fogMode, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo ci) {
        Entity entity = camera.m_90592_();
        FogType fogType = camera.m_167685_();
        if (NetherExpClient.INSIDE_SOUL_GLASS) {
            RenderSystem.setShaderFogStart((float)2.0f);
            RenderSystem.setShaderFogEnd((float)6.0f);
            RenderSystem.setShaderFogColor((float)0.106f, (float)0.278f, (float)0.271f);
        } else if (NetherExpClient.INSIDE_MAGMA_CREAM_BLOCK) {
            RenderSystem.setShaderFogStart((float)2.0f);
            RenderSystem.setShaderFogEnd((float)6.0f);
            RenderSystem.setShaderFogColor((float)1.0f, (float)0.4f, (float)0.0f);
        } else if (NetherExpClient.INSIDE_ECTOPLASM) {
            RenderSystem.setShaderFogStart((float)-8.0f);
            RenderSystem.setShaderFogEnd((float)8.0f);
            RenderSystem.setShaderFogColor((float)0.02f, (float)0.333f, (float)0.357f);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21023_((MobEffect)JNEMobEffects.BETRAYED.get())) {
                if (fogType == FogType.NONE) {
                    RenderSystem.setShaderFogStart((float)0.0f);
                    RenderSystem.setShaderFogEnd((float)(viewDistance / 2.0f));
                    RenderSystem.setShaderFogColor((float)0.69f, (float)0.067f, (float)0.067f);
                }
            } else if (JNEConfigs.NETHER_FOG_DISTANCE.get() != NetherFogDistance.VANILLA && !livingEntity.m_21023_(MobEffects.f_19610_) && !livingEntity.m_21023_(MobEffects.f_216964_) && thickFog && fogType == FogType.NONE) {
                RenderSystem.setShaderFogStart((float)FogRendererMixin.netherexp$getFogStart(JNEConfigs.NETHER_FOG_DISTANCE.get()));
                RenderSystem.setShaderFogEnd((float)FogRendererMixin.netherexp$getFogEnd(JNEConfigs.NETHER_FOG_DISTANCE.get(), viewDistance));
            }
        }
    }

    @Unique
    private static float netherexp$getFogStart(NetherFogDistance config) {
        if (config == NetherFogDistance.DISABLED) {
            return -8.0f;
        }
        return 0.0f;
    }

    @Unique
    private static float netherexp$getFogEnd(NetherFogDistance config, float viewDistance) {
        switch (config) {
            case FAR: {
                return viewDistance * 1.5f;
            }
            case DISABLED: {
                return 1000000.0f;
            }
        }
        return viewDistance;
    }
}

