/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.forge;

import net.jadenxgamer.netherexp.mixin.block.ItemPropertiesAccessor;
import net.jadenxgamer.netherexp.registry.block.JNEBlockEntityType;
import net.jadenxgamer.netherexp.registry.block.entity.client.JNEBrushableBlockRenderer;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.client.ApparitionModel;
import net.jadenxgamer.netherexp.registry.entity.client.ApparitionRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.BansheeModel;
import net.jadenxgamer.netherexp.registry.entity.client.BansheeRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.CarcassModel;
import net.jadenxgamer.netherexp.registry.entity.client.CarcassRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.EctoSlabModel;
import net.jadenxgamer.netherexp.registry.entity.client.EctoSlabRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.JNEModelLayers;
import net.jadenxgamer.netherexp.registry.entity.client.MistChargeModel;
import net.jadenxgamer.netherexp.registry.entity.client.MistChargeRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.PhasmoArrowRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.SoulBulletRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.StampedeModel;
import net.jadenxgamer.netherexp.registry.entity.client.StampedeRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.VesselModel;
import net.jadenxgamer.netherexp.registry.entity.client.VesselRenderer;
import net.jadenxgamer.netherexp.registry.entity.client.WispModel;
import net.jadenxgamer.netherexp.registry.entity.client.WispRenderer;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.item.custom.AntidoteItem;
import net.jadenxgamer.netherexp.registry.item.custom.SanctumCompassItem;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.jadenxgamer.netherexp.registry.particle.custom.AerosolParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.BloodFallAndLandParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.BloodLandParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.BurstParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.EctoplasmaParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.EctoraysParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.EnigmaKernelParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.FallingParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.FireSparkParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.GlimmerParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.GraspMistParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.RedstoneExplosionEmitterParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.RisingParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.SmallRisingParticle;
import net.jadenxgamer.netherexp.registry.particle.custom.SmogParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class NetherExpForgeClient {
    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(NetherExpForgeClient::onClientSetup);
        eventBus.addListener(NetherExpForgeClient::renderParticles);
        eventBus.addListener(NetherExpForgeClient::itemTints);
        eventBus.addListener(NetherExpForgeClient::registerGuiOverlays);
        eventBus.addListener(NetherExpForgeClient::registerLayer);
    }

    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.APPARITION.get()), ApparitionRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.WISP.get()), WispRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.VESSEL.get()), VesselRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.ECTO_SLAB.get()), EctoSlabRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.BANSHEE.get()), BansheeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.STAMPEDE.get()), StampedeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.CARCASS.get()), CarcassRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.SOUL_BULLET.get()), SoulBulletRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.BLOOD_DROP.get()), NoopRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.PHASMO_ARROW.get()), PhasmoArrowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.MIST_CHARGE.get()), MistChargeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.GRAVE_CLOUD.get()), NoopRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.WILL_O_WISP.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.ANTIDOTE.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)JNEEntityType.GRENADE_EFFECT_CLOUD.get()), NoopRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)JNEBlockEntityType.BRUSHABLE_BLOCK.get()), JNEBrushableBlockRenderer::new);
        event.enqueueWork(() -> ItemPropertiesAccessor.netherexp$invokeRegisterItemProperties((Item)JNEItems.SANCTUM_COMPASS.get(), new ResourceLocation("angle"), (ClampedItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> SanctumCompassItem.getStructurePosition(stack.m_41784_()))));
    }

    public static void itemTints(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> tint > 0 ? -1 : AntidoteItem.getColor(stack), new ItemLike[]{(ItemLike)JNEItems.ANTIDOTE.get()});
        event.register((stack, tint) -> tint > 0 ? -1 : AntidoteItem.getColor(stack), new ItemLike[]{(ItemLike)JNEItems.GRENADE_ANTIDOTE.get()});
    }

    public static void renderParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)JNEParticleTypes.ENIGMA_KERNEL.get(), EnigmaKernelParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FIRE_SPARK.get(), FireSparkParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.SMALL_SOUL_FIRE_FLAME.get(), FlameParticle.SmallFlameProvider::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.TREACHEROUS_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.GOLD_GLIMMER.get(), GlimmerParticle.NormalFactory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.REDSTONE_SPARK.get(), GlimmerParticle.NormalFactory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.REDSTONE_EXPLOSION.get(), HugeExplosionParticle.Provider::new);
        event.registerSpecial((ParticleType)JNEParticleTypes.REDSTONE_EXPLOSION_EMITTER.get(), (ParticleProvider)new RedstoneExplosionEmitterParticle.Factory());
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_NETHER_WART.get(), FallingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_WARPED_WART.get(), FallingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_SHROOMLIGHT.get(), FallingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_SHROOMNIGHT.get(), FallingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.RISING_SHROOMNIGHT.get(), RisingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.CRIMSON_SMOG.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.WARPED_SMOG.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.BLACK_SMOKE.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.WHITE_SMOKE.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.RED_SMOKE.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.SOUL_EMBER.get(), SmallRisingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.ECTORAYS.get(), EctoraysParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.ECTOPLASMA.get(), EctoplasmaParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.BLACK_AEROSOL.get(), AerosolParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.SWIRL_POP.get(), RisingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.GRASP_MIST.get(), GraspMistParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.WISP.get(), GlimmerParticle.LongFactory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.COLORED_WISP.get(), GlimmerParticle.ColoredFactory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.MAGMA_CREAM.get(), RisingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.IMMUNITY_EFFECT.get(), SpellParticle.MobProvider::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_BLOOD.get(), BloodFallAndLandParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.LANDING_BLOOD.get(), BloodLandParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.CANDLE_BURST.get(), BurstParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.FALLING_SHROOMBLIGHT.get(), FallingParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.UMBRAL_SMOG.get(), SmogParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JNEParticleTypes.SHALE_SWIRL_POP.get(), RisingParticle.Factory::new);
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(JNEModelLayers.APPARITION_LAYER, ApparitionModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.WISP_LAYER, WispModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.VESSEL_LAYER, VesselModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.ECTO_SLAB_LAYER, EctoSlabModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.BANSHEE_LAYER, BansheeModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.STAMPEDE_LAYER, StampedeModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.CARCASS_LAYER, CarcassModel::createBodyLayer);
        event.registerLayerDefinition(JNEModelLayers.MIST_CHARGE_LAYER, MistChargeModel::createBodyLayer);
    }
}

