/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.forge;

import dev.architectury.platform.forge.EventBuses;
import java.nio.file.Path;
import net.jadenxgamer.netherexp.NetherExp;
import net.jadenxgamer.netherexp.NetherExpClient;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.config.JNEForgeConfigs;
import net.jadenxgamer.netherexp.forge.NetherExpForgeClient;
import net.jadenxgamer.netherexp.forge.loot.JNELootModifiers;
import net.jadenxgamer.netherexp.forge.worldgen.SpawnCostsBiomeModifier;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.Banshee;
import net.jadenxgamer.netherexp.registry.entity.custom.Carcass;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.entity.custom.Wisp;
import net.jadenxgamer.netherexp.registry.fluid.JNEFluids;
import net.jadenxgamer.netherexp.registry.item.brewing.JNEPotionRecipe;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="netherexp")
public class NetherExpForge {
    public NetherExpForge() {
        EventBuses.registerModEventBus((String)"netherexp", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JNEForgeConfigs.COMMON);
        NetherExp.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> NetherExpClient::init);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> NetherExpForgeClient::init);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        JNELootModifiers.init(eventBus);
        DeferredRegister BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"netherexp");
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        BIOME_MODIFIER_SERIALIZERS.register("spawn_costs", SpawnCostsBiomeModifier::createCodec);
        eventBus.addListener(NetherExpForge::commonSetup);
        eventBus.addListener(NetherExpForge::registerAttributes);
        eventBus.addListener(NetherExpForge::registerSpawnPlacements);
        eventBus.addListener(NetherExpForge::loadComplete);
        eventBus.addListener(NetherExpForge::addBuiltinPacks);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(JNEPotionRecipe::addInvokerPotionRecipes);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)JNEEntityType.APPARITION.get(), Apparition.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.WISP.get(), Wisp.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.VESSEL.get(), Vessel.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.ECTO_SLAB.get(), Vessel.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.BANSHEE.get(), Banshee.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.STAMPEDE.get(), Vessel.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.CARCASS.get(), Carcass.createAttributes().m_22265_());
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)JNEEntityType.VESSEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.APPARITION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.BANSHEE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(NetherExpForge::registerFluidInteractions);
    }

    private static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FlowingFluid)JNEFluids.ECTOPLASM.get()).getFluidType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)JNEBlocks.BLACK_ICE.get()).m_49966_()));
    }

    private static void addBuiltinPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            NetherExpForge.rpConflictingRetextures(event);
            NetherExpForge.rpUniqueNetherWood(event);
        }
        if (event.getPackType() == PackType.SERVER_DATA && JNEConfigs.LARGER_NETHER_BIOMES.get().booleanValue()) {
            NetherExpForge.dpLargerNetherBiomes(event);
        }
    }

    private static void rpConflictingRetextures(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("netherexp");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/conflicting_retextures"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"netherexp:conflicting_retextures", (Component)Component.m_237113_((String)"Conflicting Retextures"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Adds Retextures which may cause Mod Conflicts"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (boolean)false, (PackSource)PackSource.f_10528_)));
    }

    private static void rpUniqueNetherWood(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("netherexp");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/unique_nether_wood"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"unique_nether_wood", (Component)Component.m_237113_((String)"Unique Nether Wood"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Gives All Nether Woodsets Unique Designs"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (boolean)false, (PackSource)PackSource.f_10528_)));
    }

    private static void dpLargerNetherBiomes(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("netherexp");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/larger_nether_biomes"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"larger_nether_biomes", (Component)Component.m_237113_((String)"Larger Nether Biomes"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Increases the size of all nether biomes"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), FeatureFlagSet.m_246902_()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.f_10528_)));
    }
}

