/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;
import vectorwing.farmersdelight.common.registry.ModItems;

public class BuddingBushBlock
extends BushBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};

    public BuddingBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState state) {
        return this.canGrowPastMaxAge() || !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && (age = this.getAge(state)) <= this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (growthSpeed = BuddingBushBlock.getGrowthSpeed((Block)this, (BlockGetter)level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (this.isMaxAge(state)) {
                this.growPastMaxAge(state, level, pos, random);
            } else {
                level.m_46597_(pos, this.getStateForAge(age + 1));
            }
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean canGrowPastMaxAge() {
        return false;
    }

    public void growPastMaxAge(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean matchesNorthSouthRow;
        float speed = 1.0f;
        BlockPos posBelow = pos.m_7495_();
        for (int posX = -1; posX <= 1; ++posX) {
            for (int posZ = -1; posZ <= 1; ++posZ) {
                float speedBonus = 0.0f;
                BlockState stateBelow = level.m_8055_(posBelow.m_7918_(posX, 0, posZ));
                if (stateBelow.canSustainPlant(level, posBelow.m_7918_(posX, 0, posZ), Direction.UP, (IPlantable)block)) {
                    speedBonus = 1.0f;
                    if (stateBelow.isFertile(level, pos.m_7918_(posX, 0, posZ))) {
                        speedBonus = 3.0f;
                    }
                }
                if (posX != 0 || posZ != 0) {
                    speedBonus /= 4.0f;
                }
                speed += speedBonus;
            }
        }
        BlockPos posNorth = pos.m_122012_();
        BlockPos posSouth = pos.m_122019_();
        BlockPos posWest = pos.m_122024_();
        BlockPos posEast = pos.m_122029_();
        boolean matchesEastWestRow = level.m_8055_(posWest).m_60713_(block) || level.m_8055_(posEast).m_60713_(block);
        boolean bl = matchesNorthSouthRow = level.m_8055_(posNorth).m_60713_(block) || level.m_8055_(posSouth).m_60713_(block);
        if (matchesEastWestRow && matchesNorthSouthRow) {
            speed /= 2.0f;
        } else {
            boolean matchesDiagonalRows;
            boolean bl2 = matchesDiagonalRows = level.m_8055_(posWest.m_122012_()).m_60713_(block) || level.m_8055_(posEast.m_122012_()).m_60713_(block) || level.m_8055_(posEast.m_122019_()).m_60713_(block) || level.m_8055_(posWest.m_122019_()).m_60713_(block);
            if (matchesDiagonalRows) {
                speed /= 2.0f;
            }
        }
        return speed;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && super.m_7898_(state, level, pos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.TOMATO_SEEDS.get();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

