/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.sounds;

import com.google.common.collect.Maps;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.debug.DebugUtils;
import dev.arbor.extrasoundsnext.mapping.SoundPackLoader;
import dev.arbor.extrasoundsnext.sounds.Mixers;
import dev.arbor.extrasoundsnext.sounds.SoundType;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RandomSource MC_RANDOM = RandomSource.m_216327_();
    private static final BiPredicate<ClickType, Integer> RIGHT_CLICK_PREDICATE = (actionType, button) -> actionType != ClickType.THROW && actionType != ClickType.SWAP && button == 1 || actionType == ClickType.QUICK_CRAFT && AbstractContainerMenu.m_38928_((int)button) == 1;
    private static final Map<Item, BiPredicate<ClickType, Integer>> IGNORE_SOUND_PREDICATE_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> map.put(Items.f_151058_, RIGHT_CLICK_PREDICATE));
    private static long lastPlayed = 0L;
    private static Item quickMovingItem = Items.f_41852_;

    public static void hotbar(int i) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(i);
        if (stack.m_41720_() == Items.f_41852_) {
            SoundManager.playSound(Sounds.HOTBAR_SCROLL, SoundType.HOTBAR, Mixers.EMPTY_HOTBAR);
        } else {
            SoundManager.playSound(stack, SoundType.HOTBAR);
        }
    }

    public static void inventoryClick(ItemStack inSlot, ItemStack onCursor, ClickType actionType) {
        boolean hasSlot;
        boolean hasCursor = !onCursor.m_41619_();
        boolean bl = hasSlot = !inSlot.m_41619_();
        if (!hasCursor && !hasSlot) {
            return;
        }
        switch (actionType) {
            case PICKUP_ALL: {
                if (!hasCursor || onCursor.m_41613_() >= onCursor.m_41741_()) break;
                SoundManager.playSound(Sounds.ITEM_PICK_ALL, SoundType.PICKUP);
                break;
            }
            case THROW: {
                if (hasCursor) break;
                SoundManager.playThrow(inSlot);
                break;
            }
            case QUICK_MOVE: {
                if (!hasSlot) break;
                SoundManager.handleQuickMoveSound(inSlot);
                break;
            }
            default: {
                if (hasSlot) {
                    SoundManager.playSound(inSlot, SoundType.PICKUP);
                    break;
                }
                SoundManager.playSound(onCursor, SoundType.PLACE);
            }
        }
    }

    public static void handleInventorySlot(Player player, @Nullable Slot slot, int slotIndex, ItemStack cursor, ClickType actionType, int button) {
        ItemStack slotItem;
        if (actionType == ClickType.QUICK_CRAFT && AbstractContainerMenu.m_38947_((int)button) < 2) {
            return;
        }
        if (slotIndex == -1) {
            return;
        }
        ItemStack itemStack = slotItem = slot == null ? ItemStack.f_41583_ : slot.m_7993_().m_41777_();
        if (actionType == ClickType.QUICK_MOVE) {
            SoundManager.handleQuickMoveSound(slotItem);
            return;
        }
        ItemStack cursorItem = actionType == ClickType.SWAP ? (Inventory.m_36045_((int)button) ? player.m_150109_().m_8020_(button).m_41777_() : player.m_21206_().m_41777_()) : cursor.m_41777_();
        if (slotIndex == -999 && actionType != ClickType.QUICK_CRAFT) {
            if (RIGHT_CLICK_PREDICATE.test(actionType, button)) {
                cursorItem.m_41764_(1);
            }
            SoundManager.playThrow(cursorItem);
            return;
        }
        if (actionType == ClickType.THROW && button == 0) {
            slotItem.m_41764_(1);
        }
        try {
            BiPredicate predicateForCursor = IGNORE_SOUND_PREDICATE_MAP.getOrDefault(cursorItem.m_41720_(), null);
            if (predicateForCursor != null && predicateForCursor.test(actionType, button)) {
                return;
            }
            BiPredicate predicateForSlot = IGNORE_SOUND_PREDICATE_MAP.getOrDefault(slotItem.m_41720_(), null);
            if (predicateForSlot != null && predicateForSlot.test(actionType, button)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SoundManager.inventoryClick(slotItem, cursorItem, actionType);
    }

    public static void playSound(ItemStack stack, SoundType type) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        ResourceLocation id = ExtraSoundsNext.getClickId(itemId, type);
        SoundEvent event = SoundPackLoader.CUSTOM_SOUND_EVENT.getOrDefault(id, null);
        if (event == null) {
            SoundManager.playDefaultSound(stack, type);
            return;
        }
        SoundManager.playSound(event, type);
    }

    public static void playDefaultSound(ItemStack stack, SoundType type) {
        ResourceLocation defaultItem = ExtraSoundsNext.getClickId(BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_42415_), type);
        ResourceLocation defaultBlock = ExtraSoundsNext.getClickId(BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_41905_), type);
        SoundEvent defaultSound = stack.m_41720_() instanceof BlockItem ? SoundPackLoader.CUSTOM_SOUND_EVENT.get(defaultBlock) : SoundPackLoader.CUSTOM_SOUND_EVENT.get(defaultItem);
        SoundManager.playSound(defaultSound, type);
    }

    public static void effectChanged(MobEffect effect, EffectType type) {
        SoundEvent event;
        if (DebugUtils.DEBUG) {
            DebugUtils.effectLog(effect, type);
        }
        if (type == EffectType.ADD) {
            event = switch (effect.m_19483_()) {
                default -> throw new IncompatibleClassChangeError();
                case MobEffectCategory.HARMFUL -> Sounds.EFFECT_ADD_NEGATIVE;
                case MobEffectCategory.NEUTRAL, MobEffectCategory.BENEFICIAL -> Sounds.EFFECT_ADD_POSITIVE;
            };
        } else if (type == EffectType.REMOVE) {
            event = switch (effect.m_19483_()) {
                default -> throw new IncompatibleClassChangeError();
                case MobEffectCategory.HARMFUL -> Sounds.EFFECT_REMOVE_NEGATIVE;
                case MobEffectCategory.NEUTRAL, MobEffectCategory.BENEFICIAL -> Sounds.EFFECT_REMOVE_POSITIVE;
            };
        } else {
            LOGGER.error("[{}] Unknown type of '{}' is approaching: '{}'", (Object)ExtraSoundsNext.class.getSimpleName(), (Object)EffectType.class.getSimpleName(), (Object)type);
            return;
        }
        SoundManager.playSound(event, SoundType.EFFECT, Mixers.ENABLED_EFFECTS);
    }

    public static void playSound(SoundEvent snd, SoundType type) {
        SoundManager.playSound(snd, type.pitch, type.category, new SoundSource[0]);
    }

    public static void playSound(SoundEvent snd, SoundType type, SoundSource ... optionalVolumes) {
        SoundManager.playSound(snd, type.pitch, type.category, optionalVolumes);
    }

    public static void playSound(SoundEvent snd, float pitch, SoundSource category, SoundSource ... optionalVolumes) {
        float volume = SoundManager.getSoundVolume(Mixers.MASTER, new boolean[0]);
        if (optionalVolumes != null) {
            for (SoundSource cat : optionalVolumes) {
                volume = Math.min(SoundManager.getSoundVolume(cat, new boolean[0]), volume);
            }
        }
        SoundManager.playSound((SoundInstance)new SimpleSoundInstance(snd == null ? ExtraSoundsNext.id("missing") : snd.m_11660_(), category, volume, pitch, MC_RANDOM, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void playSound(SoundEvent snd, SoundType type, float volume, float pitch, BlockPos position, SoundSource ... optionalVolumes) {
        SoundManager.playSound(snd, type, volume, pitch, position, false, optionalVolumes);
    }

    public static void playSound(SoundEvent snd, SoundType type, float volume, float pitch, BlockPos position, boolean anti, SoundSource ... optionalVolumes) {
        if (optionalVolumes != null) {
            for (SoundSource cat : optionalVolumes) {
                volume = Math.min(SoundManager.getSoundVolume(cat, anti), volume * SoundManager.getSoundVolume(Mixers.MASTER, new boolean[0]));
            }
        }
        SoundManager.playSound((SoundInstance)new SimpleSoundInstance(snd, type.category, volume, pitch, MC_RANDOM, position));
    }

    public static void playSound(SoundEvent snd, SoundType type, SoundSource enabledFootstep, BlockPos position) {
        SoundManager.playSound(snd, type, 1.0f, type.pitch, position, enabledFootstep);
    }

    public static void playSound(SoundInstance instance) {
        try {
            long now = System.currentTimeMillis();
            if (now - lastPlayed > 5L) {
                Minecraft client = Minecraft.m_91087_();
                client.m_6937_(() -> client.m_91106_().m_120367_(instance));
                lastPlayed = now;
                if (DebugUtils.DEBUG) {
                    DebugUtils.soundLog(instance);
                }
            } else if (DebugUtils.DEBUG) {
                LOGGER.warn("Sound suppressed due to the fast interval between method calls, was '{}'.", (Object)instance.m_7904_());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to play sound", e);
        }
    }

    public static void playThrow(ItemStack itemStack) {
        SoundManager.playThrow(itemStack, Mixers.INVENTORY);
    }

    public static void playThrow(ItemStack itemStack, SoundSource category) {
        if (itemStack.m_41619_()) {
            return;
        }
        float maxPitch = 2.0f;
        float pitch = !itemStack.m_41753_() ? 2.0f : Mth.m_144920_((float)2.0f, (float)1.5f, (float)((float)itemStack.m_41613_() / (float)itemStack.m_41720_().m_41459_()));
        SoundManager.playSound(Sounds.ITEM_DROP, pitch, category, Mixers.ITEM_DROP);
    }

    public static void stopSound(SoundEvent e, SoundType type) {
        Minecraft.m_91087_().m_91106_().m_120386_(e.m_11660_(), type.category);
    }

    public static void handleQuickMoveSound(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 50L || !itemStack.m_150930_(quickMovingItem)) {
            SoundManager.playSound(itemStack, SoundType.PICKUP);
            lastPlayed = now;
            quickMovingItem = itemStack.m_41720_();
        }
    }

    public static void keyboard(KeyType type) {
        switch (type) {
            case ERASE: {
                SoundManager.playSound(Sounds.KEYBOARD_ERASE, SoundType.TYPING);
                break;
            }
            case CUT: {
                SoundManager.playSound(Sounds.KEYBOARD_CUT, SoundType.TYPING);
                break;
            }
            case CURSOR: 
            case RETURN: {
                SoundManager.playSound(Sounds.KEYBOARD_MOVE, SoundType.TYPING);
                break;
            }
            case INSERT: {
                SoundManager.playSound(Sounds.KEYBOARD_TYPE, SoundType.TYPING);
                break;
            }
            case PASTE: {
                SoundManager.playSound(Sounds.KEYBOARD_PASTE, SoundType.TYPING);
            }
        }
    }

    public static float getSoundVolume(SoundSource source, boolean ... anti) {
        float volume = Minecraft.m_91087_().f_91066_.m_92147_(source);
        if (anti != null && anti.length > 0 && anti[0] && volume == 1.0f) {
            return 0.0f;
        }
        return volume;
    }

    public static enum EffectType {
        ADD,
        REMOVE;

    }

    public static enum KeyType {
        ERASE,
        CUT,
        INSERT,
        PASTE,
        RETURN,
        CURSOR;

    }
}

