/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.objects;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LoggerWrapper {
    private final Logger logger;
    private final Marker markWarn = MarkerManager.getMarker((String)"WARNING");
    private final Marker markInfo = MarkerManager.getMarker((String)"INFO");
    private final Marker markLog = MarkerManager.getMarker((String)"LOG");
    private final Marker markDebug = MarkerManager.getMarker((String)"DEBUG");
    private final Marker markFatal = MarkerManager.getMarker((String)"FATAL");
    private final Marker markError = MarkerManager.getMarker((String)"ERROR");

    public LoggerWrapper(String name) {
        this.logger = LogManager.getLogger((String)name);
    }

    public Logger getInternal() {
        return this.logger;
    }

    public void info(String line) {
        this.logger.info(this.markInfo, line);
    }

    public void log(String line) {
        this.logger.info(this.markLog, line);
    }

    public void debug(String line) {
        this.logger.debug(this.markDebug, line);
    }

    public void warn(String line) {
        this.logger.warn(this.markWarn, line);
    }

    public void fatal(String line) {
        this.logger.fatal(this.markFatal, line);
    }

    public void error(String line) {
        this.logger.error(this.markError, line);
    }

    public void catching(Throwable ex) {
        this.logger.catching(ex);
    }
}

