/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items.generic;

import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.client.models.UnseenArmorModel;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class ItemBaseArmor
extends ArmorItem
implements ICreativeTabMember {
    @OnlyIn(value=Dist.CLIENT)
    private HumanoidModel<?> model;

    public ItemBaseArmor(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public ItemBaseArmor(ArmorMaterial materialIn, ArmorItem.Type slot) {
        this(materialIn, slot, ItemBaseArmor.getDefaultProperties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> original) {
                return ItemBaseArmor.this.provideArmorModelForSlot(armorSlot, original);
            }
        });
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel<?> provideArmorModelForSlot(EquipmentSlot slot, HumanoidModel<?> original) {
        return this.model != null ? this.model : (this.model = new UnseenArmorModel(original));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "enigmaticlegacy:textures/models/armor/unseen_armor.png";
    }

    public boolean hasFullSet(@Nonnull Player player) {
        if (player == null) {
            return false;
        }
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41720_().getClass() == this.getClass()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }

    public static Item.Properties getDefaultProperties() {
        Item.Properties props = new Item.Properties();
        props.m_41487_(1);
        props.m_41497_(Rarity.COMMON);
        return props;
    }
}

