/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticDamageTypes;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;

public class VoidPearl
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.DoubleParameter baseDarknessDamage;
    public static Omniconfig.DoubleParameter regenerationDemodifier;
    public static Omniconfig.DoubleParameter shadowRange;
    public static Omniconfig.PerhapsParameter undeadProbability;
    public static Omniconfig.IntParameter witheringTime;
    public static Omniconfig.IntParameter witheringLevel;
    public List<ResourceKey<DamageType>> healList = new ArrayList<ResourceKey<DamageType>>();

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("VoidPearl");
        spellstoneCooldown = builder.comment("Active ability cooldown for Pearl of the Void. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 0);
        baseDarknessDamage = builder.comment("Base damage dealt by Darkness every half a second, when it devours a creature in proximity of bearer of the pearl.").max(1000.0).getDouble("BaseDarknessDamage", 4.0);
        regenerationDemodifier = builder.comment("Modifier for slowing down player's regeneration when bearing the pearl. This includes natural regeneration, as well as artificial healing effects that work over time. The greater it is, the slower player will regenerate.").max(1000.0).getDouble("RegenerationModifier", 1.0);
        shadowRange = builder.comment("Range in which Pearl of the Void will force darkness to devour living creatures.").max(128.0).getDouble("ShadowRange", 16.0);
        undeadProbability = builder.comment("Chance for Pearl of the Void to prevent it's bearer death from receiving lethal amout of damage. Defined as percentage.").max(100.0).getPerhaps("UndeadChance", 35);
        witheringTime = builder.comment("Amout of ticks for which bearer of the pearl will apply Withering effect to entities they attack. 20 ticks equals to 1 second.").getInt("WitheringTime", 100);
        witheringLevel = builder.comment("Level of Withering that bearer of the pearl will apply to entitities they attack.").max(3.0).getInt("WitheringLevel", 2);
        builder.popPrefix();
    }

    public VoidPearl() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
        this.immunityList.add(DamageTypes.f_268722_);
        this.immunityList.add(DamageTypes.f_268612_);
        this.healList.add((ResourceKey<DamageType>)DamageTypes.f_268493_);
        this.healList.add((ResourceKey<DamageType>)DamageTypes.f_268515_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearlCooldown", ChatFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl12");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl13", ChatFormatting.GOLD, undeadProbability.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl14");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ChatFormatting.LIGHT_PURPLE, ((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_20146_() < 300) {
                player.m_20301_(300);
            }
            if (player.m_6060_()) {
                player.m_20095_();
            }
            for (MobEffectInstance effect : new ArrayList(player.m_21220_())) {
                if (effect.m_19544_() == MobEffects.f_19611_ ? effect.m_19557_() >= EnigmaticItems.MINING_CHARM.nightVisionDuration - 10 && effect.m_19557_() <= EnigmaticItems.MINING_CHARM.nightVisionDuration : ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_()).equals((Object)new ResourceLocation("mana-and-artifice", "chrono-exhaustion"))) continue;
                player.m_21195_(effect.m_19544_());
            }
            if (player.f_19797_ % 10 == 0) {
                List entities = player.m_9236_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() - shadowRange.getValue(), player.m_20186_() - shadowRange.getValue(), player.m_20189_() - shadowRange.getValue(), player.m_20185_() + shadowRange.getValue(), player.m_20186_() + shadowRange.getValue(), player.m_20189_() + shadowRange.getValue()));
                boolean hasAnimalGuide = SuperpositionHandler.hasItem(player, EnigmaticItems.ANIMAL_GUIDEBOOK);
                if (entities.contains(player)) {
                    entities.remove(player);
                }
                for (LivingEntity victim : entities) {
                    boolean attack;
                    Player playerVictim;
                    if (victim.m_9236_().m_46849_(victim.m_20183_(), 0) >= 3 && (!(victim instanceof Phantom) || victim.m_6060_()) || hasAnimalGuide && EnigmaticItems.ANIMAL_GUIDEBOOK.isProtectedAnimal(victim)) continue;
                    if (victim instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(playerVictim = (Player)victim), EnigmaticItems.VOID_PEARL)) {
                        playerVictim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1, false, true));
                        continue;
                    }
                    if (victim instanceof Player && !player.m_7099_((Player)victim) || !(attack = victim.m_6469_(victim.m_269291_().m_269298_(EnigmaticDamageTypes.DARKNESS, (Entity)player), (float)baseDarknessDamage.getValue()))) continue;
                    player.m_9236_().m_5594_(null, victim.m_20183_(), SoundEvents.f_12228_, SoundSource.PLAYERS, 1.0f, (float)((double)0.3f + Math.random() * 0.4));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1, false, true));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2, false, true));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 160, 2, false, true));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 3, false, true));
                }
            }
        }
    }
}

